package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Handles the texture loading and setting the texture's properties</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html">Qt3DRender::QTextureLoader</a></code></p>
 */
public class QTextureLoader extends io.qt.qt3d.render.QAbstractTexture
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QTextureLoader.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html#mirrored-prop">Qt3DRender::QTextureLoader::<wbr/>mirroredChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="mirrored")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> mirroredChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html#source-prop">Qt3DRender::QTextureLoader::<wbr/>sourceChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="source")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> sourceChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html#QTextureLoader">Qt3DRender::QTextureLoader::<wbr/>QTextureLoader(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QTextureLoader(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QTextureLoader instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html#mirrored-prop">Qt3DRender::QTextureLoader::<wbr/>isMirrored()const</a></code></p>
     */
    @QtPropertyReader(name="mirrored")
    @QtUninvokable
    public final boolean isMirrored(){
        return isMirrored_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isMirrored_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html#setMirrored">Qt3DRender::QTextureLoader::<wbr/>setMirrored(bool)</a></code></p>
     */
    @QtPropertyWriter(name="mirrored")
    public final void setMirrored(boolean mirrored){
        setMirrored_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), mirrored);
    }
    
    private native void setMirrored_native_bool(long __this__nativeId, boolean mirrored);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html#setSource">Qt3DRender::QTextureLoader::<wbr/>setSource(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="source")
    public final void setSource(io.qt.core.@NonNull QUrl source){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    private native void setSource_native_cref_QUrl(long __this__nativeId, long source);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html#source-prop">Qt3DRender::QTextureLoader::<wbr/>source()const</a></code></p>
     */
    @QtPropertyReader(name="source")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QTextureLoader(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QTextureLoader(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QTextureLoader instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QTextureLoader(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QTextureLoader() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isMirrored()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getMirrored() {
        return isMirrored();
    }
    
    /**
     * <p>Overloaded function for {@link #setSource(io.qt.core.QUrl)}.</p>
     */
    public final void setSource(java.lang.@NonNull String source) {
        setSource(new io.qt.core.QUrl(source));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #source()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getSource() {
        return source();
    }
}
