package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Encapsulates a Shader Program</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html">Qt3DRender::QShaderProgram</a></code></p>
 */
public class QShaderProgram extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QShaderProgram.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#Format-enum">Qt3DRender::QShaderProgram::Format</a></code></p>
     */
    public enum Format implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#Format-enum">Qt3DRender::<wbr/>QShaderProgram::<wbr/>GLSL</a></code></p>
         */
        GLSL(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#Format-enum">Qt3DRender::<wbr/>QShaderProgram::<wbr/>SPIRV</a></code></p>
         */
        SPIRV(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Format(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Format resolve(int value) {
            switch (value) {
            case 0: return GLSL;
            case 1: return SPIRV;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#ShaderType-enum">Qt3DRender::QShaderProgram::ShaderType</a></code></p>
     */
    public enum ShaderType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#ShaderType-enum">Qt3DRender::<wbr/>QShaderProgram::<wbr/>Vertex</a></code></p>
         */
        Vertex(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#ShaderType-enum">Qt3DRender::<wbr/>QShaderProgram::<wbr/>Fragment</a></code></p>
         */
        Fragment(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#ShaderType-enum">Qt3DRender::<wbr/>QShaderProgram::<wbr/>TessellationControl</a></code></p>
         */
        TessellationControl(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#ShaderType-enum">Qt3DRender::<wbr/>QShaderProgram::<wbr/>TessellationEvaluation</a></code></p>
         */
        TessellationEvaluation(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#ShaderType-enum">Qt3DRender::<wbr/>QShaderProgram::<wbr/>Geometry</a></code></p>
         */
        Geometry(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#ShaderType-enum">Qt3DRender::<wbr/>QShaderProgram::<wbr/>Compute</a></code></p>
         */
        Compute(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ShaderType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ShaderType resolve(int value) {
            switch (value) {
            case 0: return Vertex;
            case 1: return Fragment;
            case 2: return TessellationControl;
            case 3: return TessellationEvaluation;
            case 4: return Geometry;
            case 5: return Compute;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#Status-enum">Qt3DRender::QShaderProgram::Status</a></code></p>
     */
    public enum Status implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#Status-enum">Qt3DRender::<wbr/>QShaderProgram::<wbr/>NotReady</a></code></p>
         */
        NotReady(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#Status-enum">Qt3DRender::<wbr/>QShaderProgram::<wbr/>Ready</a></code></p>
         */
        Ready(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#Status-enum">Qt3DRender::<wbr/>QShaderProgram::<wbr/>Error</a></code></p>
         */
        Error(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Status resolve(int value) {
            switch (value) {
            case 0: return NotReady;
            case 1: return Ready;
            case 2: return Error;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#computeShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>computeShaderCodeChanged(QByteArray)</a></code></p>
     */
    @QtPropertyNotify(name="computeShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> computeShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#format-prop">Qt3DRender::QShaderProgram::<wbr/>formatChanged(Qt3DRender::QShaderProgram::Format)</a></code></p>
     */
    @QtPropertyNotify(name="format")
    public final @NonNull Signal1<io.qt.qt3d.render.QShaderProgram.@NonNull Format> formatChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#fragmentShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>fragmentShaderCodeChanged(QByteArray)</a></code></p>
     */
    @QtPropertyNotify(name="fragmentShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> fragmentShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#geometryShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>geometryShaderCodeChanged(QByteArray)</a></code></p>
     */
    @QtPropertyNotify(name="geometryShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> geometryShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#log-prop">Qt3DRender::QShaderProgram::<wbr/>logChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="log")
    public final @NonNull Signal1<java.lang.@NonNull String> logChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#status-prop">Qt3DRender::QShaderProgram::<wbr/>statusChanged(Qt3DRender::QShaderProgram::Status)</a></code></p>
     */
    @QtPropertyNotify(name="status")
    public final @NonNull Signal1<io.qt.qt3d.render.QShaderProgram.@NonNull Status> statusChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#tessellationControlShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>tessellationControlShaderCodeChanged(QByteArray)</a></code></p>
     */
    @QtPropertyNotify(name="tessellationControlShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> tessellationControlShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#tessellationEvaluationShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>tessellationEvaluationShaderCodeChanged(QByteArray)</a></code></p>
     */
    @QtPropertyNotify(name="tessellationEvaluationShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> tessellationEvaluationShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#vertexShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>vertexShaderCodeChanged(QByteArray)</a></code></p>
     */
    @QtPropertyNotify(name="vertexShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> vertexShaderCodeChanged = new Signal1<>();
    
    /**
     * <p>See <code>Qt3DRender::QShaderProgram::<wbr/>QShaderProgram(Qt3DCore::QNode*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public QShaderProgram(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QShaderProgram instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#computeShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>computeShaderCode()const</a></code></p>
     */
    @QtPropertyReader(name="computeShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray computeShaderCode(){
        return computeShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray computeShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#format-prop">Qt3DRender::QShaderProgram::<wbr/>format()const</a></code></p>
     */
    @QtPropertyReader(name="format")
    @QtUninvokable
    public final io.qt.qt3d.render.QShaderProgram.@NonNull Format format(){
        return io.qt.qt3d.render.QShaderProgram.Format.resolve(format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#fragmentShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>fragmentShaderCode()const</a></code></p>
     */
    @QtPropertyReader(name="fragmentShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray fragmentShaderCode(){
        return fragmentShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray fragmentShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#geometryShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>geometryShaderCode()const</a></code></p>
     */
    @QtPropertyReader(name="geometryShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray geometryShaderCode(){
        return geometryShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray geometryShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#log-prop">Qt3DRender::QShaderProgram::<wbr/>log()const</a></code></p>
     */
    @QtPropertyReader(name="log")
    @QtUninvokable
    public final java.lang.@NonNull String log(){
        return log_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String log_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#computeShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>setComputeShaderCode(QByteArray)</a></code></p>
     */
    @QtPropertyWriter(name="computeShaderCode")
    public final void setComputeShaderCode(io.qt.core.@NonNull QByteArray computeShaderCode){
        setComputeShaderCode_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(computeShaderCode));
    }
    
    private native void setComputeShaderCode_native_cref_QByteArray(long __this__nativeId, long computeShaderCode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#format-prop">Qt3DRender::QShaderProgram::<wbr/>setFormat(Qt3DRender::QShaderProgram::Format)</a></code></p>
     */
    @QtPropertyWriter(name="format")
    @QtUninvokable
    public final void setFormat(io.qt.qt3d.render.QShaderProgram.@NonNull Format format){
        setFormat_native_Qt3DRender_QShaderProgram_Format(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @QtUninvokable
    private native void setFormat_native_Qt3DRender_QShaderProgram_Format(long __this__nativeId, int format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#fragmentShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>setFragmentShaderCode(QByteArray)</a></code></p>
     */
    @QtPropertyWriter(name="fragmentShaderCode")
    public final void setFragmentShaderCode(io.qt.core.@NonNull QByteArray fragmentShaderCode){
        setFragmentShaderCode_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(fragmentShaderCode));
    }
    
    private native void setFragmentShaderCode_native_cref_QByteArray(long __this__nativeId, long fragmentShaderCode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#geometryShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>setGeometryShaderCode(QByteArray)</a></code></p>
     */
    @QtPropertyWriter(name="geometryShaderCode")
    public final void setGeometryShaderCode(io.qt.core.@NonNull QByteArray geometryShaderCode){
        setGeometryShaderCode_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(geometryShaderCode));
    }
    
    private native void setGeometryShaderCode_native_cref_QByteArray(long __this__nativeId, long geometryShaderCode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#setShaderCode">Qt3DRender::QShaderProgram::<wbr/>setShaderCode(Qt3DRender::QShaderProgram::ShaderType,<wbr/>QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final void setShaderCode(io.qt.qt3d.render.QShaderProgram.@NonNull ShaderType type, io.qt.core.@NonNull QByteArray shaderCode){
        setShaderCode_native_Qt3DRender_QShaderProgram_ShaderType_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(shaderCode));
    }
    
    @QtUninvokable
    private native void setShaderCode_native_Qt3DRender_QShaderProgram_ShaderType_cref_QByteArray(long __this__nativeId, int type, long shaderCode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#tessellationControlShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>setTessellationControlShaderCode(QByteArray)</a></code></p>
     */
    @QtPropertyWriter(name="tessellationControlShaderCode")
    public final void setTessellationControlShaderCode(io.qt.core.@NonNull QByteArray tessellationControlShaderCode){
        setTessellationControlShaderCode_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(tessellationControlShaderCode));
    }
    
    private native void setTessellationControlShaderCode_native_cref_QByteArray(long __this__nativeId, long tessellationControlShaderCode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#tessellationEvaluationShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>setTessellationEvaluationShaderCode(QByteArray)</a></code></p>
     */
    @QtPropertyWriter(name="tessellationEvaluationShaderCode")
    public final void setTessellationEvaluationShaderCode(io.qt.core.@NonNull QByteArray tessellationEvaluationShaderCode){
        setTessellationEvaluationShaderCode_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(tessellationEvaluationShaderCode));
    }
    
    private native void setTessellationEvaluationShaderCode_native_cref_QByteArray(long __this__nativeId, long tessellationEvaluationShaderCode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#vertexShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>setVertexShaderCode(QByteArray)</a></code></p>
     */
    @QtPropertyWriter(name="vertexShaderCode")
    public final void setVertexShaderCode(io.qt.core.@NonNull QByteArray vertexShaderCode){
        setVertexShaderCode_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(vertexShaderCode));
    }
    
    private native void setVertexShaderCode_native_cref_QByteArray(long __this__nativeId, long vertexShaderCode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#shaderCode">Qt3DRender::QShaderProgram::<wbr/>shaderCode(Qt3DRender::QShaderProgram::ShaderType)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray shaderCode(io.qt.qt3d.render.QShaderProgram.@NonNull ShaderType type){
        return shaderCode_native_Qt3DRender_QShaderProgram_ShaderType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray shaderCode_native_Qt3DRender_QShaderProgram_ShaderType_constfct(long __this__nativeId, int type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#status">Qt3DRender::QShaderProgram::<wbr/>status()const</a></code></p>
     */
    @QtPropertyReader(name="status")
    @QtUninvokable
    public final io.qt.qt3d.render.QShaderProgram.@NonNull Status status(){
        return io.qt.qt3d.render.QShaderProgram.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#tessellationControlShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>tessellationControlShaderCode()const</a></code></p>
     */
    @QtPropertyReader(name="tessellationControlShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray tessellationControlShaderCode(){
        return tessellationControlShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray tessellationControlShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#tessellationEvaluationShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>tessellationEvaluationShaderCode()const</a></code></p>
     */
    @QtPropertyReader(name="tessellationEvaluationShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray tessellationEvaluationShaderCode(){
        return tessellationEvaluationShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray tessellationEvaluationShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#vertexShaderCode-prop">Qt3DRender::QShaderProgram::<wbr/>vertexShaderCode()const</a></code></p>
     */
    @QtPropertyReader(name="vertexShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray vertexShaderCode(){
        return vertexShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray vertexShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#loadSource">Qt3DRender::QShaderProgram::<wbr/>loadSource(QUrl)</a></code></p>
     */
    public static io.qt.core.@NonNull QByteArray loadSource(io.qt.core.@NonNull QUrl sourceUrl){
        return loadSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.checkedNativeId(sourceUrl));
    }
    
    private native static io.qt.core.QByteArray loadSource_native_cref_QUrl(long sourceUrl);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QShaderProgram(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QShaderProgram(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QShaderProgram instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QShaderProgram(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QShaderProgram() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #computeShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getComputeShaderCode() {
        return computeShaderCode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #format()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QShaderProgram.@NonNull Format getFormat() {
        return format();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #fragmentShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getFragmentShaderCode() {
        return fragmentShaderCode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #geometryShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getGeometryShaderCode() {
        return geometryShaderCode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #log()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getLog() {
        return log();
    }
    
    /**
     * <p>Overloaded function for {@link #setComputeShaderCode(io.qt.core.QByteArray)}.</p>
     */
    public final void setComputeShaderCode(byte @NonNull[] computeShaderCode) {
        setComputeShaderCode(new io.qt.core.QByteArray(computeShaderCode));
    }
    
    /**
     * <p>Overloaded function for {@link #setFragmentShaderCode(io.qt.core.QByteArray)}.</p>
     */
    public final void setFragmentShaderCode(byte @NonNull[] fragmentShaderCode) {
        setFragmentShaderCode(new io.qt.core.QByteArray(fragmentShaderCode));
    }
    
    /**
     * <p>Overloaded function for {@link #setGeometryShaderCode(io.qt.core.QByteArray)}.</p>
     */
    public final void setGeometryShaderCode(byte @NonNull[] geometryShaderCode) {
        setGeometryShaderCode(new io.qt.core.QByteArray(geometryShaderCode));
    }
    
    /**
     * <p>Overloaded function for {@link #setShaderCode(io.qt.qt3d.render.QShaderProgram.ShaderType, io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final void setShaderCode(io.qt.qt3d.render.QShaderProgram.@NonNull ShaderType type, byte @NonNull[] shaderCode) {
        setShaderCode(type, new io.qt.core.QByteArray(shaderCode));
    }
    
    /**
     * <p>Overloaded function for {@link #setTessellationControlShaderCode(io.qt.core.QByteArray)}.</p>
     */
    public final void setTessellationControlShaderCode(byte @NonNull[] tessellationControlShaderCode) {
        setTessellationControlShaderCode(new io.qt.core.QByteArray(tessellationControlShaderCode));
    }
    
    /**
     * <p>Overloaded function for {@link #setTessellationEvaluationShaderCode(io.qt.core.QByteArray)}.</p>
     */
    public final void setTessellationEvaluationShaderCode(byte @NonNull[] tessellationEvaluationShaderCode) {
        setTessellationEvaluationShaderCode(new io.qt.core.QByteArray(tessellationEvaluationShaderCode));
    }
    
    /**
     * <p>Overloaded function for {@link #setVertexShaderCode(io.qt.core.QByteArray)}.</p>
     */
    public final void setVertexShaderCode(byte @NonNull[] vertexShaderCode) {
        setVertexShaderCode(new io.qt.core.QByteArray(vertexShaderCode));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #status()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QShaderProgram.@NonNull Status getStatus() {
        return status();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #tessellationControlShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getTessellationControlShaderCode() {
        return tessellationControlShaderCode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #tessellationEvaluationShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getTessellationEvaluationShaderCode() {
        return tessellationEvaluationShaderCode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #vertexShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getVertexShaderCode() {
        return vertexShaderCode();
    }
    
    /**
     * <p>Overloaded function for {@link #loadSource(io.qt.core.QUrl)}.</p>
     */
    public static io.qt.core.@NonNull QByteArray loadSource(java.lang.@NonNull String sourceUrl) {
        return loadSource(new io.qt.core.QUrl(sourceUrl));
    }
}
