package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Provides the facility to load an existing Scene</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html">Qt3DRender::QSceneLoader</a></code></p>
 */
public class QSceneLoader extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSceneLoader.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#ComponentType-enum">Qt3DRender::QSceneLoader::ComponentType</a></code></p>
     */
    public enum ComponentType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#ComponentType-enum">Qt3DRender::<wbr/>QSceneLoader::<wbr/>UnknownComponent</a></code></p>
         */
        UnknownComponent(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#ComponentType-enum">Qt3DRender::<wbr/>QSceneLoader::<wbr/>GeometryRendererComponent</a></code></p>
         */
        GeometryRendererComponent(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#ComponentType-enum">Qt3DRender::<wbr/>QSceneLoader::<wbr/>TransformComponent</a></code></p>
         */
        TransformComponent(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#ComponentType-enum">Qt3DRender::<wbr/>QSceneLoader::<wbr/>MaterialComponent</a></code></p>
         */
        MaterialComponent(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#ComponentType-enum">Qt3DRender::<wbr/>QSceneLoader::<wbr/>LightComponent</a></code></p>
         */
        LightComponent(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#ComponentType-enum">Qt3DRender::<wbr/>QSceneLoader::<wbr/>CameraLensComponent</a></code></p>
         */
        CameraLensComponent(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ComponentType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ComponentType resolve(int value) {
            switch (value) {
            case 0: return UnknownComponent;
            case 1: return GeometryRendererComponent;
            case 2: return TransformComponent;
            case 3: return MaterialComponent;
            case 4: return LightComponent;
            case 5: return CameraLensComponent;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#Status-enum">Qt3DRender::QSceneLoader::Status</a></code></p>
     */
    public enum Status implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#Status-enum">Qt3DRender::<wbr/>QSceneLoader::<wbr/>None</a></code></p>
         */
        None(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#Status-enum">Qt3DRender::<wbr/>QSceneLoader::<wbr/>Loading</a></code></p>
         */
        Loading(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#Status-enum">Qt3DRender::<wbr/>QSceneLoader::<wbr/>Ready</a></code></p>
         */
        Ready(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#Status-enum">Qt3DRender::<wbr/>QSceneLoader::<wbr/>Error</a></code></p>
         */
        Error(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Status resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return Loading;
            case 2: return Ready;
            case 3: return Error;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#source-prop">Qt3DRender::QSceneLoader::<wbr/>sourceChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="source")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> sourceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#status-prop">Qt3DRender::QSceneLoader::<wbr/>statusChanged(Qt3DRender::QSceneLoader::Status)</a></code></p>
     */
    @QtPropertyNotify(name="status")
    public final @NonNull Signal1<io.qt.qt3d.render.QSceneLoader.@NonNull Status> statusChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#QSceneLoader">Qt3DRender::QSceneLoader::<wbr/>QSceneLoader(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QSceneLoader(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSceneLoader instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#component">Qt3DRender::QSceneLoader::<wbr/>component(QString,<wbr/>Qt3DRender::QSceneLoader::ComponentType)const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.qt3d.core.@Nullable QComponent component(java.lang.@NonNull String entityName, io.qt.qt3d.render.QSceneLoader.@NonNull ComponentType componentType){
        return component_native_cref_QString_Qt3DRender_QSceneLoader_ComponentType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), entityName, componentType.value());
    }
    
    private native io.qt.qt3d.core.QComponent component_native_cref_QString_Qt3DRender_QSceneLoader_ComponentType_constfct(long __this__nativeId, java.lang.String entityName, int componentType);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#entity">Qt3DRender::QSceneLoader::<wbr/>entity(QString)const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.qt3d.core.@Nullable QEntity entity(java.lang.@NonNull String entityName){
        return entity_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), entityName);
    }
    
    private native io.qt.qt3d.core.QEntity entity_native_cref_QString_constfct(long __this__nativeId, java.lang.String entityName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#entityNames">Qt3DRender::QSceneLoader::<wbr/>entityNames()const</a></code></p>
     */
    public final io.qt.core.@NonNull QStringList entityNames(){
        return entityNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.core.QStringList entityNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#source-prop">Qt3DRender::QSceneLoader::<wbr/>setSource(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="source")
    public final void setSource(io.qt.core.@NonNull QUrl arg){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg));
    }
    
    private native void setSource_native_cref_QUrl(long __this__nativeId, long arg);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#source-prop">Qt3DRender::QSceneLoader::<wbr/>source()const</a></code></p>
     */
    @QtPropertyReader(name="source")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#status-prop">Qt3DRender::QSceneLoader::<wbr/>status()const</a></code></p>
     */
    @QtPropertyReader(name="status")
    @QtUninvokable
    public final io.qt.qt3d.render.QSceneLoader.@NonNull Status status(){
        return io.qt.qt3d.render.QSceneLoader.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSceneLoader(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QSceneLoader(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSceneLoader instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QSceneLoader(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QSceneLoader() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded function for {@link #setSource(io.qt.core.QUrl)}.</p>
     */
    public final void setSource(java.lang.@NonNull String arg) {
        setSource(new io.qt.core.QUrl(arg));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #source()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getSource() {
        return source();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #status()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QSceneLoader.@NonNull Status getStatus() {
        return status();
    }
}
