package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Specifies how entity picking is handled</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html">Qt3DRender::QPickingSettings</a></code></p>
 */
public class QPickingSettings extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPickingSettings.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#FaceOrientationPickingMode-enum">Qt3DRender::QPickingSettings::FaceOrientationPickingMode</a></code></p>
     */
    public enum FaceOrientationPickingMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#FaceOrientationPickingMode-enum">Qt3DRender::<wbr/>QPickingSettings::<wbr/>FrontFace</a></code></p>
         */
        FrontFace(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#FaceOrientationPickingMode-enum">Qt3DRender::<wbr/>QPickingSettings::<wbr/>BackFace</a></code></p>
         */
        BackFace(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#FaceOrientationPickingMode-enum">Qt3DRender::<wbr/>QPickingSettings::<wbr/>FrontAndBackFace</a></code></p>
         */
        FrontAndBackFace(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FaceOrientationPickingMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FaceOrientationPickingMode resolve(int value) {
            switch (value) {
            case 1: return FrontFace;
            case 2: return BackFace;
            case 3: return FrontAndBackFace;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#PickMethod-enum">Qt3DRender::QPickingSettings::PickMethod</a></code></p>
     */
    public enum PickMethod implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#PickMethod-enum">Qt3DRender::<wbr/>QPickingSettings::<wbr/>BoundingVolumePicking</a></code></p>
         */
        BoundingVolumePicking(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#PickMethod-enum">Qt3DRender::<wbr/>QPickingSettings::<wbr/>TrianglePicking</a></code></p>
         */
        TrianglePicking(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#PickMethod-enum">Qt3DRender::<wbr/>QPickingSettings::<wbr/>LinePicking</a></code></p>
         */
        LinePicking(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#PickMethod-enum">Qt3DRender::<wbr/>QPickingSettings::<wbr/>PointPicking</a></code></p>
         */
        PointPicking(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#PickMethod-enum">Qt3DRender::<wbr/>QPickingSettings::<wbr/>PrimitivePicking</a></code></p>
         */
        PrimitivePicking(7);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PickMethod(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PickMethod resolve(int value) {
            switch (value) {
            case 0: return BoundingVolumePicking;
            case 1: return TrianglePicking;
            case 2: return LinePicking;
            case 4: return PointPicking;
            case 7: return PrimitivePicking;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#PickResultMode-enum">Qt3DRender::QPickingSettings::PickResultMode</a></code></p>
     */
    public enum PickResultMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#PickResultMode-enum">Qt3DRender::<wbr/>QPickingSettings::<wbr/>NearestPick</a></code></p>
         */
        NearestPick(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#PickResultMode-enum">Qt3DRender::<wbr/>QPickingSettings::<wbr/>AllPicks</a></code></p>
         */
        AllPicks(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#PickResultMode-enum">Qt3DRender::<wbr/>QPickingSettings::<wbr/>NearestPriorityPick</a></code></p>
         */
        NearestPriorityPick(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PickResultMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PickResultMode resolve(int value) {
            switch (value) {
            case 0: return NearestPick;
            case 1: return AllPicks;
            case 2: return NearestPriorityPick;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#faceOrientationPickingMode-prop">Qt3DRender::QPickingSettings::<wbr/>faceOrientationPickingModeChanged(Qt3DRender::QPickingSettings::FaceOrientationPickingMode)</a></code></p>
     */
    @QtPropertyNotify(name="faceOrientationPickingMode")
    public final @NonNull Signal1<io.qt.qt3d.render.QPickingSettings.@NonNull FaceOrientationPickingMode> faceOrientationPickingModeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#pickMethod-prop">Qt3DRender::QPickingSettings::<wbr/>pickMethodChanged(Qt3DRender::QPickingSettings::PickMethod)</a></code></p>
     */
    @QtPropertyNotify(name="pickMethod")
    public final @NonNull Signal1<io.qt.qt3d.render.QPickingSettings.@NonNull PickMethod> pickMethodChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#pickResultMode-prop">Qt3DRender::QPickingSettings::<wbr/>pickResultModeChanged(Qt3DRender::QPickingSettings::PickResultMode)</a></code></p>
     */
    @QtPropertyNotify(name="pickResultMode")
    public final @NonNull Signal1<io.qt.qt3d.render.QPickingSettings.@NonNull PickResultMode> pickResultModeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#worldSpaceTolerance-prop">Qt3DRender::QPickingSettings::<wbr/>worldSpaceToleranceChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="worldSpaceTolerance")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> worldSpaceToleranceChanged = new Signal1<>();
    
    /**
     * <p>See <code>Qt3DRender::QPickingSettings::<wbr/>QPickingSettings(Qt3DCore::QNode*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public QPickingSettings(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPickingSettings instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#faceOrientationPickingMode-prop">Qt3DRender::QPickingSettings::<wbr/>faceOrientationPickingMode()const</a></code></p>
     */
    @QtPropertyReader(name="faceOrientationPickingMode")
    @QtUninvokable
    public final io.qt.qt3d.render.QPickingSettings.@NonNull FaceOrientationPickingMode faceOrientationPickingMode(){
        return io.qt.qt3d.render.QPickingSettings.FaceOrientationPickingMode.resolve(faceOrientationPickingMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int faceOrientationPickingMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#pickMethod-prop">Qt3DRender::QPickingSettings::<wbr/>pickMethod()const</a></code></p>
     */
    @QtPropertyReader(name="pickMethod")
    @QtUninvokable
    public final io.qt.qt3d.render.QPickingSettings.@NonNull PickMethod pickMethod(){
        return io.qt.qt3d.render.QPickingSettings.PickMethod.resolve(pickMethod_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int pickMethod_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#pickResultMode-prop">Qt3DRender::QPickingSettings::<wbr/>pickResultMode()const</a></code></p>
     */
    @QtPropertyReader(name="pickResultMode")
    @QtUninvokable
    public final io.qt.qt3d.render.QPickingSettings.@NonNull PickResultMode pickResultMode(){
        return io.qt.qt3d.render.QPickingSettings.PickResultMode.resolve(pickResultMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int pickResultMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#faceOrientationPickingMode-prop">Qt3DRender::QPickingSettings::<wbr/>setFaceOrientationPickingMode(Qt3DRender::QPickingSettings::FaceOrientationPickingMode)</a></code></p>
     */
    @QtPropertyWriter(name="faceOrientationPickingMode")
    public final void setFaceOrientationPickingMode(io.qt.qt3d.render.QPickingSettings.@NonNull FaceOrientationPickingMode faceOrientationPickingMode){
        setFaceOrientationPickingMode_native_Qt3DRender_QPickingSettings_FaceOrientationPickingMode(QtJambi_LibraryUtilities.internal.nativeId(this), faceOrientationPickingMode.value());
    }
    
    private native void setFaceOrientationPickingMode_native_Qt3DRender_QPickingSettings_FaceOrientationPickingMode(long __this__nativeId, int faceOrientationPickingMode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#pickMethod-prop">Qt3DRender::QPickingSettings::<wbr/>setPickMethod(Qt3DRender::QPickingSettings::PickMethod)</a></code></p>
     */
    @QtPropertyWriter(name="pickMethod")
    public final void setPickMethod(io.qt.qt3d.render.QPickingSettings.@NonNull PickMethod pickMethod){
        setPickMethod_native_Qt3DRender_QPickingSettings_PickMethod(QtJambi_LibraryUtilities.internal.nativeId(this), pickMethod.value());
    }
    
    private native void setPickMethod_native_Qt3DRender_QPickingSettings_PickMethod(long __this__nativeId, int pickMethod);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#pickResultMode-prop">Qt3DRender::QPickingSettings::<wbr/>setPickResultMode(Qt3DRender::QPickingSettings::PickResultMode)</a></code></p>
     */
    @QtPropertyWriter(name="pickResultMode")
    public final void setPickResultMode(io.qt.qt3d.render.QPickingSettings.@NonNull PickResultMode pickResultMode){
        setPickResultMode_native_Qt3DRender_QPickingSettings_PickResultMode(QtJambi_LibraryUtilities.internal.nativeId(this), pickResultMode.value());
    }
    
    private native void setPickResultMode_native_Qt3DRender_QPickingSettings_PickResultMode(long __this__nativeId, int pickResultMode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#setWorldSpaceTolerance">Qt3DRender::QPickingSettings::<wbr/>setWorldSpaceTolerance(float)</a></code></p>
     */
    @QtPropertyWriter(name="worldSpaceTolerance")
    public final void setWorldSpaceTolerance(float worldSpaceTolerance){
        setWorldSpaceTolerance_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), worldSpaceTolerance);
    }
    
    private native void setWorldSpaceTolerance_native_float(long __this__nativeId, float worldSpaceTolerance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickingsettings.html#worldSpaceTolerance">Qt3DRender::QPickingSettings::<wbr/>worldSpaceTolerance()const</a></code></p>
     */
    @QtPropertyReader(name="worldSpaceTolerance")
    @QtUninvokable
    public final float worldSpaceTolerance(){
        return worldSpaceTolerance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float worldSpaceTolerance_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPickingSettings(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QPickingSettings(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPickingSettings instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QPickingSettings(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QPickingSettings() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #faceOrientationPickingMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QPickingSettings.@NonNull FaceOrientationPickingMode getFaceOrientationPickingMode() {
        return faceOrientationPickingMode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #pickMethod()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QPickingSettings.@NonNull PickMethod getPickMethod() {
        return pickMethod();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #pickResultMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QPickingSettings.@NonNull PickResultMode getPickResultMode() {
        return pickResultMode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #worldSpaceTolerance()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getWorldSpaceTolerance() {
        return worldSpaceTolerance();
    }
}
