package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>A custom mesh loader</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html">Qt3DRender::QMesh</a></code></p>
 */
public class QMesh extends io.qt.qt3d.render.QGeometryRenderer
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMesh.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html#Status-enum">Qt3DRender::QMesh::Status</a></code></p>
     */
    public enum Status implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html#Status-enum">Qt3DRender::<wbr/>QMesh::<wbr/>None</a></code></p>
         */
        None(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html#Status-enum">Qt3DRender::<wbr/>QMesh::<wbr/>Loading</a></code></p>
         */
        Loading(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html#Status-enum">Qt3DRender::<wbr/>QMesh::<wbr/>Ready</a></code></p>
         */
        Ready(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html#Status-enum">Qt3DRender::<wbr/>QMesh::<wbr/>Error</a></code></p>
         */
        Error(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Status resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return Loading;
            case 2: return Ready;
            case 3: return Error;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html#meshName-prop">Qt3DRender::QMesh::<wbr/>meshNameChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="meshName")
    public final @NonNull Signal1<java.lang.@NonNull String> meshNameChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html#source-prop">Qt3DRender::QMesh::<wbr/>sourceChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="source")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> sourceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html#status-prop">Qt3DRender::QMesh::<wbr/>statusChanged(Qt3DRender::QMesh::Status)</a></code></p>
     */
    @QtPropertyNotify(name="status")
    public final @NonNull Signal1<io.qt.qt3d.render.QMesh.@NonNull Status> statusChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html#QMesh">Qt3DRender::QMesh::<wbr/>QMesh(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QMesh(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMesh instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html#meshName-prop">Qt3DRender::QMesh::<wbr/>meshName()const</a></code></p>
     */
    @QtPropertyReader(name="meshName")
    @QtUninvokable
    public final java.lang.@NonNull String meshName(){
        return meshName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String meshName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html#meshName-prop">Qt3DRender::QMesh::<wbr/>setMeshName(QString)</a></code></p>
     */
    @QtPropertyWriter(name="meshName")
    public final void setMeshName(java.lang.@NonNull String meshName){
        setMeshName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), meshName);
    }
    
    private native void setMeshName_native_cref_QString(long __this__nativeId, java.lang.String meshName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html#source-prop">Qt3DRender::QMesh::<wbr/>setSource(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="source")
    public final void setSource(io.qt.core.@NonNull QUrl source){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    private native void setSource_native_cref_QUrl(long __this__nativeId, long source);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html#source-prop">Qt3DRender::QMesh::<wbr/>source()const</a></code></p>
     */
    @QtPropertyReader(name="source")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmesh.html#status-prop">Qt3DRender::QMesh::<wbr/>status()const</a></code></p>
     */
    @QtPropertyReader(name="status")
    @QtUninvokable
    public final io.qt.qt3d.render.QMesh.@NonNull Status status(){
        return io.qt.qt3d.render.QMesh.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QMesh(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QMesh(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QMesh instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QMesh(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QMesh() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #meshName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getMeshName() {
        return meshName();
    }
    
    /**
     * <p>Overloaded function for {@link #setSource(io.qt.core.QUrl)}.</p>
     */
    public final void setSource(java.lang.@NonNull String source) {
        setSource(new io.qt.core.QUrl(source));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #source()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getSource() {
        return source();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #status()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QMesh.@NonNull Status getStatus() {
        return status();
    }
}
