package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Provides texture image data for QAbstractTextureImage</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedatagenerator.html">Qt3DRender::QTextureImageDataGenerator</a></code></p>
 */
public interface QTextureImageDataGenerator extends QtObjectInterface, io.qt.qt3d.core.QAbstractFunctor
{
    /**
     * @hidden
     * <p>Implementor class for interface {@link io.qt.qt3d.render.QTextureImageDataGenerator}</p>
     */
    public static abstract class Impl extends QtObject
        implements io.qt.qt3d.render.QTextureImageDataGenerator,
                io.qt.qt3d.core.QAbstractFunctor
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @NativeAccess
        private static final class ConcreteWrapper extends QTextureImageDataGenerator.Impl {
            
            @NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @QtUninvokable
            public io.qt.qt3d.render.@Nullable QTextureImageData invoke(){
                return invoke_native(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            private native static io.qt.qt3d.render.QTextureImageData invoke_native(long __this__nativeId);
            
            
            @Override
            @QtUninvokable
            public boolean equals(io.qt.qt3d.render.@StrictNonNull QTextureImageDataGenerator other){
                java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
                return equals_native_cref_Qt3DRender_QTextureImageDataGenerator_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
            }
            private native static boolean equals_native_cref_Qt3DRender_QTextureImageDataGenerator_constfct(long __this__nativeId, long other);
            
        }
        
        
        /**
         * <p>See <code>Qt3DRender::QTextureImageDataGenerator::<wbr>QTextureImageDataGenerator()</code></p>
         */
        public Impl(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QTextureImageDataGenerator instance);
        
        /**
         * <p>Delegate for {@link #invoke()}.</p>
         */
        @QtUninvokable
        public final io.qt.qt3d.render.@Nullable QTextureImageData get() {
            return invoke();
        }
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedatagenerator.html#operator-28-29">Qt3DRender::QTextureImageDataGenerator::<wbr>operator()()</a></code></p>
         */
        @QtUninvokable
        public abstract io.qt.qt3d.render.@Nullable QTextureImageData invoke();
        
        private native static io.qt.qt3d.render.QTextureImageData invoke_native(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedatagenerator.html#operator-eq-eq">Qt3DRender::QTextureImageDataGenerator::<wbr>operator==(Qt3DRender::QTextureImageDataGenerator)const</a></code></p>
         */
        @QtUninvokable
        public abstract boolean equals(io.qt.qt3d.render.@StrictNonNull QTextureImageDataGenerator other);
        
        private native static boolean equals_native_cref_Qt3DRender_QTextureImageDataGenerator_constfct(long __this__nativeId, long other);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected Impl(QPrivateConstructor p) { super(p); } 
        

        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedatagenerator.html#operator-eq-eq">Qt3DRender::QTextureImageDataGenerator::<wbr></a></code></p>
         */
        @Override
        @QtUninvokable
        public boolean equals(Object other) {
            if (other instanceof io.qt.qt3d.render.QTextureImageDataGenerator) {
                return equals((io.qt.qt3d.render.QTextureImageDataGenerator) other);
            }

            return false;
        }

    }

    
    /**
     * <p>Delegate for {@link #invoke()}.</p>
     */
    @QtUninvokable
    public default io.qt.qt3d.render.@Nullable QTextureImageData get() {
        return invoke();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedatagenerator.html#operator-28-29">Qt3DRender::QTextureImageDataGenerator::<wbr>operator()()</a></code></p>
     */
    @QtUninvokable
    public io.qt.qt3d.render.@Nullable QTextureImageData invoke();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedatagenerator.html#operator-eq-eq">Qt3DRender::QTextureImageDataGenerator::<wbr>operator==(Qt3DRender::QTextureImageDataGenerator)const</a></code></p>
     */
    @QtUninvokable
    public default boolean equals(io.qt.qt3d.render.@StrictNonNull QTextureImageDataGenerator other){
        return this==other;
    }
    
}
