package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Holds content and information required to perform partial updates of a texture content</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedataupdate.html">Qt3DRender::QTextureDataUpdate</a></code></p>
 */
public class QTextureDataUpdate extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>QTextureDataUpdate()</code></p>
     */
    public QTextureDataUpdate(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QTextureDataUpdate instance);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>QTextureDataUpdate(Qt3DRender::QTextureDataUpdate)</code></p>
     */
    public QTextureDataUpdate(io.qt.qt3d.render.@NonNull QTextureDataUpdate other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QTextureDataUpdate instance, io.qt.qt3d.render.QTextureDataUpdate other);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>data()const</code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QTextureImageData data(){
        return data_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QTextureImageData data_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>face()const</code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull CubeMapFace face(){
        return io.qt.qt3d.render.QAbstractTexture.CubeMapFace.resolve(face_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int face_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>layer()const</code></p>
     */
    @QtUninvokable
    public final int layer(){
        return layer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int layer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>mipLevel()const</code></p>
     */
    @QtUninvokable
    public final int mipLevel(){
        return mipLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int mipLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>operator=(Qt3DRender::QTextureDataUpdate)</code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.qt3d.render.@NonNull QTextureDataUpdate other){
        assign_native_cref_Qt3DRender_QTextureDataUpdate(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_Qt3DRender_QTextureDataUpdate(long __this__nativeId, long other);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>setData(Qt3DRender::QTextureImageDataPtr)</code></p>
     */
    @QtUninvokable
    public final void setData(io.qt.qt3d.render.@Nullable QTextureImageData data){
        setData_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native void setData_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.render.QTextureImageData data);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>setFace(Qt3DRender::QAbstractTexture::CubeMapFace)</code></p>
     */
    @QtUninvokable
    public final void setFace(io.qt.qt3d.render.QAbstractTexture.@NonNull CubeMapFace face){
        setFace_native_Qt3DRender_QAbstractTexture_CubeMapFace(QtJambi_LibraryUtilities.internal.nativeId(this), face.value());
    }
    
    @QtUninvokable
    private native void setFace_native_Qt3DRender_QAbstractTexture_CubeMapFace(long __this__nativeId, int face);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>setLayer(int)</code></p>
     */
    @QtUninvokable
    public final void setLayer(int layer){
        setLayer_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layer);
    }
    
    @QtUninvokable
    private native void setLayer_native_int(long __this__nativeId, int layer);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>setMipLevel(int)</code></p>
     */
    @QtUninvokable
    public final void setMipLevel(int mipLevel){
        setMipLevel_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevel);
    }
    
    @QtUninvokable
    private native void setMipLevel_native_int(long __this__nativeId, int mipLevel);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>setX(int)</code></p>
     */
    @QtUninvokable
    public final void setX(int x){
        setX_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), x);
    }
    
    @QtUninvokable
    private native void setX_native_int(long __this__nativeId, int x);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>setY(int)</code></p>
     */
    @QtUninvokable
    public final void setY(int y){
        setY_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), y);
    }
    
    @QtUninvokable
    private native void setY_native_int(long __this__nativeId, int y);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>setZ(int)</code></p>
     */
    @QtUninvokable
    public final void setZ(int z){
        setZ_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), z);
    }
    
    @QtUninvokable
    private native void setZ_native_int(long __this__nativeId, int z);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>swap(Qt3DRender::QTextureDataUpdate&amp;)</code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.qt3d.render.@StrictNonNull QTextureDataUpdate other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_Qt3DRender_QTextureDataUpdate(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_Qt3DRender_QTextureDataUpdate(long __this__nativeId, long other);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>x()const</code></p>
     */
    @QtUninvokable
    public final int x(){
        return x_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int x_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>y()const</code></p>
     */
    @QtUninvokable
    public final int y(){
        return y_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int y_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>Qt3DRender::QTextureDataUpdate::<wbr>z()const</code></p>
     */
    @QtUninvokable
    public final int z(){
        return z_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int z_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QTextureDataUpdate(QPrivateConstructor p) { super(p); } 
    

    /**
     * Checks for equality by checking object's hash code.
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if(other instanceof io.qt.qt3d.render.QTextureDataUpdate)
            return hashCode()==other.hashCode();
        else return super.equals(other);    }


    /**
     * Returns the objects's hash code computed by <code>qHash(Qt3DRender::QTextureDataUpdate)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QTextureDataUpdate clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QTextureDataUpdate clone_native(long __this_nativeId);
}
