package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Provides a way of specifying a render target</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetselector.html">Qt3DRender::QRenderTargetSelector</a></code></p>
 */
public class QRenderTargetSelector extends io.qt.qt3d.render.QFrameGraphNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderTargetSelector.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetselector.html#target-prop">Qt3DRender::QRenderTargetSelector::<wbr>targetChanged(Qt3DRender::QRenderTarget*)</a></code></p>
     */
    @QtPropertyNotify(name="target")
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QRenderTarget> targetChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QRenderTargetSelector(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QRenderTargetSelector() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetselector.html#QRenderTargetSelector">Qt3DRender::QRenderTargetSelector::<wbr>QRenderTargetSelector(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QRenderTargetSelector(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRenderTargetSelector instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetselector.html#target-prop">Qt3DRender::QRenderTargetSelector::<wbr>setTarget(Qt3DRender::QRenderTarget*)</a></code></p>
     */
    @QtPropertyWriter(name="target")
    public final void setTarget(io.qt.qt3d.render.@Nullable QRenderTarget target){
        setTarget_native_Qt3DRender_QRenderTarget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
    }
    
    private native void setTarget_native_Qt3DRender_QRenderTarget_ptr(long __this__nativeId, long target);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #target()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QRenderTarget getTarget() {
        return target();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetselector.html#target-prop">Qt3DRender::QRenderTargetSelector::<wbr>target()const</a></code></p>
     */
    @QtPropertyReader(name="target")
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QRenderTarget target(){
        return target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QRenderTarget target_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRenderTargetSelector(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRenderTargetSelector(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRenderTargetSelector instance, QDeclarativeConstructor constructor);
    
}
