package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Provides a way of specifying the render surface</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html">Qt3DRender::QRenderSurfaceSelector</a></code></p>
 */
public class QRenderSurfaceSelector extends io.qt.qt3d.render.QFrameGraphNode
{
    @QtPropertyMember(enabled=false)
    private Object __rcSurfaceObject = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderSurfaceSelector.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#externalRenderTargetSize-prop">Qt3DRender::QRenderSurfaceSelector::<wbr>externalRenderTargetSizeChanged(QSize)</a></code></p>
     */
    @QtPropertyNotify(name="externalRenderTargetSize")
    public final @NonNull Signal1<io.qt.core.@NonNull QSize> externalRenderTargetSizeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#surface-prop">Qt3DRender::QRenderSurfaceSelector::<wbr>surfaceChanged(QObject*)</a></code></p>
     */
    @QtPropertyNotify(name="surface")
    public final @NonNull Signal1<io.qt.core.@Nullable QObject> surfaceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#surfacePixelRatio-prop">Qt3DRender::QRenderSurfaceSelector::<wbr>surfacePixelRatioChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="surfacePixelRatio")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> surfacePixelRatioChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QRenderSurfaceSelector(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QRenderSurfaceSelector() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#QRenderSurfaceSelector">Qt3DRender::QRenderSurfaceSelector::<wbr>QRenderSurfaceSelector(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QRenderSurfaceSelector(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRenderSurfaceSelector instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #externalRenderTargetSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QSize getExternalRenderTargetSize() {
        return externalRenderTargetSize();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#externalRenderTargetSize-prop">Qt3DRender::QRenderSurfaceSelector::<wbr>externalRenderTargetSize()const</a></code></p>
     */
    @QtPropertyReader(name="externalRenderTargetSize")
    @QtUninvokable
    public final io.qt.core.@NonNull QSize externalRenderTargetSize(){
        return externalRenderTargetSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize externalRenderTargetSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#setExternalRenderTargetSize">Qt3DRender::QRenderSurfaceSelector::<wbr>setExternalRenderTargetSize(QSize)</a></code></p>
     */
    @QtPropertyWriter(name="externalRenderTargetSize")
    public final void setExternalRenderTargetSize(io.qt.core.@NonNull QSize size){
        setExternalRenderTargetSize_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    private native void setExternalRenderTargetSize_native_cref_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#setSurface">Qt3DRender::QRenderSurfaceSelector::<wbr>setSurface(QObject*)</a></code></p>
     */
    @QtPropertyWriter(name="surface")
    public final void setSurface(io.qt.core.@Nullable QObject surfaceObject){
        setSurface_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(surfaceObject));
        __rcSurfaceObject = surfaceObject;
    }
    
    private native void setSurface_native_QObject_ptr(long __this__nativeId, long surfaceObject);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#surfacePixelRatio-prop">Qt3DRender::QRenderSurfaceSelector::<wbr>setSurfacePixelRatio(float)</a></code></p>
     */
    @QtPropertyWriter(name="surfacePixelRatio")
    public final void setSurfacePixelRatio(float ratio){
        setSurfacePixelRatio_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), ratio);
    }
    
    private native void setSurfacePixelRatio_native_float(long __this__nativeId, float ratio);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #surface()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QObject getSurface() {
        return surface();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#surface-prop">Qt3DRender::QRenderSurfaceSelector::<wbr>surface()const</a></code></p>
     */
    @QtPropertyReader(name="surface")
    @QtUninvokable
    public final io.qt.core.@Nullable QObject surface(){
        return surface_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QObject surface_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #surfacePixelRatio()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getSurfacePixelRatio() {
        return surfacePixelRatio();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#surfacePixelRatio-prop">Qt3DRender::QRenderSurfaceSelector::<wbr>surfacePixelRatio()const</a></code></p>
     */
    @QtPropertyReader(name="surfacePixelRatio")
    @QtUninvokable
    public final float surfacePixelRatio(){
        return surfacePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float surfacePixelRatio_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRenderSurfaceSelector(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRenderSurfaceSelector(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRenderSurfaceSelector instance, QDeclarativeConstructor constructor);
    
}
