package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Provides storage for vectors of Filter Keys and Parameters</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpassfilter.html">Qt3DRender::QRenderPassFilter</a></code></p>
 */
public class QRenderPassFilter extends io.qt.qt3d.render.QFrameGraphNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderPassFilter.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QRenderPassFilter(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QRenderPassFilter() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpassfilter.html#QRenderPassFilter">Qt3DRender::QRenderPassFilter::<wbr>QRenderPassFilter(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QRenderPassFilter(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRenderPassFilter instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpassfilter.html#addMatch">Qt3DRender::QRenderPassFilter::<wbr>addMatch(Qt3DRender::QFilterKey*)</a></code></p>
     */
    @QtUninvokable
    public final void addMatch(io.qt.qt3d.render.@Nullable QFilterKey filterKey){
        addMatch_native_Qt3DRender_QFilterKey_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(filterKey));
    }
    
    @QtUninvokable
    private native void addMatch_native_Qt3DRender_QFilterKey_ptr(long __this__nativeId, long filterKey);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpassfilter.html#addParameter">Qt3DRender::QRenderPassFilter::<wbr>addParameter(Qt3DRender::QParameter*)</a></code></p>
     */
    @QtUninvokable
    public final void addParameter(io.qt.qt3d.render.@Nullable QParameter parameter){
        addParameter_native_Qt3DRender_QParameter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parameter));
    }
    
    @QtUninvokable
    private native void addParameter_native_Qt3DRender_QParameter_ptr(long __this__nativeId, long parameter);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpassfilter.html#matchAny">Qt3DRender::QRenderPassFilter::<wbr>matchAny()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@Nullable QFilterKey> matchAny(){
        return matchAny_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QFilterKey> matchAny_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpassfilter.html#parameters">Qt3DRender::QRenderPassFilter::<wbr>parameters()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@Nullable QParameter> parameters(){
        return parameters_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QParameter> parameters_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpassfilter.html#removeMatch">Qt3DRender::QRenderPassFilter::<wbr>removeMatch(Qt3DRender::QFilterKey*)</a></code></p>
     */
    @QtUninvokable
    public final void removeMatch(io.qt.qt3d.render.@Nullable QFilterKey filterKey){
        removeMatch_native_Qt3DRender_QFilterKey_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(filterKey));
    }
    
    @QtUninvokable
    private native void removeMatch_native_Qt3DRender_QFilterKey_ptr(long __this__nativeId, long filterKey);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpassfilter.html#removeParameter">Qt3DRender::QRenderPassFilter::<wbr>removeParameter(Qt3DRender::QParameter*)</a></code></p>
     */
    @QtUninvokable
    public final void removeParameter(io.qt.qt3d.render.@Nullable QParameter parameter){
        removeParameter_native_Qt3DRender_QParameter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parameter));
    }
    
    @QtUninvokable
    private native void removeParameter_native_Qt3DRender_QParameter_ptr(long __this__nativeId, long parameter);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRenderPassFilter(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRenderPassFilter(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRenderPassFilter instance, QDeclarativeConstructor constructor);
    
}
