package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Frame graph node for render capture</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapture.html">Qt3DRender::QRenderCapture</a></code></p>
 */
public class QRenderCapture extends io.qt.qt3d.render.QFrameGraphNode
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderCapture.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QRenderCapture(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QRenderCapture() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapture.html#QRenderCapture">Qt3DRender::QRenderCapture::<wbr>QRenderCapture(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QRenderCapture(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRenderCapture instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapture.html#requestCapture-1">Qt3DRender::QRenderCapture::<wbr>requestCapture()</a></code></p>
     */
    public final io.qt.qt3d.render.@Nullable QRenderCaptureReply requestCapture(){
        return requestCapture_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.qt3d.render.QRenderCaptureReply requestCapture_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapture.html#requestCapture-2">Qt3DRender::QRenderCapture::<wbr>requestCapture(QRect)</a></code></p>
     */
    public final io.qt.qt3d.render.@Nullable QRenderCaptureReply requestCapture(io.qt.core.@NonNull QRect rect){
        return requestCapture_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    private native io.qt.qt3d.render.QRenderCaptureReply requestCapture_native_cref_QRect(long __this__nativeId, long rect);
    
    /**
     * <p>See <code>Qt3DRender::QRenderCapture::<wbr>requestCapture(int)</code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QRenderCaptureReply requestCapture(int captureId){
        return requestCapture_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), captureId);
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QRenderCaptureReply requestCapture_native_int(long __this__nativeId, int captureId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRenderCapture(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRenderCapture(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRenderCapture instance, QDeclarativeConstructor constructor);
    
}
