package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Encapsulate a Point Light object in a Qt 3D scene</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qpointlight.html">Qt3DRender::QPointLight</a></code></p>
 */
public class QPointLight extends io.qt.qt3d.render.QAbstractLight
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPointLight.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#constantAttenuation-prop">Qt3DRender::QPointLight::<wbr>constantAttenuationChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="constantAttenuation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> constantAttenuationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#linearAttenuation-prop">Qt3DRender::QPointLight::<wbr>linearAttenuationChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="linearAttenuation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> linearAttenuationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#quadraticAttenuation-prop">Qt3DRender::QPointLight::<wbr>quadraticAttenuationChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="quadraticAttenuation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> quadraticAttenuationChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QPointLight(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QPointLight() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#QPointLight">Qt3DRender::QPointLight::<wbr>QPointLight(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QPointLight(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPointLight instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #constantAttenuation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getConstantAttenuation() {
        return constantAttenuation();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#constantAttenuation-prop">Qt3DRender::QPointLight::<wbr>constantAttenuation()const</a></code></p>
     */
    @QtPropertyReader(name="constantAttenuation")
    @QtUninvokable
    public final float constantAttenuation(){
        return constantAttenuation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float constantAttenuation_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #linearAttenuation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getLinearAttenuation() {
        return linearAttenuation();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#linearAttenuation-prop">Qt3DRender::QPointLight::<wbr>linearAttenuation()const</a></code></p>
     */
    @QtPropertyReader(name="linearAttenuation")
    @QtUninvokable
    public final float linearAttenuation(){
        return linearAttenuation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float linearAttenuation_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #quadraticAttenuation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getQuadraticAttenuation() {
        return quadraticAttenuation();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#quadraticAttenuation-prop">Qt3DRender::QPointLight::<wbr>quadraticAttenuation()const</a></code></p>
     */
    @QtPropertyReader(name="quadraticAttenuation")
    @QtUninvokable
    public final float quadraticAttenuation(){
        return quadraticAttenuation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float quadraticAttenuation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#constantAttenuation-prop">Qt3DRender::QPointLight::<wbr>setConstantAttenuation(float)</a></code></p>
     */
    @QtPropertyWriter(name="constantAttenuation")
    public final void setConstantAttenuation(float value){
        setConstantAttenuation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setConstantAttenuation_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#linearAttenuation-prop">Qt3DRender::QPointLight::<wbr>setLinearAttenuation(float)</a></code></p>
     */
    @QtPropertyWriter(name="linearAttenuation")
    public final void setLinearAttenuation(float value){
        setLinearAttenuation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setLinearAttenuation_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#quadraticAttenuation-prop">Qt3DRender::QPointLight::<wbr>setQuadraticAttenuation(float)</a></code></p>
     */
    @QtPropertyWriter(name="quadraticAttenuation")
    public final void setQuadraticAttenuation(float value){
        setQuadraticAttenuation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setQuadraticAttenuation_native_float(long __this__nativeId, float value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPointLight(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QPointLight(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPointLight instance, QDeclarativeConstructor constructor);
    
}
