package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Holds information when an object is picked</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html">Qt3DRender::QPickEvent</a></code></p>
 */
public class QPickEvent extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPickEvent.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Buttons-enum">Qt3DRender::QPickEvent::Buttons</a></code></p>
     */
    public enum Buttons implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Buttons-enum">Qt3DRender::<wbr>QPickEvent::<wbr>LeftButton</a></code></p>
         */
        LeftButton(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Buttons-enum">Qt3DRender::<wbr>QPickEvent::<wbr>RightButton</a></code></p>
         */
        RightButton(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Buttons-enum">Qt3DRender::<wbr>QPickEvent::<wbr>MiddleButton</a></code></p>
         */
        MiddleButton(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Buttons-enum">Qt3DRender::<wbr>QPickEvent::<wbr>BackButton</a></code></p>
         */
        BackButton(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Buttons-enum">Qt3DRender::<wbr>QPickEvent::<wbr>NoButton</a></code></p>
         */
        NoButton(0);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Buttons(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Buttons resolve(int value) {
            switch (value) {
            case 1: return LeftButton;
            case 2: return RightButton;
            case 4: return MiddleButton;
            case 8: return BackButton;
            case 0: return NoButton;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Modifiers-enum">Qt3DRender::QPickEvent::Modifiers</a></code></p>
     */
    public enum Modifiers implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Modifiers-enum">Qt3DRender::<wbr>QPickEvent::<wbr>NoModifier</a></code></p>
         */
        NoModifier(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Modifiers-enum">Qt3DRender::<wbr>QPickEvent::<wbr>ShiftModifier</a></code></p>
         */
        ShiftModifier(33554432),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Modifiers-enum">Qt3DRender::<wbr>QPickEvent::<wbr>ControlModifier</a></code></p>
         */
        ControlModifier(67108864),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Modifiers-enum">Qt3DRender::<wbr>QPickEvent::<wbr>AltModifier</a></code></p>
         */
        AltModifier(134217728),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Modifiers-enum">Qt3DRender::<wbr>QPickEvent::<wbr>MetaModifier</a></code></p>
         */
        MetaModifier(268435456),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Modifiers-enum">Qt3DRender::<wbr>QPickEvent::<wbr>KeypadModifier</a></code></p>
         */
        KeypadModifier(536870912);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Modifiers(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Modifiers resolve(int value) {
            switch (value) {
            case 0: return NoModifier;
            case 33554432: return ShiftModifier;
            case 67108864: return ControlModifier;
            case 134217728: return AltModifier;
            case 268435456: return MetaModifier;
            case 536870912: return KeypadModifier;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#accepted-prop">Qt3DRender::QPickEvent::<wbr>acceptedChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="accepted")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> acceptedChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#QPickEvent">Qt3DRender::QPickEvent::<wbr>QPickEvent()</a></code></p>
     */
    public QPickEvent(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QPickEvent instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#QPickEvent-1">Qt3DRender::QPickEvent::<wbr>QPickEvent(QPointF,<wbr>QVector3D,<wbr>QVector3D,<wbr>float)</a></code></p>
     */
    public QPickEvent(io.qt.core.@NonNull QPointF position, io.qt.gui.@NonNull QVector3D worldIntersection, io.qt.gui.@NonNull QVector3D localIntersection, float distance){
        super((QPrivateConstructor)null);
        initialize_native(this, position, worldIntersection, localIntersection, distance);
    }
    
    private native static void initialize_native(QPickEvent instance, io.qt.core.QPointF position, io.qt.gui.QVector3D worldIntersection, io.qt.gui.QVector3D localIntersection, float distance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#QPickEvent-2">Qt3DRender::QPickEvent::<wbr>QPickEvent(QPointF,<wbr>QVector3D,<wbr>QVector3D,<wbr>float,<wbr>Qt3DRender::QPickEvent::Buttons,<wbr>int,<wbr>int)</a></code></p>
     */
    public QPickEvent(io.qt.core.@NonNull QPointF position, io.qt.gui.@NonNull QVector3D worldIntersection, io.qt.gui.@NonNull QVector3D localIntersection, float distance, io.qt.qt3d.render.QPickEvent.@NonNull Buttons button, int buttons, int modifiers){
        super((QPrivateConstructor)null);
        initialize_native(this, position, worldIntersection, localIntersection, distance, button, buttons, modifiers);
    }
    
    private native static void initialize_native(QPickEvent instance, io.qt.core.QPointF position, io.qt.gui.QVector3D worldIntersection, io.qt.gui.QVector3D localIntersection, float distance, io.qt.qt3d.render.QPickEvent.Buttons button, int buttons, int modifiers);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #button()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QPickEvent.@NonNull Buttons getButton() {
        return button();
    }
    
    /**
     * <p>QPickEvent::button Returns mouse button that caused the event</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#button">Qt3DRender::QPickEvent::<wbr>button()const</a></code></p>
     */
    @QtPropertyReader(name="button")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.render.QPickEvent.@NonNull Buttons button(){
        return io.qt.qt3d.render.QPickEvent.Buttons.resolve(button_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int button_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #buttons()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getButtons() {
        return buttons();
    }
    
    /**
     * <p>QPickEvent::buttons Returns bitfield to be used to check for mouse buttons that may be accompanying the pick event</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#buttons">Qt3DRender::QPickEvent::<wbr>buttons()const</a></code></p>
     */
    @QtPropertyReader(name="buttons")
    @QtPropertyConstant
    @QtUninvokable
    public final int buttons(){
        return buttons_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int buttons_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #distance()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDistance() {
        return distance();
    }
    
    /**
     * <p>QPickEvent::distance Returns distance from camera to pick point</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#distance">Qt3DRender::QPickEvent::<wbr>distance()const</a></code></p>
     */
    @QtPropertyReader(name="distance")
    @QtPropertyConstant
    @QtUninvokable
    public final float distance(){
        return distance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float distance_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #entity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QEntity getEntity() {
        return entity();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#entity-prop">Qt3DRender::QPickEvent::<wbr>entity()const</a></code></p>
     */
    @QtPropertyReader(name="entity")
    @QtPropertyConstant
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QEntity entity(){
        return entity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QEntity entity_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isAccepted()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAccepted() {
        return isAccepted();
    }
    
    /**
     * <p>QPickEvent::isAccepted Returns true if the event has been accepted</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#isAccepted">Qt3DRender::QPickEvent::<wbr>isAccepted()const</a></code></p>
     */
    @QtPropertyReader(name="accepted")
    @QtUninvokable
    public final boolean isAccepted(){
        return isAccepted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAccepted_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #localIntersection()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getLocalIntersection() {
        return localIntersection();
    }
    
    /**
     * <p>QPickEvent::localIntersection Returns coordinates of the hit in the local coordinate system of the picked entity</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#localIntersection">Qt3DRender::QPickEvent::<wbr>localIntersection()const</a></code></p>
     */
    @QtPropertyReader(name="localIntersection")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D localIntersection(){
        return localIntersection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D localIntersection_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #modifiers()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getModifiers() {
        return modifiers();
    }
    
    /**
     * <p>QPickEvent::modifiers Returns bitfield to be used to check for keyboard modifiers that may be accompanying the pick event</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#modifiers">Qt3DRender::QPickEvent::<wbr>modifiers()const</a></code></p>
     */
    @QtPropertyReader(name="modifiers")
    @QtPropertyConstant
    @QtUninvokable
    public final int modifiers(){
        return modifiers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int modifiers_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #position()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPointF getPosition() {
        return position();
    }
    
    /**
     * <p>QPickEvent::position Returns mouse pointer coordinate of the pick query</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#position">Qt3DRender::QPickEvent::<wbr>position()const</a></code></p>
     */
    @QtPropertyReader(name="position")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QPointF position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPointF position_native_constfct(long __this__nativeId);
    
    /**
     * <p>QPickEvent::setAccepted set if the event has been accepted to accepted</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#setAccepted">Qt3DRender::QPickEvent::<wbr>setAccepted(bool)</a></code></p>
     */
    @QtPropertyWriter(name="accepted")
    public final void setAccepted(boolean accepted){
        setAccepted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), accepted);
    }
    
    private native void setAccepted_native_bool(long __this__nativeId, boolean accepted);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #viewport()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QViewport getViewport() {
        return viewport();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#viewport-prop">Qt3DRender::QPickEvent::<wbr>viewport()const</a></code></p>
     */
    @QtPropertyReader(name="viewport")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QViewport viewport(){
        return viewport_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QViewport viewport_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #worldIntersection()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getWorldIntersection() {
        return worldIntersection();
    }
    
    /**
     * <p>QPickEvent::worldIntersection Returns coordinates of the hit in world coordinate system</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#worldIntersection">Qt3DRender::QPickEvent::<wbr>worldIntersection()const</a></code></p>
     */
    @QtPropertyReader(name="worldIntersection")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D worldIntersection(){
        return worldIntersection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D worldIntersection_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPickEvent(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QPickEvent(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPickEvent instance, QDeclarativeConstructor constructor);
    
}
