package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Provides an abstract class that should be the base of all material component classes in a scene</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qmaterial.html">Qt3DRender::QMaterial</a></code></p>
 */
public class QMaterial extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMaterial.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmaterial.html#effect-prop">Qt3DRender::QMaterial::<wbr>effectChanged(Qt3DRender::QEffect*)</a></code></p>
     */
    @QtPropertyNotify(name="effect")
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QEffect> effectChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QMaterial(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QMaterial() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code>Qt3DRender::QMaterial::<wbr>QMaterial(Qt3DCore::QNode*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public QMaterial(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMaterial instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmaterial.html#addParameter">Qt3DRender::QMaterial::<wbr>addParameter(Qt3DRender::QParameter*)</a></code></p>
     */
    @QtUninvokable
    public final void addParameter(io.qt.qt3d.render.@Nullable QParameter parameter){
        addParameter_native_Qt3DRender_QParameter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parameter));
    }
    
    @QtUninvokable
    private native void addParameter_native_Qt3DRender_QParameter_ptr(long __this__nativeId, long parameter);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #effect()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QEffect getEffect() {
        return effect();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmaterial.html#effect-prop">Qt3DRender::QMaterial::<wbr>effect()const</a></code></p>
     */
    @QtPropertyReader(name="effect")
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QEffect effect(){
        return effect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QEffect effect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmaterial.html#parameters">Qt3DRender::QMaterial::<wbr>parameters()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@Nullable QParameter> parameters(){
        return parameters_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QParameter> parameters_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmaterial.html#removeParameter">Qt3DRender::QMaterial::<wbr>removeParameter(Qt3DRender::QParameter*)</a></code></p>
     */
    @QtUninvokable
    public final void removeParameter(io.qt.qt3d.render.@Nullable QParameter parameter){
        removeParameter_native_Qt3DRender_QParameter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parameter));
    }
    
    @QtUninvokable
    private native void removeParameter_native_Qt3DRender_QParameter_ptr(long __this__nativeId, long parameter);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qmaterial.html#effect-prop">Qt3DRender::QMaterial::<wbr>setEffect(Qt3DRender::QEffect*)</a></code></p>
     */
    @QtPropertyWriter(name="effect")
    public final void setEffect(io.qt.qt3d.render.@Nullable QEffect effect){
        setEffect_native_Qt3DRender_QEffect_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(effect));
    }
    
    private native void setEffect_native_Qt3DRender_QEffect_ptr(long __this__nativeId, long effect);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QMaterial(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QMaterial(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QMaterial instance, QDeclarativeConstructor constructor);
    
}
