package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Controls layers drawn in a frame graph branch</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qlayerfilter.html">Qt3DRender::QLayerFilter</a></code></p>
 */
public class QLayerFilter extends io.qt.qt3d.render.QFrameGraphNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QLayerFilter.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qlayerfilter.html#FilterMode-enum">Qt3DRender::QLayerFilter::FilterMode</a></code></p>
     */
    public enum FilterMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qlayerfilter.html#FilterMode-enum">Qt3DRender::<wbr>QLayerFilter::<wbr>AcceptAnyMatchingLayers</a></code></p>
         */
        AcceptAnyMatchingLayers(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qlayerfilter.html#FilterMode-enum">Qt3DRender::<wbr>QLayerFilter::<wbr>AcceptAllMatchingLayers</a></code></p>
         */
        AcceptAllMatchingLayers(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qlayerfilter.html#FilterMode-enum">Qt3DRender::<wbr>QLayerFilter::<wbr>DiscardAnyMatchingLayers</a></code></p>
         */
        DiscardAnyMatchingLayers(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qlayerfilter.html#FilterMode-enum">Qt3DRender::<wbr>QLayerFilter::<wbr>DiscardAllMatchingLayers</a></code></p>
         */
        DiscardAllMatchingLayers(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FilterMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FilterMode resolve(int value) {
            switch (value) {
            case 0: return AcceptAnyMatchingLayers;
            case 1: return AcceptAllMatchingLayers;
            case 2: return DiscardAnyMatchingLayers;
            case 3: return DiscardAllMatchingLayers;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qlayerfilter.html#filterMode-prop">Qt3DRender::QLayerFilter::<wbr>filterModeChanged(Qt3DRender::QLayerFilter::FilterMode)</a></code></p>
     */
    @QtPropertyNotify(name="filterMode")
    public final @NonNull Signal1<io.qt.qt3d.render.QLayerFilter.@NonNull FilterMode> filterModeChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QLayerFilter(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QLayerFilter() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qlayerfilter.html#QLayerFilter">Qt3DRender::QLayerFilter::<wbr>QLayerFilter(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QLayerFilter(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QLayerFilter instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qlayerfilter.html#addLayer">Qt3DRender::QLayerFilter::<wbr>addLayer(Qt3DRender::QLayer*)</a></code></p>
     */
    @QtUninvokable
    public final void addLayer(io.qt.qt3d.render.@Nullable QLayer layer){
        addLayer_native_Qt3DRender_QLayer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(layer));
    }
    
    @QtUninvokable
    private native void addLayer_native_Qt3DRender_QLayer_ptr(long __this__nativeId, long layer);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #filterMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QLayerFilter.@NonNull FilterMode getFilterMode() {
        return filterMode();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qlayerfilter.html#filterMode-prop">Qt3DRender::QLayerFilter::<wbr>filterMode()const</a></code></p>
     */
    @QtPropertyReader(name="filterMode")
    @QtUninvokable
    public final io.qt.qt3d.render.QLayerFilter.@NonNull FilterMode filterMode(){
        return io.qt.qt3d.render.QLayerFilter.FilterMode.resolve(filterMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int filterMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qlayerfilter.html#layers">Qt3DRender::QLayerFilter::<wbr>layers()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@Nullable QLayer> layers(){
        return layers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QLayer> layers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qlayerfilter.html#removeLayer">Qt3DRender::QLayerFilter::<wbr>removeLayer(Qt3DRender::QLayer*)</a></code></p>
     */
    @QtUninvokable
    public final void removeLayer(io.qt.qt3d.render.@Nullable QLayer layer){
        removeLayer_native_Qt3DRender_QLayer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(layer));
    }
    
    @QtUninvokable
    private native void removeLayer_native_Qt3DRender_QLayer_ptr(long __this__nativeId, long layer);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qlayerfilter.html#filterMode-prop">Qt3DRender::QLayerFilter::<wbr>setFilterMode(Qt3DRender::QLayerFilter::FilterMode)</a></code></p>
     */
    @QtPropertyWriter(name="filterMode")
    @QtUninvokable
    public final void setFilterMode(io.qt.qt3d.render.QLayerFilter.@NonNull FilterMode filterMode){
        setFilterMode_native_Qt3DRender_QLayerFilter_FilterMode(QtJambi_LibraryUtilities.internal.nativeId(this), filterMode.value());
    }
    
    @QtUninvokable
    private native void setFilterMode_native_Qt3DRender_QLayerFilter_FilterMode(long __this__nativeId, int filterMode);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QLayerFilter(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QLayerFilter(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QLayerFilter instance, QDeclarativeConstructor constructor);
    
}
