package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Identifies the API required for the attached QTechnique</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html">Qt3DRender::QGraphicsApiFilter</a></code></p>
 */
public class QGraphicsApiFilter extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QGraphicsApiFilter.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#Api-enum">Qt3DRender::QGraphicsApiFilter::Api</a></code></p>
     */
    @QtRejectedEntries({"Vulkan"})
    public enum Api implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#Api-enum">Qt3DRender::<wbr>QGraphicsApiFilter::<wbr>OpenGLES</a></code></p>
         */
        OpenGLES(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#Api-enum">Qt3DRender::<wbr>QGraphicsApiFilter::<wbr>OpenGL</a></code></p>
         */
        OpenGL(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#Api-enum">Qt3DRender::<wbr>QGraphicsApiFilter::<wbr>Vulkan</a></code></p>
         */
        Vulkan(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#Api-enum">Qt3DRender::<wbr>QGraphicsApiFilter::<wbr>DirectX</a></code></p>
         */
        DirectX(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#Api-enum">Qt3DRender::<wbr>QGraphicsApiFilter::<wbr>RHI</a></code></p>
         */
        RHI(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Api(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Api resolve(int value) {
            switch (value) {
            case 2: return OpenGLES;
            case 1: return OpenGL;
            case 4: return DirectX;
            case 5: return RHI;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#OpenGLProfile-enum">Qt3DRender::QGraphicsApiFilter::OpenGLProfile</a></code></p>
     */
    public enum OpenGLProfile implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#OpenGLProfile-enum">Qt3DRender::<wbr>QGraphicsApiFilter::<wbr>NoProfile</a></code></p>
         */
        NoProfile(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#OpenGLProfile-enum">Qt3DRender::<wbr>QGraphicsApiFilter::<wbr>CoreProfile</a></code></p>
         */
        CoreProfile(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#OpenGLProfile-enum">Qt3DRender::<wbr>QGraphicsApiFilter::<wbr>CompatibilityProfile</a></code></p>
         */
        CompatibilityProfile(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private OpenGLProfile(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull OpenGLProfile resolve(int value) {
            switch (value) {
            case 0: return NoProfile;
            case 1: return CoreProfile;
            case 2: return CompatibilityProfile;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#api-prop">Qt3DRender::QGraphicsApiFilter::<wbr>apiChanged(Qt3DRender::QGraphicsApiFilter::Api)</a></code></p>
     */
    @QtPropertyNotify(name="api")
    public final @NonNull Signal1<io.qt.qt3d.render.QGraphicsApiFilter.@NonNull Api> apiChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#extensions-prop">Qt3DRender::QGraphicsApiFilter::<wbr>extensionsChanged(QStringList)</a></code></p>
     */
    @QtPropertyNotify(name="extensions")
    public final @NonNull Signal1<java.util.@NonNull List<java.lang.@NonNull String>> extensionsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#graphicsApiFilterChanged">Qt3DRender::QGraphicsApiFilter::<wbr>graphicsApiFilterChanged()</a></code></p>
     */
    public final @NonNull Signal0 graphicsApiFilterChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#majorVersion-prop">Qt3DRender::QGraphicsApiFilter::<wbr>majorVersionChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="majorVersion")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> majorVersionChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#minorVersion-prop">Qt3DRender::QGraphicsApiFilter::<wbr>minorVersionChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="minorVersion")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> minorVersionChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#profile-prop">Qt3DRender::QGraphicsApiFilter::<wbr>profileChanged(Qt3DRender::QGraphicsApiFilter::OpenGLProfile)</a></code></p>
     */
    @QtPropertyNotify(name="profile")
    public final @NonNull Signal1<io.qt.qt3d.render.QGraphicsApiFilter.@NonNull OpenGLProfile> profileChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#vendor-prop">Qt3DRender::QGraphicsApiFilter::<wbr>vendorChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="vendor")
    public final @NonNull Signal1<java.lang.@NonNull String> vendorChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QGraphicsApiFilter(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QGraphicsApiFilter() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#QGraphicsApiFilter">Qt3DRender::QGraphicsApiFilter::<wbr>QGraphicsApiFilter(QObject*)</a></code></p>
     */
    public QGraphicsApiFilter(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QGraphicsApiFilter instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #api()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QGraphicsApiFilter.@NonNull Api getApi() {
        return api();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#api-prop">Qt3DRender::QGraphicsApiFilter::<wbr>api()const</a></code></p>
     */
    @QtPropertyReader(name="api")
    @QtUninvokable
    public final io.qt.qt3d.render.QGraphicsApiFilter.@NonNull Api api(){
        return io.qt.qt3d.render.QGraphicsApiFilter.Api.resolve(api_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int api_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #extensions()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getExtensions() {
        return extensions();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#extensions-prop">Qt3DRender::QGraphicsApiFilter::<wbr>extensions()const</a></code></p>
     */
    @QtPropertyReader(name="extensions")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList extensions(){
        return extensions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList extensions_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #majorVersion()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMajorVersion() {
        return majorVersion();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#majorVersion-prop">Qt3DRender::QGraphicsApiFilter::<wbr>majorVersion()const</a></code></p>
     */
    @QtPropertyReader(name="majorVersion")
    @QtUninvokable
    public final int majorVersion(){
        return majorVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int majorVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minorVersion()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMinorVersion() {
        return minorVersion();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#minorVersion-prop">Qt3DRender::QGraphicsApiFilter::<wbr>minorVersion()const</a></code></p>
     */
    @QtPropertyReader(name="minorVersion")
    @QtUninvokable
    public final int minorVersion(){
        return minorVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int minorVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #profile()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QGraphicsApiFilter.@NonNull OpenGLProfile getProfile() {
        return profile();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#profile-prop">Qt3DRender::QGraphicsApiFilter::<wbr>profile()const</a></code></p>
     */
    @QtPropertyReader(name="profile")
    @QtUninvokable
    public final io.qt.qt3d.render.QGraphicsApiFilter.@NonNull OpenGLProfile profile(){
        return io.qt.qt3d.render.QGraphicsApiFilter.OpenGLProfile.resolve(profile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int profile_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#api-prop">Qt3DRender::QGraphicsApiFilter::<wbr>setApi(Qt3DRender::QGraphicsApiFilter::Api)</a></code></p>
     */
    @QtPropertyWriter(name="api")
    public final void setApi(io.qt.qt3d.render.QGraphicsApiFilter.@NonNull Api api){
        setApi_native_Qt3DRender_QGraphicsApiFilter_Api(QtJambi_LibraryUtilities.internal.nativeId(this), api.value());
    }
    
    private native void setApi_native_Qt3DRender_QGraphicsApiFilter_Api(long __this__nativeId, int api);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#extensions-prop">Qt3DRender::QGraphicsApiFilter::<wbr>setExtensions(QStringList)</a></code></p>
     */
    @QtPropertyWriter(name="extensions")
    public final void setExtensions(java.util.@NonNull Collection<java.lang.@NonNull String> extensions){
        setExtensions_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), extensions);
    }
    
    private native void setExtensions_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> extensions);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#majorVersion-prop">Qt3DRender::QGraphicsApiFilter::<wbr>setMajorVersion(int)</a></code></p>
     */
    @QtPropertyWriter(name="majorVersion")
    public final void setMajorVersion(int majorVersion){
        setMajorVersion_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), majorVersion);
    }
    
    private native void setMajorVersion_native_int(long __this__nativeId, int majorVersion);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#minorVersion-prop">Qt3DRender::QGraphicsApiFilter::<wbr>setMinorVersion(int)</a></code></p>
     */
    @QtPropertyWriter(name="minorVersion")
    public final void setMinorVersion(int minorVersion){
        setMinorVersion_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), minorVersion);
    }
    
    private native void setMinorVersion_native_int(long __this__nativeId, int minorVersion);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#profile-prop">Qt3DRender::QGraphicsApiFilter::<wbr>setProfile(Qt3DRender::QGraphicsApiFilter::OpenGLProfile)</a></code></p>
     */
    @QtPropertyWriter(name="profile")
    public final void setProfile(io.qt.qt3d.render.QGraphicsApiFilter.@NonNull OpenGLProfile profile){
        setProfile_native_Qt3DRender_QGraphicsApiFilter_OpenGLProfile(QtJambi_LibraryUtilities.internal.nativeId(this), profile.value());
    }
    
    private native void setProfile_native_Qt3DRender_QGraphicsApiFilter_OpenGLProfile(long __this__nativeId, int profile);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#vendor-prop">Qt3DRender::QGraphicsApiFilter::<wbr>setVendor(QString)</a></code></p>
     */
    @QtPropertyWriter(name="vendor")
    public final void setVendor(java.lang.@NonNull String vendor){
        setVendor_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), vendor);
    }
    
    private native void setVendor_native_cref_QString(long __this__nativeId, java.lang.String vendor);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vendor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getVendor() {
        return vendor();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#vendor-prop">Qt3DRender::QGraphicsApiFilter::<wbr>vendor()const</a></code></p>
     */
    @QtPropertyReader(name="vendor")
    @QtUninvokable
    public final java.lang.@NonNull String vendor(){
        return vendor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String vendor_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QGraphicsApiFilter(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QGraphicsApiFilter(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QGraphicsApiFilter instance, QDeclarativeConstructor constructor);
    
}
