package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Defines front and back facing polygons</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qfrontface.html">Qt3DRender::QFrontFace</a></code></p>
 */
public class QFrontFace extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QFrontFace.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qfrontface.html#WindingDirection-enum">Qt3DRender::QFrontFace::WindingDirection</a></code></p>
     */
    public enum WindingDirection implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qfrontface.html#WindingDirection-enum">Qt3DRender::<wbr>QFrontFace::<wbr>ClockWise</a></code></p>
         */
        ClockWise(2304),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qfrontface.html#WindingDirection-enum">Qt3DRender::<wbr>QFrontFace::<wbr>CounterClockWise</a></code></p>
         */
        CounterClockWise(2305);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private WindingDirection(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull WindingDirection resolve(int value) {
            switch (value) {
            case 2304: return ClockWise;
            case 2305: return CounterClockWise;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qfrontface.html#direction-prop">Qt3DRender::QFrontFace::<wbr>directionChanged(Qt3DRender::QFrontFace::WindingDirection)</a></code></p>
     */
    @QtPropertyNotify(name="direction")
    public final @NonNull Signal1<io.qt.qt3d.render.QFrontFace.@NonNull WindingDirection> directionChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QFrontFace(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QFrontFace() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qfrontface.html#QFrontFace">Qt3DRender::QFrontFace::<wbr>QFrontFace(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QFrontFace(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QFrontFace instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #direction()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QFrontFace.@NonNull WindingDirection getDirection() {
        return direction();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qfrontface.html#direction-prop">Qt3DRender::QFrontFace::<wbr>direction()const</a></code></p>
     */
    @QtPropertyReader(name="direction")
    @QtUninvokable
    public final io.qt.qt3d.render.QFrontFace.@NonNull WindingDirection direction(){
        return io.qt.qt3d.render.QFrontFace.WindingDirection.resolve(direction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int direction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qfrontface.html#direction-prop">Qt3DRender::QFrontFace::<wbr>setDirection(Qt3DRender::QFrontFace::WindingDirection)</a></code></p>
     */
    @QtPropertyWriter(name="direction")
    public final void setDirection(io.qt.qt3d.render.QFrontFace.@NonNull WindingDirection direction){
        setDirection_native_Qt3DRender_QFrontFace_WindingDirection(QtJambi_LibraryUtilities.internal.nativeId(this), direction.value());
    }
    
    private native void setDirection_native_Qt3DRender_QFrontFace_WindingDirection(long __this__nativeId, int direction);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QFrontFace(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QFrontFace(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QFrontFace instance, QDeclarativeConstructor constructor);
    
}
