package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>FrameGraph node to issue work for the compute shader on GPU</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html">Qt3DRender::QDispatchCompute</a></code></p>
 */
public class QDispatchCompute extends io.qt.qt3d.render.QFrameGraphNode
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDispatchCompute.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupX-prop">Qt3DRender::QDispatchCompute::<wbr>workGroupXChanged()</a></code></p>
     */
    @QtPropertyNotify(name="workGroupX")
    public final @NonNull Signal0 workGroupXChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupY-prop">Qt3DRender::QDispatchCompute::<wbr>workGroupYChanged()</a></code></p>
     */
    @QtPropertyNotify(name="workGroupY")
    public final @NonNull Signal0 workGroupYChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupZ-prop">Qt3DRender::QDispatchCompute::<wbr>workGroupZChanged()</a></code></p>
     */
    @QtPropertyNotify(name="workGroupZ")
    public final @NonNull Signal0 workGroupZChanged = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QDispatchCompute(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QDispatchCompute() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#QDispatchCompute">Qt3DRender::QDispatchCompute::<wbr>QDispatchCompute(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QDispatchCompute(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QDispatchCompute instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupX-prop">Qt3DRender::QDispatchCompute::<wbr>setWorkGroupX(int)</a></code></p>
     */
    @QtPropertyWriter(name="workGroupX")
    public final void setWorkGroupX(int workGroupX){
        setWorkGroupX_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), workGroupX);
    }
    
    private native void setWorkGroupX_native_int(long __this__nativeId, int workGroupX);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupY-prop">Qt3DRender::QDispatchCompute::<wbr>setWorkGroupY(int)</a></code></p>
     */
    @QtPropertyWriter(name="workGroupY")
    public final void setWorkGroupY(int workGroupY){
        setWorkGroupY_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), workGroupY);
    }
    
    private native void setWorkGroupY_native_int(long __this__nativeId, int workGroupY);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupZ-prop">Qt3DRender::QDispatchCompute::<wbr>setWorkGroupZ(int)</a></code></p>
     */
    @QtPropertyWriter(name="workGroupZ")
    public final void setWorkGroupZ(int workGroupZ){
        setWorkGroupZ_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), workGroupZ);
    }
    
    private native void setWorkGroupZ_native_int(long __this__nativeId, int workGroupZ);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #workGroupX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getWorkGroupX() {
        return workGroupX();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupX-prop">Qt3DRender::QDispatchCompute::<wbr>workGroupX()const</a></code></p>
     */
    @QtPropertyReader(name="workGroupX")
    @QtUninvokable
    public final int workGroupX(){
        return workGroupX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int workGroupX_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #workGroupY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getWorkGroupY() {
        return workGroupY();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupY-prop">Qt3DRender::QDispatchCompute::<wbr>workGroupY()const</a></code></p>
     */
    @QtPropertyReader(name="workGroupY")
    @QtUninvokable
    public final int workGroupY(){
        return workGroupY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int workGroupY_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #workGroupZ()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getWorkGroupZ() {
        return workGroupZ();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupZ-prop">Qt3DRender::QDispatchCompute::<wbr>workGroupZ()const</a></code></p>
     */
    @QtPropertyReader(name="workGroupZ")
    @QtUninvokable
    public final int workGroupZ(){
        return workGroupZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int workGroupZ_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDispatchCompute(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QDispatchCompute(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QDispatchCompute instance, QDeclarativeConstructor constructor);
    
}
