package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Encapsulate a Directional Light object in a Qt 3D scene</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qdirectionallight.html">Qt3DRender::QDirectionalLight</a></code></p>
 */
public class QDirectionalLight extends io.qt.qt3d.render.QAbstractLight
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDirectionalLight.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdirectionallight.html#worldDirection-prop">Qt3DRender::QDirectionalLight::<wbr>worldDirectionChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="worldDirection")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> worldDirectionChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QDirectionalLight(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QDirectionalLight() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdirectionallight.html#QDirectionalLight">Qt3DRender::QDirectionalLight::<wbr>QDirectionalLight(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QDirectionalLight(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QDirectionalLight instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdirectionallight.html#worldDirection-prop">Qt3DRender::QDirectionalLight::<wbr>setWorldDirection(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="worldDirection")
    public final void setWorldDirection(io.qt.gui.@NonNull QVector3D worldDirection){
        setWorldDirection_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(worldDirection));
    }
    
    private native void setWorldDirection_native_cref_QVector3D(long __this__nativeId, long worldDirection);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #worldDirection()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getWorldDirection() {
        return worldDirection();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdirectionallight.html#worldDirection-prop">Qt3DRender::QDirectionalLight::<wbr>worldDirection()const</a></code></p>
     */
    @QtPropertyReader(name="worldDirection")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D worldDirection(){
        return worldDirection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D worldDirection_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDirectionalLight(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QDirectionalLight(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QDirectionalLight instance, QDeclarativeConstructor constructor);
    
}
