package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>QComponent to issue work for the compute shader on GPU</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html">Qt3DRender::QComputeCommand</a></code></p>
 */
public class QComputeCommand extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QComputeCommand.class);
    
    /**
     * <p>Java wrapper for Qt enum <code>Qt3DRender::QComputeCommand::RunType</code></p>
     */
    public enum RunType implements QtEnumerator {
        /**
         * <p>Representing <code>Qt3DRender::<wbr>QComputeCommand::<wbr>Continuous</code></p>
         */
        Continuous(0),
        /**
         * <p>Representing <code>Qt3DRender::<wbr>QComputeCommand::<wbr>Manual</code></p>
         */
        Manual(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RunType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RunType resolve(int value) {
            switch (value) {
            case 0: return Continuous;
            case 1: return Manual;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#runType-prop">Qt3DRender::QComputeCommand::<wbr>runTypeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="runType")
    public final @NonNull Signal0 runTypeChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#workGroupX-prop">Qt3DRender::QComputeCommand::<wbr>workGroupXChanged()</a></code></p>
     */
    @QtPropertyNotify(name="workGroupX")
    public final @NonNull Signal0 workGroupXChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#workGroupY-prop">Qt3DRender::QComputeCommand::<wbr>workGroupYChanged()</a></code></p>
     */
    @QtPropertyNotify(name="workGroupY")
    public final @NonNull Signal0 workGroupYChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#workGroupZ-prop">Qt3DRender::QComputeCommand::<wbr>workGroupZChanged()</a></code></p>
     */
    @QtPropertyNotify(name="workGroupZ")
    public final @NonNull Signal0 workGroupZChanged = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QComputeCommand(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QComputeCommand() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#QComputeCommand">Qt3DRender::QComputeCommand::<wbr>QComputeCommand(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QComputeCommand(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QComputeCommand instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #runType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QComputeCommand.@NonNull RunType getRunType() {
        return runType();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#runType-prop">Qt3DRender::QComputeCommand::<wbr>runType()const</a></code></p>
     */
    @QtPropertyReader(name="runType")
    @QtUninvokable
    public final io.qt.qt3d.render.QComputeCommand.@NonNull RunType runType(){
        return io.qt.qt3d.render.QComputeCommand.RunType.resolve(runType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int runType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#runType-prop">Qt3DRender::QComputeCommand::<wbr>setRunType(Qt3DRender::QComputeCommand::RunType)</a></code></p>
     */
    @QtPropertyWriter(name="runType")
    public final void setRunType(io.qt.qt3d.render.QComputeCommand.@NonNull RunType runType){
        setRunType_native_Qt3DRender_QComputeCommand_RunType(QtJambi_LibraryUtilities.internal.nativeId(this), runType.value());
    }
    
    private native void setRunType_native_Qt3DRender_QComputeCommand_RunType(long __this__nativeId, int runType);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#setWorkGroupX">Qt3DRender::QComputeCommand::<wbr>setWorkGroupX(int)</a></code></p>
     */
    @QtPropertyWriter(name="workGroupX")
    public final void setWorkGroupX(int workGroupX){
        setWorkGroupX_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), workGroupX);
    }
    
    private native void setWorkGroupX_native_int(long __this__nativeId, int workGroupX);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#setWorkGroupY">Qt3DRender::QComputeCommand::<wbr>setWorkGroupY(int)</a></code></p>
     */
    @QtPropertyWriter(name="workGroupY")
    public final void setWorkGroupY(int workGroupY){
        setWorkGroupY_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), workGroupY);
    }
    
    private native void setWorkGroupY_native_int(long __this__nativeId, int workGroupY);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#setWorkGroupZ">Qt3DRender::QComputeCommand::<wbr>setWorkGroupZ(int)</a></code></p>
     */
    @QtPropertyWriter(name="workGroupZ")
    public final void setWorkGroupZ(int workGroupZ){
        setWorkGroupZ_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), workGroupZ);
    }
    
    private native void setWorkGroupZ_native_int(long __this__nativeId, int workGroupZ);
    
    /**
     * <p>Overloaded function for {@link #trigger(int)}
     *  with <code>frameCount = 1</code>.</p>
     */
    public final void trigger() {
        trigger((int)1);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#trigger">Qt3DRender::QComputeCommand::<wbr>trigger(int)</a></code></p>
     */
    public final void trigger(int frameCount){
        trigger_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), frameCount);
    }
    
    private native void trigger_native_int(long __this__nativeId, int frameCount);
    
    /**
     * <p>Overloaded function for {@link #trigger(int, int, int, int)}
     *  with <code>frameCount = 1</code>.</p>
     */
    public final void trigger(int workGroupX, int workGroupY, int workGroupZ) {
        trigger(workGroupX, workGroupY, workGroupZ, (int)1);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#trigger-1">Qt3DRender::QComputeCommand::<wbr>trigger(int,<wbr>int,<wbr>int,<wbr>int)</a></code></p>
     */
    public final void trigger(int workGroupX, int workGroupY, int workGroupZ, int frameCount){
        trigger_native_int_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), workGroupX, workGroupY, workGroupZ, frameCount);
    }
    
    private native void trigger_native_int_int_int_int(long __this__nativeId, int workGroupX, int workGroupY, int workGroupZ, int frameCount);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #workGroupX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getWorkGroupX() {
        return workGroupX();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#workGroupX-prop">Qt3DRender::QComputeCommand::<wbr>workGroupX()const</a></code></p>
     */
    @QtPropertyReader(name="workGroupX")
    @QtUninvokable
    public final int workGroupX(){
        return workGroupX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int workGroupX_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #workGroupY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getWorkGroupY() {
        return workGroupY();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#workGroupY-prop">Qt3DRender::QComputeCommand::<wbr>workGroupY()const</a></code></p>
     */
    @QtPropertyReader(name="workGroupY")
    @QtUninvokable
    public final int workGroupY(){
        return workGroupY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int workGroupY_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #workGroupZ()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getWorkGroupZ() {
        return workGroupZ();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcomputecommand.html#workGroupZ-prop">Qt3DRender::QComputeCommand::<wbr>workGroupZ()const</a></code></p>
     */
    @QtPropertyReader(name="workGroupZ")
    @QtUninvokable
    public final int workGroupZ(){
        return workGroupZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int workGroupZ_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QComputeCommand(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QComputeCommand(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QComputeCommand instance, QDeclarativeConstructor constructor);
    
}
