package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Allows specifying which color components should be written to the currently bound frame buffer</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qcolormask.html">Qt3DRender::QColorMask</a></code></p>
 */
public class QColorMask extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QColorMask.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcolormask.html#alphaMasked-prop">Qt3DRender::QColorMask::<wbr>alphaMaskedChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="alphaMasked")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> alphaMaskedChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcolormask.html#blueMasked-prop">Qt3DRender::QColorMask::<wbr>blueMaskedChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="blueMasked")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> blueMaskedChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcolormask.html#greenMasked-prop">Qt3DRender::QColorMask::<wbr>greenMaskedChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="greenMasked")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> greenMaskedChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcolormask.html#redMasked-prop">Qt3DRender::QColorMask::<wbr>redMaskedChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="redMasked")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> redMaskedChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QColorMask(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QColorMask() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcolormask.html#QColorMask">Qt3DRender::QColorMask::<wbr>QColorMask(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QColorMask(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QColorMask instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isAlphaMasked()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAlphaMasked() {
        return isAlphaMasked();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcolormask.html#alphaMasked-prop">Qt3DRender::QColorMask::<wbr>isAlphaMasked()const</a></code></p>
     */
    @QtPropertyReader(name="alphaMasked")
    @QtUninvokable
    public final boolean isAlphaMasked(){
        return isAlphaMasked_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAlphaMasked_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isBlueMasked()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getBlueMasked() {
        return isBlueMasked();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcolormask.html#blueMasked-prop">Qt3DRender::QColorMask::<wbr>isBlueMasked()const</a></code></p>
     */
    @QtPropertyReader(name="blueMasked")
    @QtUninvokable
    public final boolean isBlueMasked(){
        return isBlueMasked_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isBlueMasked_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isGreenMasked()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getGreenMasked() {
        return isGreenMasked();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcolormask.html#greenMasked-prop">Qt3DRender::QColorMask::<wbr>isGreenMasked()const</a></code></p>
     */
    @QtPropertyReader(name="greenMasked")
    @QtUninvokable
    public final boolean isGreenMasked(){
        return isGreenMasked_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isGreenMasked_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isRedMasked()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getRedMasked() {
        return isRedMasked();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcolormask.html#redMasked-prop">Qt3DRender::QColorMask::<wbr>isRedMasked()const</a></code></p>
     */
    @QtPropertyReader(name="redMasked")
    @QtUninvokable
    public final boolean isRedMasked(){
        return isRedMasked_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isRedMasked_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcolormask.html#alphaMasked-prop">Qt3DRender::QColorMask::<wbr>setAlphaMasked(bool)</a></code></p>
     */
    @QtPropertyWriter(name="alphaMasked")
    public final void setAlphaMasked(boolean alphaMasked){
        setAlphaMasked_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), alphaMasked);
    }
    
    private native void setAlphaMasked_native_bool(long __this__nativeId, boolean alphaMasked);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcolormask.html#blueMasked-prop">Qt3DRender::QColorMask::<wbr>setBlueMasked(bool)</a></code></p>
     */
    @QtPropertyWriter(name="blueMasked")
    public final void setBlueMasked(boolean blueMasked){
        setBlueMasked_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), blueMasked);
    }
    
    private native void setBlueMasked_native_bool(long __this__nativeId, boolean blueMasked);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcolormask.html#greenMasked-prop">Qt3DRender::QColorMask::<wbr>setGreenMasked(bool)</a></code></p>
     */
    @QtPropertyWriter(name="greenMasked")
    public final void setGreenMasked(boolean greenMasked){
        setGreenMasked_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), greenMasked);
    }
    
    private native void setGreenMasked_native_bool(long __this__nativeId, boolean greenMasked);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcolormask.html#redMasked-prop">Qt3DRender::QColorMask::<wbr>setRedMasked(bool)</a></code></p>
     */
    @QtPropertyWriter(name="redMasked")
    public final void setRedMasked(boolean redMasked){
        setRedMasked_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), redMasked);
    }
    
    private native void setRedMasked_native_bool(long __this__nativeId, boolean redMasked);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QColorMask(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QColorMask(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QColorMask instance, QDeclarativeConstructor constructor);
    
}
