package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Enables an additional OpenGL clipping plane that can be in shaders using gl_ClipDistance</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qclipplane.html">Qt3DRender::QClipPlane</a></code></p>
 */
public class QClipPlane extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QClipPlane.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclipplane.html#distance-prop">Qt3DRender::QClipPlane::<wbr>distanceChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="distance")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> distanceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclipplane.html#normal-prop">Qt3DRender::QClipPlane::<wbr>normalChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="normal")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> normalChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclipplane.html#planeIndex-prop">Qt3DRender::QClipPlane::<wbr>planeIndexChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="planeIndex")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> planeIndexChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QClipPlane(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QClipPlane() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <code>Qt3DRender::QClipPlane::<wbr>QClipPlane(Qt3DCore::QNode*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public QClipPlane(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QClipPlane instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #distance()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDistance() {
        return distance();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclipplane.html#distance-prop">Qt3DRender::QClipPlane::<wbr>distance()const</a></code></p>
     */
    @QtPropertyReader(name="distance")
    @QtUninvokable
    public final float distance(){
        return distance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float distance_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #normal()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getNormal() {
        return normal();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclipplane.html#normal-prop">Qt3DRender::QClipPlane::<wbr>normal()const</a></code></p>
     */
    @QtPropertyReader(name="normal")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D normal(){
        return normal_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D normal_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #planeIndex()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getPlaneIndex() {
        return planeIndex();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclipplane.html#planeIndex-prop">Qt3DRender::QClipPlane::<wbr>planeIndex()const</a></code></p>
     */
    @QtPropertyReader(name="planeIndex")
    @QtUninvokable
    public final int planeIndex(){
        return planeIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int planeIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclipplane.html#distance-prop">Qt3DRender::QClipPlane::<wbr>setDistance(float)</a></code></p>
     */
    @QtPropertyWriter(name="distance")
    public final void setDistance(float arg__1){
        setDistance_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    private native void setDistance_native_float(long __this__nativeId, float arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclipplane.html#normal-prop">Qt3DRender::QClipPlane::<wbr>setNormal(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="normal")
    public final void setNormal(io.qt.gui.@NonNull QVector3D arg__1){
        setNormal_native_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    private native void setNormal_native_QVector3D(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclipplane.html#planeIndex-prop">Qt3DRender::QClipPlane::<wbr>setPlaneIndex(int)</a></code></p>
     */
    @QtPropertyWriter(name="planeIndex")
    public final void setPlaneIndex(int arg__1){
        setPlaneIndex_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    private native void setPlaneIndex_native_int(long __this__nativeId, int arg__1);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QClipPlane(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QClipPlane(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QClipPlane instance, QDeclarativeConstructor constructor);
    
}
