package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Specifies arguments for stencil test</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html">Qt3DRender::QStencilTestArguments</a></p>
 */
public final class QStencilTestArguments extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QStencilTestArguments.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#StencilFaceMode-enum">Qt3DRender::QStencilTestArguments::StencilFaceMode</a></p>
     */
    public enum StencilFaceMode implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#StencilFaceMode-enum">Qt3DRender::QStencilTestArguments::Front</a></p>
         */
        Front(1028),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#StencilFaceMode-enum">Qt3DRender::QStencilTestArguments::Back</a></p>
         */
        Back(1029),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#StencilFaceMode-enum">Qt3DRender::QStencilTestArguments::FrontAndBack</a></p>
         */
        FrontAndBack(1032);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private StencilFaceMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull StencilFaceMode resolve(int value) {
            switch (value) {
            case 1028: return Front;
            case 1029: return Back;
            case 1032: return FrontAndBack;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#StencilFunction-enum">Qt3DRender::QStencilTestArguments::StencilFunction</a></p>
     */
    public enum StencilFunction implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#StencilFunction-enum">Qt3DRender::QStencilTestArguments::Never</a></p>
         */
        Never(512),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#StencilFunction-enum">Qt3DRender::QStencilTestArguments::Always</a></p>
         */
        Always(519),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#StencilFunction-enum">Qt3DRender::QStencilTestArguments::Less</a></p>
         */
        Less(513),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#StencilFunction-enum">Qt3DRender::QStencilTestArguments::LessOrEqual</a></p>
         */
        LessOrEqual(515),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#StencilFunction-enum">Qt3DRender::QStencilTestArguments::Equal</a></p>
         */
        Equal(514),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#StencilFunction-enum">Qt3DRender::QStencilTestArguments::GreaterOrEqual</a></p>
         */
        GreaterOrEqual(518),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#StencilFunction-enum">Qt3DRender::QStencilTestArguments::Greater</a></p>
         */
        Greater(516),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#StencilFunction-enum">Qt3DRender::QStencilTestArguments::NotEqual</a></p>
         */
        NotEqual(517);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private StencilFunction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull StencilFunction resolve(int value) {
            switch (value) {
            case 512: return Never;
            case 519: return Always;
            case 513: return Less;
            case 515: return LessOrEqual;
            case 514: return Equal;
            case 518: return GreaterOrEqual;
            case 516: return Greater;
            case 517: return NotEqual;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#comparisonMask-prop">Qt3DRender::QStencilTestArguments::comparisonMaskChanged(uint)</a></p>
     */
    @QtPropertyNotify(name="comparisonMask")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> comparisonMaskChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#faceMode-prop">Qt3DRender::QStencilTestArguments::faceModeChanged(Qt3DRender::QStencilTestArguments::StencilFaceMode)</a></p>
     */
    @QtPropertyNotify(name="faceMode")
    public final @NonNull Signal1<io.qt.qt3d.render.QStencilTestArguments.@NonNull StencilFaceMode> faceModeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#referenceValue-prop">Qt3DRender::QStencilTestArguments::referenceValueChanged(int)</a></p>
     */
    @QtPropertyNotify(name="referenceValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> referenceValueChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#stencilFunction-prop">Qt3DRender::QStencilTestArguments::stencilFunctionChanged(Qt3DRender::QStencilTestArguments::StencilFunction)</a></p>
     */
    @QtPropertyNotify(name="stencilFunction")
    public final @NonNull Signal1<io.qt.qt3d.render.QStencilTestArguments.@NonNull StencilFunction> stencilFunctionChanged = new Signal1<>();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #comparisonMask()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getComparisonMask() {
        return comparisonMask();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#comparisonMask-prop">Qt3DRender::QStencilTestArguments::comparisonMask()const</a></p>
     */
    @QtPropertyReader(name="comparisonMask")
    @QtUninvokable
    public final int comparisonMask(){
        return comparisonMask_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int comparisonMask_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #faceMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QStencilTestArguments.@NonNull StencilFaceMode getFaceMode() {
        return faceMode();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#faceMode-prop">Qt3DRender::QStencilTestArguments::faceMode()const</a></p>
     */
    @QtPropertyReader(name="faceMode")
    @QtUninvokable
    public final io.qt.qt3d.render.QStencilTestArguments.@NonNull StencilFaceMode faceMode(){
        return io.qt.qt3d.render.QStencilTestArguments.StencilFaceMode.resolve(faceMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int faceMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #referenceValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getReferenceValue() {
        return referenceValue();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#referenceValue-prop">Qt3DRender::QStencilTestArguments::referenceValue()const</a></p>
     */
    @QtPropertyReader(name="referenceValue")
    @QtUninvokable
    public final int referenceValue(){
        return referenceValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int referenceValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#comparisonMask-prop">Qt3DRender::QStencilTestArguments::setComparisonMask(uint)</a></p>
     */
    @QtPropertyWriter(name="comparisonMask")
    public final void setComparisonMask(int comparisonMask){
        setComparisonMask_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), comparisonMask);
    }
    
    private native void setComparisonMask_native_uint(long __this__nativeId, int comparisonMask);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#referenceValue-prop">Qt3DRender::QStencilTestArguments::setReferenceValue(int)</a></p>
     */
    @QtPropertyWriter(name="referenceValue")
    public final void setReferenceValue(int referenceValue){
        setReferenceValue_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), referenceValue);
    }
    
    private native void setReferenceValue_native_int(long __this__nativeId, int referenceValue);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#stencilFunction-prop">Qt3DRender::QStencilTestArguments::setStencilFunction(Qt3DRender::QStencilTestArguments::StencilFunction)</a></p>
     */
    @QtPropertyWriter(name="stencilFunction")
    public final void setStencilFunction(io.qt.qt3d.render.QStencilTestArguments.@NonNull StencilFunction stencilFunction){
        setStencilFunction_native_Qt3DRender_QStencilTestArguments_StencilFunction(QtJambi_LibraryUtilities.internal.nativeId(this), stencilFunction.value());
    }
    
    private native void setStencilFunction_native_Qt3DRender_QStencilTestArguments_StencilFunction(long __this__nativeId, int stencilFunction);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #stencilFunction()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QStencilTestArguments.@NonNull StencilFunction getStencilFunction() {
        return stencilFunction();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciltestarguments.html#stencilFunction-prop">Qt3DRender::QStencilTestArguments::stencilFunction()const</a></p>
     */
    @QtPropertyReader(name="stencilFunction")
    @QtUninvokable
    public final io.qt.qt3d.render.QStencilTestArguments.@NonNull StencilFunction stencilFunction(){
        return io.qt.qt3d.render.QStencilTestArguments.StencilFunction.resolve(stencilFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int stencilFunction_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QStencilTestArguments(QPrivateConstructor p) { super(p); } 
    
}
