package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Allows to use a textureId from a separate OpenGL context in a Qt 3D scene</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qsharedgltexture.html">Qt3DRender::QSharedGLTexture</a></p>
 */
public class QSharedGLTexture extends io.qt.qt3d.render.QAbstractTexture
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSharedGLTexture.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsharedgltexture.html#textureId-prop">Qt3DRender::QSharedGLTexture::textureIdChanged(int)</a></p>
     */
    @QtPropertyNotify(name="textureId")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> textureIdChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QSharedGLTexture(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QSharedGLTexture() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QSharedGLTexture(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSharedGLTexture instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsharedgltexture.html#textureId-prop">Qt3DRender::QSharedGLTexture::setTextureId(int)</a></p>
     */
    @QtPropertyWriter(name="textureId")
    public final void setTextureId(int id){
        setTextureId_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    private native void setTextureId_native_int(long __this__nativeId, int id);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #textureId()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getTextureId() {
        return textureId();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsharedgltexture.html#textureId-prop">Qt3DRender::QSharedGLTexture::textureId()const</a></p>
     */
    @QtPropertyReader(name="textureId")
    @QtUninvokable
    public final int textureId(){
        return textureId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int textureId_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSharedGLTexture(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSharedGLTexture(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSharedGLTexture instance, QDeclarativeConstructor constructor);
    
}
