package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Performe ray casting test based on screen coordinates</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qscreenraycaster.html">Qt3DRender::QScreenRayCaster</a></p>
 */
public class QScreenRayCaster extends io.qt.qt3d.render.QAbstractRayCaster
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScreenRayCaster.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qscreenraycaster.html#position-prop">Qt3DRender::QScreenRayCaster::positionChanged(QPoint)</a></p>
     */
    @QtPropertyNotify(name="position")
    public final @NonNull Signal1<io.qt.core.@NonNull QPoint> positionChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QScreenRayCaster(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QScreenRayCaster() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QScreenRayCaster(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QScreenRayCaster instance, io.qt.qt3d.core.QNode parent);
    
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@NonNull QRayCasterHit> pick(io.qt.core.@NonNull QPoint position){
        return pick_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    private native io.qt.core.QList<io.qt.qt3d.render.QRayCasterHit> pick_native_cref_QPoint(long __this__nativeId, long position);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #position()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint getPosition() {
        return position();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qscreenraycaster.html#position-prop">Qt3DRender::QScreenRayCaster::position()const</a></p>
     */
    @QtPropertyReader(name="position")
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPoint position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qscreenraycaster.html#position-prop">Qt3DRender::QScreenRayCaster::setPosition(QPoint)</a></p>
     */
    @QtPropertyWriter(name="position")
    public final void setPosition(io.qt.core.@NonNull QPoint position){
        setPosition_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    private native void setPosition_native_cref_QPoint(long __this__nativeId, long position);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qscreenraycaster.html#trigger">Qt3DRender::QScreenRayCaster::trigger()</a></p>
     */
    public final void trigger(){
        trigger_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void trigger_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qscreenraycaster.html#trigger-1">Qt3DRender::QScreenRayCaster::trigger(QPoint)</a></p>
     */
    public final void trigger(io.qt.core.@NonNull QPoint position){
        trigger_native_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    private native void trigger_native_cref_QPoint(long __this__nativeId, long position);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QScreenRayCaster(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QScreenRayCaster(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QScreenRayCaster instance, QDeclarativeConstructor constructor);
    
}
