package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Holds settings related to rendering process and host the active FrameGraph</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qrendersettings.html">Qt3DRender::QRenderSettings</a></p>
 */
public class QRenderSettings extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderSettings.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qrendersettings.html#RenderPolicy-enum">Qt3DRender::QRenderSettings::RenderPolicy</a></p>
     */
    public enum RenderPolicy implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qrendersettings.html#RenderPolicy-enum">Qt3DRender::QRenderSettings::OnDemand</a></p>
         */
        OnDemand(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qrendersettings.html#RenderPolicy-enum">Qt3DRender::QRenderSettings::Always</a></p>
         */
        Always(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RenderPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RenderPolicy resolve(int value) {
            switch (value) {
            case 0: return OnDemand;
            case 1: return Always;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersettings.html#activeFrameGraph-prop">Qt3DRender::QRenderSettings::activeFrameGraphChanged(Qt3DRender::QFrameGraphNode*)</a></p>
     */
    @QtPropertyNotify(name="activeFrameGraph")
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QFrameGraphNode> activeFrameGraphChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersettings.html#renderPolicy-prop">Qt3DRender::QRenderSettings::renderPolicyChanged(Qt3DRender::QRenderSettings::RenderPolicy)</a></p>
     */
    @QtPropertyNotify(name="renderPolicy")
    public final @NonNull Signal1<io.qt.qt3d.render.QRenderSettings.@NonNull RenderPolicy> renderPolicyChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QRenderSettings(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QRenderSettings() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QRenderSettings(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRenderSettings instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #activeFrameGraph()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QFrameGraphNode getActiveFrameGraph() {
        return activeFrameGraph();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersettings.html#activeFrameGraph-prop">Qt3DRender::QRenderSettings::activeFrameGraph()const</a></p>
     */
    @QtPropertyReader(name="activeFrameGraph")
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QFrameGraphNode activeFrameGraph(){
        return activeFrameGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QFrameGraphNode activeFrameGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #pickingSettings()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QPickingSettings getPickingSettings() {
        return pickingSettings();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersettings.html#pickingSettings-prop">Qt3DRender::QRenderSettings::pickingSettings()</a></p>
     */
    @QtPropertyReader(name="pickingSettings")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QPickingSettings pickingSettings(){
        return pickingSettings_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QPickingSettings pickingSettings_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #renderCapabilities()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QRenderCapabilities getRenderCapabilities() {
        return renderCapabilities();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersettings.html#renderCapabilities-prop">Qt3DRender::QRenderSettings::renderCapabilities()</a></p>
     */
    @QtPropertyReader(name="renderCapabilities")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QRenderCapabilities renderCapabilities(){
        return renderCapabilities_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QRenderCapabilities renderCapabilities_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #renderPolicy()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderSettings.@NonNull RenderPolicy getRenderPolicy() {
        return renderPolicy();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersettings.html#renderPolicy-prop">Qt3DRender::QRenderSettings::renderPolicy()const</a></p>
     */
    @QtPropertyReader(name="renderPolicy")
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderSettings.@NonNull RenderPolicy renderPolicy(){
        return io.qt.qt3d.render.QRenderSettings.RenderPolicy.resolve(renderPolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int renderPolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersettings.html#activeFrameGraph-prop">Qt3DRender::QRenderSettings::setActiveFrameGraph(Qt3DRender::QFrameGraphNode*)</a></p>
     */
    @QtPropertyWriter(name="activeFrameGraph")
    public final void setActiveFrameGraph(io.qt.qt3d.render.@Nullable QFrameGraphNode activeFrameGraph){
        setActiveFrameGraph_native_Qt3DRender_QFrameGraphNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(activeFrameGraph));
    }
    
    private native void setActiveFrameGraph_native_Qt3DRender_QFrameGraphNode_ptr(long __this__nativeId, long activeFrameGraph);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersettings.html#renderPolicy-prop">Qt3DRender::QRenderSettings::setRenderPolicy(Qt3DRender::QRenderSettings::RenderPolicy)</a></p>
     */
    @QtPropertyWriter(name="renderPolicy")
    public final void setRenderPolicy(io.qt.qt3d.render.QRenderSettings.@NonNull RenderPolicy renderPolicy){
        setRenderPolicy_native_Qt3DRender_QRenderSettings_RenderPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), renderPolicy.value());
    }
    
    private native void setRenderPolicy_native_Qt3DRender_QRenderSettings_RenderPolicy(long __this__nativeId, int renderPolicy);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QRenderSettings(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRenderSettings(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRenderSettings instance, QDeclarativeConstructor constructor);
    
}
