package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Select entities which are within a distance threshold of a target entity</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qproximityfilter.html">Qt3DRender::QProximityFilter</a></p>
 */
public class QProximityFilter extends io.qt.qt3d.render.QFrameGraphNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QProximityFilter.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qproximityfilter.html#distanceThreshold-prop">Qt3DRender::QProximityFilter::distanceThresholdChanged(float)</a></p>
     */
    @QtPropertyNotify(name="distanceThreshold")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> distanceThresholdChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qproximityfilter.html#entity-prop">Qt3DRender::QProximityFilter::entityChanged(Qt3DCore::QEntity*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtPropertyNotify(name="entity")
    public final @NonNull Signal1<io.qt.qt3d.core.@Nullable QEntity> entityChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QProximityFilter(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QProximityFilter() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QProximityFilter(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QProximityFilter instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #distanceThreshold()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDistanceThreshold() {
        return distanceThreshold();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qproximityfilter.html#distanceThreshold-prop">Qt3DRender::QProximityFilter::distanceThreshold()const</a></p>
     */
    @QtPropertyReader(name="distanceThreshold")
    @QtUninvokable
    public final float distanceThreshold(){
        return distanceThreshold_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float distanceThreshold_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #entity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QEntity getEntity() {
        return entity();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qproximityfilter.html#entity-prop">Qt3DRender::QProximityFilter::entity()const</a></p>
     */
    @QtPropertyReader(name="entity")
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QEntity entity(){
        return entity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QEntity entity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qproximityfilter.html#distanceThreshold-prop">Qt3DRender::QProximityFilter::setDistanceThreshold(float)</a></p>
     */
    @QtPropertyWriter(name="distanceThreshold")
    public final void setDistanceThreshold(float distanceThreshold){
        setDistanceThreshold_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), distanceThreshold);
    }
    
    private native void setDistanceThreshold_native_float(long __this__nativeId, float distanceThreshold);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qproximityfilter.html#entity-prop">Qt3DRender::QProximityFilter::setEntity(Qt3DCore::QEntity*)</a></p>
     */
    @QtPropertyWriter(name="entity")
    @SuppressWarnings({"exports"})
    public final void setEntity(io.qt.qt3d.core.@Nullable QEntity entity){
        setEntity_native_Qt3DCore_QEntity_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(entity));
    }
    
    private native void setEntity_native_Qt3DCore_QEntity_ptr(long __this__nativeId, long entity);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QProximityFilter(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QProximityFilter(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QProximityFilter instance, QDeclarativeConstructor constructor);
    
}
