package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Specifies the width of rasterized lines</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qlinewidth.html">Qt3DRender::QLineWidth</a></p>
 */
public class QLineWidth extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QLineWidth.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlinewidth.html#smooth-prop">Qt3DRender::QLineWidth::smoothChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="smooth")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> smoothChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlinewidth.html#value-prop">Qt3DRender::QLineWidth::valueChanged(float)</a></p>
     */
    @QtPropertyNotify(name="value")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> valueChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QLineWidth(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QLineWidth() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QLineWidth(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QLineWidth instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlinewidth.html#smooth-prop">Qt3DRender::QLineWidth::setSmooth(bool)</a></p>
     */
    @QtPropertyWriter(name="smooth")
    public final void setSmooth(boolean enabled){
        setSmooth_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    private native void setSmooth_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlinewidth.html#value-prop">Qt3DRender::QLineWidth::setValue(float)</a></p>
     */
    @QtPropertyWriter(name="value")
    public final void setValue(float value){
        setValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setValue_native_float(long __this__nativeId, float value);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #smooth()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSmooth() {
        return smooth();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlinewidth.html#smooth-prop">Qt3DRender::QLineWidth::smooth()const</a></p>
     */
    @QtPropertyReader(name="smooth")
    @QtUninvokable
    public final boolean smooth(){
        return smooth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean smooth_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #value()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getValue() {
        return value();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlinewidth.html#value-prop">Qt3DRender::QLineWidth::value()const</a></p>
     */
    @QtPropertyReader(name="value")
    @QtUninvokable
    public final float value(){
        return value_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float value_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QLineWidth(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QLineWidth(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QLineWidth instance, QDeclarativeConstructor constructor);
    
}
