package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Simple spherical volume, defined by its center and radius</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetailboundingsphere.html">Qt3DRender::QLevelOfDetailBoundingSphere</a></p>
 */
public class QLevelOfDetailBoundingSphere extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QLevelOfDetailBoundingSphere.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QLevelOfDetailBoundingSphere(io.qt.gui.QVector3D, float)}
     *  with <code>radius = 1.0f</code>.</p>
     */
    public QLevelOfDetailBoundingSphere(io.qt.gui.@NonNull QVector3D center) {
        this(center, (float)1.0f);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QLevelOfDetailBoundingSphere(io.qt.gui.QVector3D, float)}</p>
     * <p>with: </p><ul>
     * <li><code>center = new io.qt.gui.QVector3D()</code></li>
     * <li><code>radius = 1.0f</code></li>
     * </ul>
     */
    public QLevelOfDetailBoundingSphere() {
        this(new io.qt.gui.QVector3D(), (float)1.0f);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetailboundingsphere.html#QLevelOfDetailBoundingSphere">Qt3DRender::QLevelOfDetailBoundingSphere::QLevelOfDetailBoundingSphere(QVector3D,float)</a></p>
     */
    public QLevelOfDetailBoundingSphere(io.qt.gui.@NonNull QVector3D center, float radius){
        super((QPrivateConstructor)null);
        initialize_native(this, center, radius);
    }
    
    private native static void initialize_native(QLevelOfDetailBoundingSphere instance, io.qt.gui.QVector3D center, float radius);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetailboundingsphere.html#QLevelOfDetailBoundingSphere">Qt3DRender::QLevelOfDetailBoundingSphere::QLevelOfDetailBoundingSphere(Qt3DRender::QLevelOfDetailBoundingSphere)</a></p>
     */
    public QLevelOfDetailBoundingSphere(io.qt.qt3d.render.@NonNull QLevelOfDetailBoundingSphere other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QLevelOfDetailBoundingSphere instance, io.qt.qt3d.render.QLevelOfDetailBoundingSphere other);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #center()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getCenter() {
        return center();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetailboundingsphere.html#center-prop">Qt3DRender::QLevelOfDetailBoundingSphere::center()const</a></p>
     */
    @QtPropertyReader(name="center")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D center(){
        return center_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D center_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final boolean isEmpty(){
        return isEmpty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isEmpty_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    private final boolean operator_equal(io.qt.qt3d.render.@NonNull QLevelOfDetailBoundingSphere other){
        return operator_equal_native_cref_Qt3DRender_QLevelOfDetailBoundingSphere_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_Qt3DRender_QLevelOfDetailBoundingSphere_constfct(long __this__nativeId, long other);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #radius()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getRadius() {
        return radius();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetailboundingsphere.html#radius-prop">Qt3DRender::QLevelOfDetailBoundingSphere::radius()const</a></p>
     */
    @QtPropertyReader(name="radius")
    @QtPropertyConstant
    @QtUninvokable
    public final float radius(){
        return radius_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float radius_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QLevelOfDetailBoundingSphere(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.qt3d.render.QLevelOfDetailBoundingSphere) {
            return operator_equal((io.qt.qt3d.render.QLevelOfDetailBoundingSphere) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QLevelOfDetailBoundingSphere clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QLevelOfDetailBoundingSphere clone_native(long __this_nativeId);
}
