package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Way of controlling the complexity of rendered entities based on their size on the screen</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html">Qt3DRender::QLevelOfDetail</a></p>
 */
public class QLevelOfDetail extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcCamera = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QLevelOfDetail.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#ThresholdType-enum">Qt3DRender::QLevelOfDetail::ThresholdType</a></p>
     */
    public enum ThresholdType implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#ThresholdType-enum">Qt3DRender::QLevelOfDetail::DistanceToCameraThreshold</a></p>
         */
        DistanceToCameraThreshold(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#ThresholdType-enum">Qt3DRender::QLevelOfDetail::ProjectedScreenPixelSizeThreshold</a></p>
         */
        ProjectedScreenPixelSizeThreshold(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ThresholdType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ThresholdType resolve(int value) {
            switch (value) {
            case 0: return DistanceToCameraThreshold;
            case 1: return ProjectedScreenPixelSizeThreshold;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#camera-prop">Qt3DRender::QLevelOfDetail::cameraChanged(QCamera*)</a></p>
     */
    @QtPropertyNotify(name="camera")
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QCamera> cameraChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#currentIndex-prop">Qt3DRender::QLevelOfDetail::currentIndexChanged(int)</a></p>
     */
    @QtPropertyNotify(name="currentIndex")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> currentIndexChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#thresholdType-prop">Qt3DRender::QLevelOfDetail::thresholdTypeChanged(Qt3DRender::QLevelOfDetail::ThresholdType)</a></p>
     */
    @QtPropertyNotify(name="thresholdType")
    public final @NonNull Signal1<io.qt.qt3d.render.QLevelOfDetail.@NonNull ThresholdType> thresholdTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#thresholds-prop">Qt3DRender::QLevelOfDetail::thresholdsChanged(QList&lt;qreal&gt;)</a></p>
     */
    @QtPropertyNotify(name="thresholds")
    public final @NonNull Signal1<java.util.@NonNull List<java.lang.@QtPrimitiveType@NonNull Double>> thresholdsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#volumeOverride-prop">Qt3DRender::QLevelOfDetail::volumeOverrideChanged(Qt3DRender::QLevelOfDetailBoundingSphere)</a></p>
     */
    @QtPropertyNotify(name="volumeOverride")
    public final @NonNull Signal1<io.qt.qt3d.render.@NonNull QLevelOfDetailBoundingSphere> volumeOverrideChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QLevelOfDetail(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QLevelOfDetail() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#QLevelOfDetail">Qt3DRender::QLevelOfDetail::QLevelOfDetail(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QLevelOfDetail(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QLevelOfDetail instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #camera()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QCamera getCamera() {
        return camera();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#camera-prop">Qt3DRender::QLevelOfDetail::camera()const</a></p>
     */
    @QtPropertyReader(name="camera")
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QCamera camera(){
        return camera_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QCamera camera_native_constfct(long __this__nativeId);
    
    public final io.qt.qt3d.render.@NonNull QLevelOfDetailBoundingSphere createBoundingSphere(io.qt.gui.@NonNull QVector3D center, float radius){
        return createBoundingSphere_native_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(center), radius);
    }
    
    private native io.qt.qt3d.render.QLevelOfDetailBoundingSphere createBoundingSphere_native_cref_QVector3D_float(long __this__nativeId, long center, float radius);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #currentIndex()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getCurrentIndex() {
        return currentIndex();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#currentIndex-prop">Qt3DRender::QLevelOfDetail::currentIndex()const</a></p>
     */
    @QtPropertyReader(name="currentIndex")
    @QtUninvokable
    public final int currentIndex(){
        return currentIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int currentIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#setCamera">Qt3DRender::QLevelOfDetail::setCamera(QCamera*)</a></p>
     */
    @QtPropertyWriter(name="camera")
    public final void setCamera(io.qt.qt3d.render.@Nullable QCamera camera){
        setCamera_native_Qt3DRender_QCamera_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(camera));
        __rcCamera = camera;
    }
    
    private native void setCamera_native_Qt3DRender_QCamera_ptr(long __this__nativeId, long camera);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#setCurrentIndex">Qt3DRender::QLevelOfDetail::setCurrentIndex(int)</a></p>
     */
    @QtPropertyWriter(name="currentIndex")
    public final void setCurrentIndex(int currentIndex){
        setCurrentIndex_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), currentIndex);
    }
    
    private native void setCurrentIndex_native_int(long __this__nativeId, int currentIndex);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#setThresholdType">Qt3DRender::QLevelOfDetail::setThresholdType(Qt3DRender::QLevelOfDetail::ThresholdType)</a></p>
     */
    @QtPropertyWriter(name="thresholdType")
    public final void setThresholdType(io.qt.qt3d.render.QLevelOfDetail.@NonNull ThresholdType thresholdType){
        setThresholdType_native_Qt3DRender_QLevelOfDetail_ThresholdType(QtJambi_LibraryUtilities.internal.nativeId(this), thresholdType.value());
    }
    
    private native void setThresholdType_native_Qt3DRender_QLevelOfDetail_ThresholdType(long __this__nativeId, int thresholdType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#setThresholds">Qt3DRender::QLevelOfDetail::setThresholds(QList&lt;qreal&gt;)</a></p>
     */
    @QtPropertyWriter(name="thresholds")
    public final void setThresholds(java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Double> thresholds){
        setThresholds_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), thresholds);
    }
    
    private native void setThresholds_native_cref_QList(long __this__nativeId, java.util.Collection<java.lang.@QtPrimitiveType Double> thresholds);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#volumeOverride-prop">Qt3DRender::QLevelOfDetail::setVolumeOverride(Qt3DRender::QLevelOfDetailBoundingSphere)</a></p>
     */
    @QtPropertyWriter(name="volumeOverride")
    public final void setVolumeOverride(io.qt.qt3d.render.@NonNull QLevelOfDetailBoundingSphere volumeOverride){
        setVolumeOverride_native_cref_Qt3DRender_QLevelOfDetailBoundingSphere(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(volumeOverride));
    }
    
    private native void setVolumeOverride_native_cref_Qt3DRender_QLevelOfDetailBoundingSphere(long __this__nativeId, long volumeOverride);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #thresholdType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QLevelOfDetail.@NonNull ThresholdType getThresholdType() {
        return thresholdType();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#thresholdType-prop">Qt3DRender::QLevelOfDetail::thresholdType()const</a></p>
     */
    @QtPropertyReader(name="thresholdType")
    @QtUninvokable
    public final io.qt.qt3d.render.QLevelOfDetail.@NonNull ThresholdType thresholdType(){
        return io.qt.qt3d.render.QLevelOfDetail.ThresholdType.resolve(thresholdType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int thresholdType_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #thresholds()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Double> getThresholds() {
        return thresholds();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#thresholds-prop">Qt3DRender::QLevelOfDetail::thresholds()const</a></p>
     */
    @QtPropertyReader(name="thresholds")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Double> thresholds(){
        return thresholds_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Double> thresholds_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #volumeOverride()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@NonNull QLevelOfDetailBoundingSphere getVolumeOverride() {
        return volumeOverride();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#volumeOverride-prop">Qt3DRender::QLevelOfDetail::volumeOverride()const</a></p>
     */
    @QtPropertyReader(name="volumeOverride")
    @QtUninvokable
    public final io.qt.qt3d.render.@NonNull QLevelOfDetailBoundingSphere volumeOverride(){
        return volumeOverride_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QLevelOfDetailBoundingSphere volumeOverride_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QLevelOfDetail(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QLevelOfDetail(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QLevelOfDetail instance, QDeclarativeConstructor constructor);
    
}
