package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Encapsulates geometry rendering</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html">Qt3DRender::QGeometryRenderer</a></p>
 */
public class QGeometryRenderer extends io.qt.qt3d.core.QBoundingVolume
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QGeometryRenderer.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::PrimitiveType</a></p>
     */
    public enum PrimitiveType implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::Points</a></p>
         */
        Points(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::Lines</a></p>
         */
        Lines(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::LineLoop</a></p>
         */
        LineLoop(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::LineStrip</a></p>
         */
        LineStrip(3),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::Triangles</a></p>
         */
        Triangles(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::TriangleStrip</a></p>
         */
        TriangleStrip(5),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::TriangleFan</a></p>
         */
        TriangleFan(6),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::LinesAdjacency</a></p>
         */
        LinesAdjacency(10),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::TrianglesAdjacency</a></p>
         */
        TrianglesAdjacency(12),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::LineStripAdjacency</a></p>
         */
        LineStripAdjacency(11),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::TriangleStripAdjacency</a></p>
         */
        TriangleStripAdjacency(13),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::Patches</a></p>
         */
        Patches(14);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PrimitiveType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PrimitiveType resolve(int value) {
            switch (value) {
            case 0: return Points;
            case 1: return Lines;
            case 2: return LineLoop;
            case 3: return LineStrip;
            case 4: return Triangles;
            case 5: return TriangleStrip;
            case 6: return TriangleFan;
            case 10: return LinesAdjacency;
            case 12: return TrianglesAdjacency;
            case 11: return LineStripAdjacency;
            case 13: return TriangleStripAdjacency;
            case 14: return Patches;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#firstInstance-prop">Qt3DRender::QGeometryRenderer::firstInstanceChanged(int)</a></p>
     */
    @QtPropertyNotify(name="firstInstance")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> firstInstanceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#firstVertex-prop">Qt3DRender::QGeometryRenderer::firstVertexChanged(int)</a></p>
     */
    @QtPropertyNotify(name="firstVertex")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> firstVertexChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#geometry-prop">Qt3DRender::QGeometryRenderer::geometryChanged(Qt3DCore::QGeometry*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtPropertyNotify(name="geometry")
    public final @NonNull Signal1<io.qt.qt3d.core.@Nullable QGeometry> geometryChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#indexBufferByteOffset-prop">Qt3DRender::QGeometryRenderer::indexBufferByteOffsetChanged(int)</a></p>
     */
    @QtPropertyNotify(name="indexBufferByteOffset")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> indexBufferByteOffsetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#indexOffset-prop">Qt3DRender::QGeometryRenderer::indexOffsetChanged(int)</a></p>
     */
    @QtPropertyNotify(name="indexOffset")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> indexOffsetChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#instanceCount-prop">Qt3DRender::QGeometryRenderer::instanceCountChanged(int)</a></p>
     */
    @QtPropertyNotify(name="instanceCount")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> instanceCountChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#primitiveRestartEnabled-prop">Qt3DRender::QGeometryRenderer::primitiveRestartEnabledChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="primitiveRestartEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> primitiveRestartEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#primitiveType-prop">Qt3DRender::QGeometryRenderer::primitiveTypeChanged(Qt3DRender::QGeometryRenderer::PrimitiveType)</a></p>
     */
    @QtPropertyNotify(name="primitiveType")
    public final @NonNull Signal1<io.qt.qt3d.render.QGeometryRenderer.@NonNull PrimitiveType> primitiveTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#restartIndexValue-prop">Qt3DRender::QGeometryRenderer::restartIndexValueChanged(int)</a></p>
     */
    @QtPropertyNotify(name="restartIndexValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> restartIndexValueChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#sortIndex-prop">Qt3DRender::QGeometryRenderer::sortIndexChanged(float)</a></p>
     */
    @QtPropertyNotify(name="sortIndex")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> sortIndexChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#vertexCount-prop">Qt3DRender::QGeometryRenderer::vertexCountChanged(int)</a></p>
     */
    @QtPropertyNotify(name="vertexCount")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> vertexCountChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#verticesPerPatch-prop">Qt3DRender::QGeometryRenderer::verticesPerPatchChanged(int)</a></p>
     */
    @QtPropertyNotify(name="verticesPerPatch")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> verticesPerPatchChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QGeometryRenderer(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QGeometryRenderer() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#QGeometryRenderer">Qt3DRender::QGeometryRenderer::QGeometryRenderer(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QGeometryRenderer(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QGeometryRenderer instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #firstInstance()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getFirstInstance() {
        return firstInstance();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#firstInstance-prop">Qt3DRender::QGeometryRenderer::firstInstance()const</a></p>
     */
    @QtPropertyReader(name="firstInstance")
    @QtUninvokable
    public final int firstInstance(){
        return firstInstance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int firstInstance_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #firstVertex()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getFirstVertex() {
        return firstVertex();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#firstVertex-prop">Qt3DRender::QGeometryRenderer::firstVertex()const</a></p>
     */
    @QtPropertyReader(name="firstVertex")
    @QtUninvokable
    public final int firstVertex(){
        return firstVertex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int firstVertex_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #geometry()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QGeometry getGeometry() {
        return geometry();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#geometry-prop">Qt3DRender::QGeometryRenderer::geometry()const</a></p>
     */
    @QtPropertyReader(name="geometry")
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QGeometry geometry(){
        return geometry_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QGeometry geometry_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #indexBufferByteOffset()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getIndexBufferByteOffset() {
        return indexBufferByteOffset();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#indexBufferByteOffset-prop">Qt3DRender::QGeometryRenderer::indexBufferByteOffset()const</a></p>
     */
    @QtPropertyReader(name="indexBufferByteOffset")
    @QtUninvokable
    public final int indexBufferByteOffset(){
        return indexBufferByteOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int indexBufferByteOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #indexOffset()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getIndexOffset() {
        return indexOffset();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#indexOffset-prop">Qt3DRender::QGeometryRenderer::indexOffset()const</a></p>
     */
    @QtPropertyReader(name="indexOffset")
    @QtUninvokable
    public final int indexOffset(){
        return indexOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int indexOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #instanceCount()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getInstanceCount() {
        return instanceCount();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#instanceCount-prop">Qt3DRender::QGeometryRenderer::instanceCount()const</a></p>
     */
    @QtPropertyReader(name="instanceCount")
    @QtUninvokable
    public final int instanceCount(){
        return instanceCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int instanceCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #primitiveRestartEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getPrimitiveRestartEnabled() {
        return primitiveRestartEnabled();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#primitiveRestartEnabled-prop">Qt3DRender::QGeometryRenderer::primitiveRestartEnabled()const</a></p>
     */
    @QtPropertyReader(name="primitiveRestartEnabled")
    @QtUninvokable
    public final boolean primitiveRestartEnabled(){
        return primitiveRestartEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean primitiveRestartEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #primitiveType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QGeometryRenderer.@NonNull PrimitiveType getPrimitiveType() {
        return primitiveType();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#primitiveType-prop">Qt3DRender::QGeometryRenderer::primitiveType()const</a></p>
     */
    @QtPropertyReader(name="primitiveType")
    @QtUninvokable
    public final io.qt.qt3d.render.QGeometryRenderer.@NonNull PrimitiveType primitiveType(){
        return io.qt.qt3d.render.QGeometryRenderer.PrimitiveType.resolve(primitiveType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int primitiveType_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #restartIndexValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getRestartIndexValue() {
        return restartIndexValue();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#restartIndexValue-prop">Qt3DRender::QGeometryRenderer::restartIndexValue()const</a></p>
     */
    @QtPropertyReader(name="restartIndexValue")
    @QtUninvokable
    public final int restartIndexValue(){
        return restartIndexValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int restartIndexValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#firstInstance-prop">Qt3DRender::QGeometryRenderer::setFirstInstance(int)</a></p>
     */
    @QtPropertyWriter(name="firstInstance")
    public final void setFirstInstance(int firstInstance){
        setFirstInstance_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), firstInstance);
    }
    
    private native void setFirstInstance_native_int(long __this__nativeId, int firstInstance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#firstVertex-prop">Qt3DRender::QGeometryRenderer::setFirstVertex(int)</a></p>
     */
    @QtPropertyWriter(name="firstVertex")
    public final void setFirstVertex(int firstVertex){
        setFirstVertex_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), firstVertex);
    }
    
    private native void setFirstVertex_native_int(long __this__nativeId, int firstVertex);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#geometry-prop">Qt3DRender::QGeometryRenderer::setGeometry(Qt3DCore::QGeometry*)</a></p>
     */
    @QtPropertyWriter(name="geometry")
    @SuppressWarnings({"exports"})
    public final void setGeometry(io.qt.qt3d.core.@Nullable QGeometry geometry){
        setGeometry_native_Qt3DCore_QGeometry_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(geometry));
    }
    
    private native void setGeometry_native_Qt3DCore_QGeometry_ptr(long __this__nativeId, long geometry);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#indexBufferByteOffset-prop">Qt3DRender::QGeometryRenderer::setIndexBufferByteOffset(int)</a></p>
     */
    @QtPropertyWriter(name="indexBufferByteOffset")
    public final void setIndexBufferByteOffset(int offset){
        setIndexBufferByteOffset_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), offset);
    }
    
    private native void setIndexBufferByteOffset_native_int(long __this__nativeId, int offset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#indexOffset-prop">Qt3DRender::QGeometryRenderer::setIndexOffset(int)</a></p>
     */
    @QtPropertyWriter(name="indexOffset")
    public final void setIndexOffset(int indexOffset){
        setIndexOffset_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), indexOffset);
    }
    
    private native void setIndexOffset_native_int(long __this__nativeId, int indexOffset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#instanceCount-prop">Qt3DRender::QGeometryRenderer::setInstanceCount(int)</a></p>
     */
    @QtPropertyWriter(name="instanceCount")
    public final void setInstanceCount(int instanceCount){
        setInstanceCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), instanceCount);
    }
    
    private native void setInstanceCount_native_int(long __this__nativeId, int instanceCount);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#primitiveRestartEnabled-prop">Qt3DRender::QGeometryRenderer::setPrimitiveRestartEnabled(bool)</a></p>
     */
    @QtPropertyWriter(name="primitiveRestartEnabled")
    public final void setPrimitiveRestartEnabled(boolean enabled){
        setPrimitiveRestartEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    private native void setPrimitiveRestartEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#primitiveType-prop">Qt3DRender::QGeometryRenderer::setPrimitiveType(Qt3DRender::QGeometryRenderer::PrimitiveType)</a></p>
     */
    @QtPropertyWriter(name="primitiveType")
    public final void setPrimitiveType(io.qt.qt3d.render.QGeometryRenderer.@NonNull PrimitiveType primitiveType){
        setPrimitiveType_native_Qt3DRender_QGeometryRenderer_PrimitiveType(QtJambi_LibraryUtilities.internal.nativeId(this), primitiveType.value());
    }
    
    private native void setPrimitiveType_native_Qt3DRender_QGeometryRenderer_PrimitiveType(long __this__nativeId, int primitiveType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#restartIndexValue-prop">Qt3DRender::QGeometryRenderer::setRestartIndexValue(int)</a></p>
     */
    @QtPropertyWriter(name="restartIndexValue")
    public final void setRestartIndexValue(int index){
        setRestartIndexValue_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    private native void setRestartIndexValue_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#sortIndex-prop">Qt3DRender::QGeometryRenderer::setSortIndex(float)</a></p>
     */
    @QtPropertyWriter(name="sortIndex")
    public final void setSortIndex(float sortIndex){
        setSortIndex_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), sortIndex);
    }
    
    private native void setSortIndex_native_float(long __this__nativeId, float sortIndex);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#vertexCount-prop">Qt3DRender::QGeometryRenderer::setVertexCount(int)</a></p>
     */
    @QtPropertyWriter(name="vertexCount")
    public final void setVertexCount(int vertexCount){
        setVertexCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), vertexCount);
    }
    
    private native void setVertexCount_native_int(long __this__nativeId, int vertexCount);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#verticesPerPatch-prop">Qt3DRender::QGeometryRenderer::setVerticesPerPatch(int)</a></p>
     */
    @QtPropertyWriter(name="verticesPerPatch")
    public final void setVerticesPerPatch(int verticesPerPatch){
        setVerticesPerPatch_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), verticesPerPatch);
    }
    
    private native void setVerticesPerPatch_native_int(long __this__nativeId, int verticesPerPatch);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sortIndex()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getSortIndex() {
        return sortIndex();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#sortIndex-prop">Qt3DRender::QGeometryRenderer::sortIndex()const</a></p>
     */
    @QtPropertyReader(name="sortIndex")
    @QtUninvokable
    public final float sortIndex(){
        return sortIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float sortIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vertexCount()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVertexCount() {
        return vertexCount();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#vertexCount-prop">Qt3DRender::QGeometryRenderer::vertexCount()const</a></p>
     */
    @QtPropertyReader(name="vertexCount")
    @QtUninvokable
    public final int vertexCount(){
        return vertexCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int vertexCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #verticesPerPatch()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVerticesPerPatch() {
        return verticesPerPatch();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#verticesPerPatch-prop">Qt3DRender::QGeometryRenderer::verticesPerPatch()const</a></p>
     */
    @QtPropertyReader(name="verticesPerPatch")
    @QtUninvokable
    public final int verticesPerPatch(){
        return verticesPerPatch_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int verticesPerPatch_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QGeometryRenderer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QGeometryRenderer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QGeometryRenderer instance, QDeclarativeConstructor constructor);
    
}
