package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>FrameGraph node to issue work for the compute shader on GPU</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html">Qt3DRender::QDispatchCompute</a></p>
 */
public class QDispatchCompute extends io.qt.qt3d.render.QFrameGraphNode
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDispatchCompute.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupX-prop">Qt3DRender::QDispatchCompute::workGroupXChanged()</a></p>
     */
    @QtPropertyNotify(name="workGroupX")
    public final @NonNull Signal0 workGroupXChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupY-prop">Qt3DRender::QDispatchCompute::workGroupYChanged()</a></p>
     */
    @QtPropertyNotify(name="workGroupY")
    public final @NonNull Signal0 workGroupYChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupZ-prop">Qt3DRender::QDispatchCompute::workGroupZChanged()</a></p>
     */
    @QtPropertyNotify(name="workGroupZ")
    public final @NonNull Signal0 workGroupZChanged = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QDispatchCompute(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QDispatchCompute() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#QDispatchCompute">Qt3DRender::QDispatchCompute::QDispatchCompute(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QDispatchCompute(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QDispatchCompute instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupX-prop">Qt3DRender::QDispatchCompute::setWorkGroupX(int)</a></p>
     */
    @QtPropertyWriter(name="workGroupX")
    public final void setWorkGroupX(int workGroupX){
        setWorkGroupX_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), workGroupX);
    }
    
    private native void setWorkGroupX_native_int(long __this__nativeId, int workGroupX);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupY-prop">Qt3DRender::QDispatchCompute::setWorkGroupY(int)</a></p>
     */
    @QtPropertyWriter(name="workGroupY")
    public final void setWorkGroupY(int workGroupY){
        setWorkGroupY_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), workGroupY);
    }
    
    private native void setWorkGroupY_native_int(long __this__nativeId, int workGroupY);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupZ-prop">Qt3DRender::QDispatchCompute::setWorkGroupZ(int)</a></p>
     */
    @QtPropertyWriter(name="workGroupZ")
    public final void setWorkGroupZ(int workGroupZ){
        setWorkGroupZ_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), workGroupZ);
    }
    
    private native void setWorkGroupZ_native_int(long __this__nativeId, int workGroupZ);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #workGroupX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getWorkGroupX() {
        return workGroupX();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupX-prop">Qt3DRender::QDispatchCompute::workGroupX()const</a></p>
     */
    @QtPropertyReader(name="workGroupX")
    @QtUninvokable
    public final int workGroupX(){
        return workGroupX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int workGroupX_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #workGroupY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getWorkGroupY() {
        return workGroupY();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupY-prop">Qt3DRender::QDispatchCompute::workGroupY()const</a></p>
     */
    @QtPropertyReader(name="workGroupY")
    @QtUninvokable
    public final int workGroupY(){
        return workGroupY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int workGroupY_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #workGroupZ()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getWorkGroupZ() {
        return workGroupZ();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdispatchcompute.html#workGroupZ-prop">Qt3DRender::QDispatchCompute::workGroupZ()const</a></p>
     */
    @QtPropertyReader(name="workGroupZ")
    @QtUninvokable
    public final int workGroupZ(){
        return workGroupZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int workGroupZ_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDispatchCompute(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QDispatchCompute(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QDispatchCompute instance, QDeclarativeConstructor constructor);
    
}
