package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Qt3DRender::QCameraLens specifies the projection matrix that will be used to define a Camera for a 3D scene</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html">Qt3DRender::QCameraLens</a></p>
 */
public class QCameraLens extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCameraLens.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#ProjectionType-enum">Qt3DRender::QCameraLens::ProjectionType</a></p>
     */
    public enum ProjectionType implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#ProjectionType-enum">Qt3DRender::QCameraLens::OrthographicProjection</a></p>
         */
        OrthographicProjection(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#ProjectionType-enum">Qt3DRender::QCameraLens::PerspectiveProjection</a></p>
         */
        PerspectiveProjection(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#ProjectionType-enum">Qt3DRender::QCameraLens::FrustumProjection</a></p>
         */
        FrustumProjection(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#ProjectionType-enum">Qt3DRender::QCameraLens::CustomProjection</a></p>
         */
        CustomProjection(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ProjectionType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ProjectionType resolve(int value) {
            switch (value) {
            case 0: return OrthographicProjection;
            case 1: return PerspectiveProjection;
            case 2: return FrustumProjection;
            case 3: return CustomProjection;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#aspectRatio-prop">Qt3DRender::QCameraLens::aspectRatioChanged(float)</a></p>
     */
    @QtPropertyNotify(name="aspectRatio")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> aspectRatioChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#bottom-prop">Qt3DRender::QCameraLens::bottomChanged(float)</a></p>
     */
    @QtPropertyNotify(name="bottom")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> bottomChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#exposure-prop">Qt3DRender::QCameraLens::exposureChanged(float)</a></p>
     */
    @QtPropertyNotify(name="exposure")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> exposureChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#farPlane-prop">Qt3DRender::QCameraLens::farPlaneChanged(float)</a></p>
     */
    @QtPropertyNotify(name="farPlane")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> farPlaneChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#fieldOfView-prop">Qt3DRender::QCameraLens::fieldOfViewChanged(float)</a></p>
     */
    @QtPropertyNotify(name="fieldOfView")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> fieldOfViewChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#left-prop">Qt3DRender::QCameraLens::leftChanged(float)</a></p>
     */
    @QtPropertyNotify(name="left")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> leftChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#nearPlane-prop">Qt3DRender::QCameraLens::nearPlaneChanged(float)</a></p>
     */
    @QtPropertyNotify(name="nearPlane")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> nearPlaneChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#projectionMatrix-prop">Qt3DRender::QCameraLens::projectionMatrixChanged(QMatrix4x4)</a></p>
     */
    @QtPropertyNotify(name="projectionMatrix")
    public final @NonNull Signal1<io.qt.gui.@NonNull QMatrix4x4> projectionMatrixChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#projectionType-prop">Qt3DRender::QCameraLens::projectionTypeChanged(Qt3DRender::QCameraLens::ProjectionType)</a></p>
     */
    @QtPropertyNotify(name="projectionType")
    public final @NonNull Signal1<io.qt.qt3d.render.QCameraLens.@NonNull ProjectionType> projectionTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#right-prop">Qt3DRender::QCameraLens::rightChanged(float)</a></p>
     */
    @QtPropertyNotify(name="right")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> rightChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#top-prop">Qt3DRender::QCameraLens::topChanged(float)</a></p>
     */
    @QtPropertyNotify(name="top")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> topChanged = new Signal1<>();

    public final @NonNull Signal2<io.qt.gui.@NonNull QVector3D, java.lang.@QtPrimitiveType@NonNull Float> viewSphere = new Signal2<>();
    
    /**
     * <p>Overloaded constructor for {@link #QCameraLens(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QCameraLens() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#QCameraLens">Qt3DRender::QCameraLens::QCameraLens(QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QCameraLens(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QCameraLens instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #aspectRatio()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getAspectRatio() {
        return aspectRatio();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#aspectRatio-prop">Qt3DRender::QCameraLens::aspectRatio()const</a></p>
     */
    @QtPropertyReader(name="aspectRatio")
    @QtUninvokable
    public final float aspectRatio(){
        return aspectRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float aspectRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #bottom()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getBottom() {
        return bottom();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#bottom-prop">Qt3DRender::QCameraLens::bottom()const</a></p>
     */
    @QtPropertyReader(name="bottom")
    @QtUninvokable
    public final float bottom(){
        return bottom_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float bottom_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #exposure()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getExposure() {
        return exposure();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#exposure-prop">Qt3DRender::QCameraLens::exposure()const</a></p>
     */
    @QtPropertyReader(name="exposure")
    @QtUninvokable
    public final float exposure(){
        return exposure_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float exposure_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #farPlane()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getFarPlane() {
        return farPlane();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#farPlane-prop">Qt3DRender::QCameraLens::farPlane()const</a></p>
     */
    @QtPropertyReader(name="farPlane")
    @QtUninvokable
    public final float farPlane(){
        return farPlane_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float farPlane_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #fieldOfView()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getFieldOfView() {
        return fieldOfView();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#fieldOfView-prop">Qt3DRender::QCameraLens::fieldOfView()const</a></p>
     */
    @QtPropertyReader(name="fieldOfView")
    @QtUninvokable
    public final float fieldOfView(){
        return fieldOfView_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float fieldOfView_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #left()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getLeft() {
        return left();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#left-prop">Qt3DRender::QCameraLens::left()const</a></p>
     */
    @QtPropertyReader(name="left")
    @QtUninvokable
    public final float left(){
        return left_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float left_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #nearPlane()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getNearPlane() {
        return nearPlane();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#nearPlane-prop">Qt3DRender::QCameraLens::nearPlane()const</a></p>
     */
    @QtPropertyReader(name="nearPlane")
    @QtUninvokable
    public final float nearPlane(){
        return nearPlane_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float nearPlane_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #projectionMatrix()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QMatrix4x4 getProjectionMatrix() {
        return projectionMatrix();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#projectionMatrix-prop">Qt3DRender::QCameraLens::projectionMatrix()const</a></p>
     */
    @QtPropertyReader(name="projectionMatrix")
    @QtUninvokable
    public final io.qt.gui.@NonNull QMatrix4x4 projectionMatrix(){
        return projectionMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QMatrix4x4 projectionMatrix_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #projectionType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QCameraLens.@NonNull ProjectionType getProjectionType() {
        return projectionType();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#projectionType-prop">Qt3DRender::QCameraLens::projectionType()const</a></p>
     */
    @QtPropertyReader(name="projectionType")
    @QtUninvokable
    public final io.qt.qt3d.render.QCameraLens.@NonNull ProjectionType projectionType(){
        return io.qt.qt3d.render.QCameraLens.ProjectionType.resolve(projectionType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int projectionType_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #right()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getRight() {
        return right();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#right-prop">Qt3DRender::QCameraLens::right()const</a></p>
     */
    @QtPropertyReader(name="right")
    @QtUninvokable
    public final float right(){
        return right_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float right_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#setAspectRatio">Qt3DRender::QCameraLens::setAspectRatio(float)</a></p>
     */
    @QtPropertyWriter(name="aspectRatio")
    public final void setAspectRatio(float aspectRatio){
        setAspectRatio_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), aspectRatio);
    }
    
    private native void setAspectRatio_native_float(long __this__nativeId, float aspectRatio);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#setBottom">Qt3DRender::QCameraLens::setBottom(float)</a></p>
     */
    @QtPropertyWriter(name="bottom")
    public final void setBottom(float bottom){
        setBottom_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), bottom);
    }
    
    private native void setBottom_native_float(long __this__nativeId, float bottom);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#setExposure">Qt3DRender::QCameraLens::setExposure(float)</a></p>
     */
    @QtPropertyWriter(name="exposure")
    public final void setExposure(float exposure){
        setExposure_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), exposure);
    }
    
    private native void setExposure_native_float(long __this__nativeId, float exposure);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#setFarPlane">Qt3DRender::QCameraLens::setFarPlane(float)</a></p>
     */
    @QtPropertyWriter(name="farPlane")
    public final void setFarPlane(float farPlane){
        setFarPlane_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), farPlane);
    }
    
    private native void setFarPlane_native_float(long __this__nativeId, float farPlane);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#setFieldOfView">Qt3DRender::QCameraLens::setFieldOfView(float)</a></p>
     */
    @QtPropertyWriter(name="fieldOfView")
    public final void setFieldOfView(float fieldOfView){
        setFieldOfView_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), fieldOfView);
    }
    
    private native void setFieldOfView_native_float(long __this__nativeId, float fieldOfView);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#setFrustumProjection">Qt3DRender::QCameraLens::setFrustumProjection(float,float,float,float,float,float)</a></p>
     */
    @QtUninvokable
    public final void setFrustumProjection(float left, float right, float bottom, float top, float nearPlane, float farPlane){
        setFrustumProjection_native_float_float_float_float_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), left, right, bottom, top, nearPlane, farPlane);
    }
    
    @QtUninvokable
    private native void setFrustumProjection_native_float_float_float_float_float_float(long __this__nativeId, float left, float right, float bottom, float top, float nearPlane, float farPlane);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#setLeft">Qt3DRender::QCameraLens::setLeft(float)</a></p>
     */
    @QtPropertyWriter(name="left")
    public final void setLeft(float left){
        setLeft_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), left);
    }
    
    private native void setLeft_native_float(long __this__nativeId, float left);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#setNearPlane">Qt3DRender::QCameraLens::setNearPlane(float)</a></p>
     */
    @QtPropertyWriter(name="nearPlane")
    public final void setNearPlane(float nearPlane){
        setNearPlane_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), nearPlane);
    }
    
    private native void setNearPlane_native_float(long __this__nativeId, float nearPlane);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#setOrthographicProjection">Qt3DRender::QCameraLens::setOrthographicProjection(float,float,float,float,float,float)</a></p>
     */
    @QtUninvokable
    public final void setOrthographicProjection(float left, float right, float bottom, float top, float nearPlane, float farPlane){
        setOrthographicProjection_native_float_float_float_float_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), left, right, bottom, top, nearPlane, farPlane);
    }
    
    @QtUninvokable
    private native void setOrthographicProjection_native_float_float_float_float_float_float(long __this__nativeId, float left, float right, float bottom, float top, float nearPlane, float farPlane);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#setPerspectiveProjection">Qt3DRender::QCameraLens::setPerspectiveProjection(float,float,float,float)</a></p>
     */
    @QtUninvokable
    public final void setPerspectiveProjection(float fieldOfView, float aspect, float nearPlane, float farPlane){
        setPerspectiveProjection_native_float_float_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), fieldOfView, aspect, nearPlane, farPlane);
    }
    
    @QtUninvokable
    private native void setPerspectiveProjection_native_float_float_float_float(long __this__nativeId, float fieldOfView, float aspect, float nearPlane, float farPlane);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#setProjectionMatrix">Qt3DRender::QCameraLens::setProjectionMatrix(QMatrix4x4)</a></p>
     */
    @QtPropertyWriter(name="projectionMatrix")
    public final void setProjectionMatrix(io.qt.gui.@NonNull QMatrix4x4 projectionMatrix){
        setProjectionMatrix_native_cref_QMatrix4x4(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(projectionMatrix));
    }
    
    private native void setProjectionMatrix_native_cref_QMatrix4x4(long __this__nativeId, long projectionMatrix);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#setProjectionType">Qt3DRender::QCameraLens::setProjectionType(Qt3DRender::QCameraLens::ProjectionType)</a></p>
     */
    @QtPropertyWriter(name="projectionType")
    public final void setProjectionType(io.qt.qt3d.render.QCameraLens.@NonNull ProjectionType projectionType){
        setProjectionType_native_Qt3DRender_QCameraLens_ProjectionType(QtJambi_LibraryUtilities.internal.nativeId(this), projectionType.value());
    }
    
    private native void setProjectionType_native_Qt3DRender_QCameraLens_ProjectionType(long __this__nativeId, int projectionType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#setRight">Qt3DRender::QCameraLens::setRight(float)</a></p>
     */
    @QtPropertyWriter(name="right")
    public final void setRight(float right){
        setRight_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), right);
    }
    
    private native void setRight_native_float(long __this__nativeId, float right);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#setTop">Qt3DRender::QCameraLens::setTop(float)</a></p>
     */
    @QtPropertyWriter(name="top")
    public final void setTop(float top){
        setTop_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), top);
    }
    
    private native void setTop_native_float(long __this__nativeId, float top);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #top()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getTop() {
        return top();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcameralens.html#top-prop">Qt3DRender::QCameraLens::top()const</a></p>
     */
    @QtPropertyReader(name="top")
    @QtUninvokable
    public final float top(){
        return top_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float top_native_constfct(long __this__nativeId);
    
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void viewAll(io.qt.qt3d.core.@NonNull QNodeId cameraId){
        viewAll_native_Qt3DCore_QNodeId(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(cameraId));
    }
    
    @QtUninvokable
    private native void viewAll_native_Qt3DCore_QNodeId(long __this__nativeId, long cameraId);
    
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void viewEntity(io.qt.qt3d.core.@NonNull QNodeId entityId, io.qt.qt3d.core.@NonNull QNodeId cameraId){
        viewEntity_native_Qt3DCore_QNodeId_Qt3DCore_QNodeId(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(entityId), QtJambi_LibraryUtilities.internal.checkedNativeId(cameraId));
    }
    
    @QtUninvokable
    private native void viewEntity_native_Qt3DCore_QNodeId_Qt3DCore_QNodeId(long __this__nativeId, long entityId, long cameraId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QCameraLens(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QCameraLens(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QCameraLens instance, QDeclarativeConstructor constructor);
    
}
