package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Defines a view point through which the scene will be rendered</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qcamera.html">Qt3DRender::QCamera</a></p>
 */
public class QCamera extends io.qt.qt3d.core.QEntity
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCamera.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#CameraTranslationOption-enum">Qt3DRender::QCamera::CameraTranslationOption</a></p>
     */
    public enum CameraTranslationOption implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#CameraTranslationOption-enum">Qt3DRender::QCamera::TranslateViewCenter</a></p>
         */
        TranslateViewCenter(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#CameraTranslationOption-enum">Qt3DRender::QCamera::DontTranslateViewCenter</a></p>
         */
        DontTranslateViewCenter(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private CameraTranslationOption(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull CameraTranslationOption resolve(int value) {
            switch (value) {
            case 0: return TranslateViewCenter;
            case 1: return DontTranslateViewCenter;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#aspectRatio-prop">Qt3DRender::QCamera::aspectRatioChanged(float)</a></p>
     */
    @QtPropertyNotify(name="aspectRatio")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> aspectRatioChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#bottom-prop">Qt3DRender::QCamera::bottomChanged(float)</a></p>
     */
    @QtPropertyNotify(name="bottom")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> bottomChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#exposure-prop">Qt3DRender::QCamera::exposureChanged(float)</a></p>
     */
    @QtPropertyNotify(name="exposure")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> exposureChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#farPlane-prop">Qt3DRender::QCamera::farPlaneChanged(float)</a></p>
     */
    @QtPropertyNotify(name="farPlane")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> farPlaneChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#fieldOfView-prop">Qt3DRender::QCamera::fieldOfViewChanged(float)</a></p>
     */
    @QtPropertyNotify(name="fieldOfView")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> fieldOfViewChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#left-prop">Qt3DRender::QCamera::leftChanged(float)</a></p>
     */
    @QtPropertyNotify(name="left")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> leftChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#nearPlane-prop">Qt3DRender::QCamera::nearPlaneChanged(float)</a></p>
     */
    @QtPropertyNotify(name="nearPlane")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> nearPlaneChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#position-prop">Qt3DRender::QCamera::positionChanged(QVector3D)</a></p>
     */
    @QtPropertyNotify(name="position")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> positionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#projectionMatrix-prop">Qt3DRender::QCamera::projectionMatrixChanged(QMatrix4x4)</a></p>
     */
    @QtPropertyNotify(name="projectionMatrix")
    public final @NonNull Signal1<io.qt.gui.@NonNull QMatrix4x4> projectionMatrixChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#projectionType-prop">Qt3DRender::QCamera::projectionTypeChanged(Qt3DRender::QCameraLens::ProjectionType)</a></p>
     */
    @QtPropertyNotify(name="projectionType")
    public final @NonNull Signal1<io.qt.qt3d.render.QCameraLens.@NonNull ProjectionType> projectionTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#right-prop">Qt3DRender::QCamera::rightChanged(float)</a></p>
     */
    @QtPropertyNotify(name="right")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> rightChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#top-prop">Qt3DRender::QCamera::topChanged(float)</a></p>
     */
    @QtPropertyNotify(name="top")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> topChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#upVector-prop">Qt3DRender::QCamera::upVectorChanged(QVector3D)</a></p>
     */
    @QtPropertyNotify(name="upVector")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> upVectorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#viewCenter-prop">Qt3DRender::QCamera::viewCenterChanged(QVector3D)</a></p>
     */
    @QtPropertyNotify(name="viewCenter")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> viewCenterChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera-obsolete.html#viewMatrix-prop">Qt3DRender::QCamera::viewMatrixChanged()</a></p>
     */
    @QtPropertyNotify(name="viewMatrix")
    public final @NonNull Signal0 viewMatrixChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#viewVector-prop">Qt3DRender::QCamera::viewVectorChanged(QVector3D)</a></p>
     */
    @QtPropertyNotify(name="viewVector")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> viewVectorChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QCamera(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QCamera() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#QCamera">Qt3DRender::QCamera::QCamera(QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QCamera(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QCamera instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #aspectRatio()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getAspectRatio() {
        return aspectRatio();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#aspectRatio-prop">Qt3DRender::QCamera::aspectRatio()const</a></p>
     */
    @QtPropertyReader(name="aspectRatio")
    @QtUninvokable
    public final float aspectRatio(){
        return aspectRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float aspectRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #bottom()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getBottom() {
        return bottom();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#bottom-prop">Qt3DRender::QCamera::bottom()const</a></p>
     */
    @QtPropertyReader(name="bottom")
    @QtUninvokable
    public final float bottom(){
        return bottom_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float bottom_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #exposure()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getExposure() {
        return exposure();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#exposure-prop">Qt3DRender::QCamera::exposure()const</a></p>
     */
    @QtPropertyReader(name="exposure")
    @QtUninvokable
    public final float exposure(){
        return exposure_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float exposure_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #farPlane()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getFarPlane() {
        return farPlane();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#farPlane-prop">Qt3DRender::QCamera::farPlane()const</a></p>
     */
    @QtPropertyReader(name="farPlane")
    @QtUninvokable
    public final float farPlane(){
        return farPlane_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float farPlane_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #fieldOfView()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getFieldOfView() {
        return fieldOfView();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#fieldOfView-prop">Qt3DRender::QCamera::fieldOfView()const</a></p>
     */
    @QtPropertyReader(name="fieldOfView")
    @QtUninvokable
    public final float fieldOfView(){
        return fieldOfView_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float fieldOfView_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #left()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getLeft() {
        return left();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#left-prop">Qt3DRender::QCamera::left()const</a></p>
     */
    @QtPropertyReader(name="left")
    @QtUninvokable
    public final float left(){
        return left_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float left_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #lens()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QCameraLens getLens() {
        return lens();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#lens">Qt3DRender::QCamera::lens()const</a></p>
     */
    @QtPropertyReader(name="lens")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QCameraLens lens(){
        return lens_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QCameraLens lens_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #nearPlane()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getNearPlane() {
        return nearPlane();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#nearPlane-prop">Qt3DRender::QCamera::nearPlane()const</a></p>
     */
    @QtPropertyReader(name="nearPlane")
    @QtUninvokable
    public final float nearPlane(){
        return nearPlane_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float nearPlane_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#pan">Qt3DRender::QCamera::pan(float)</a></p>
     */
    public final void pan(float angle){
        pan_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    private native void pan_native_float(long __this__nativeId, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#pan-1">Qt3DRender::QCamera::pan(float,QVector3D)</a></p>
     */
    public final void pan(float angle, io.qt.gui.@NonNull QVector3D axis){
        pan_native_float_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), angle, QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    private native void pan_native_float_cref_QVector3D(long __this__nativeId, float angle, long axis);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#panAboutViewCenter">Qt3DRender::QCamera::panAboutViewCenter(float)</a></p>
     */
    public final void panAboutViewCenter(float angle){
        panAboutViewCenter_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    private native void panAboutViewCenter_native_float(long __this__nativeId, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#panAboutViewCenter-1">Qt3DRender::QCamera::panAboutViewCenter(float,QVector3D)</a></p>
     */
    public final void panAboutViewCenter(float angle, io.qt.gui.@NonNull QVector3D axis){
        panAboutViewCenter_native_float_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), angle, QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    private native void panAboutViewCenter_native_float_cref_QVector3D(long __this__nativeId, float angle, long axis);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#panRotation">Qt3DRender::QCamera::panRotation(float)const</a></p>
     */
    public final io.qt.gui.@NonNull QQuaternion panRotation(float angle){
        return panRotation_native_float_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    private native io.qt.gui.QQuaternion panRotation_native_float_constfct(long __this__nativeId, float angle);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #position()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getPosition() {
        return position();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#position-prop">Qt3DRender::QCamera::position()const</a></p>
     */
    @QtPropertyReader(name="position")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D position_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #projectionMatrix()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QMatrix4x4 getProjectionMatrix() {
        return projectionMatrix();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#projectionMatrix-prop">Qt3DRender::QCamera::projectionMatrix()const</a></p>
     */
    @QtPropertyReader(name="projectionMatrix")
    @QtUninvokable
    public final io.qt.gui.@NonNull QMatrix4x4 projectionMatrix(){
        return projectionMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QMatrix4x4 projectionMatrix_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #projectionType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QCameraLens.@NonNull ProjectionType getProjectionType() {
        return projectionType();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#projectionType-prop">Qt3DRender::QCamera::projectionType()const</a></p>
     */
    @QtPropertyReader(name="projectionType")
    @QtUninvokable
    public final io.qt.qt3d.render.QCameraLens.@NonNull ProjectionType projectionType(){
        return io.qt.qt3d.render.QCameraLens.ProjectionType.resolve(projectionType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int projectionType_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #right()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getRight() {
        return right();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#right-prop">Qt3DRender::QCamera::right()const</a></p>
     */
    @QtPropertyReader(name="right")
    @QtUninvokable
    public final float right(){
        return right_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float right_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#roll">Qt3DRender::QCamera::roll(float)</a></p>
     */
    public final void roll(float angle){
        roll_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    private native void roll_native_float(long __this__nativeId, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#rollAboutViewCenter">Qt3DRender::QCamera::rollAboutViewCenter(float)</a></p>
     */
    public final void rollAboutViewCenter(float angle){
        rollAboutViewCenter_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    private native void rollAboutViewCenter_native_float(long __this__nativeId, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#rollRotation">Qt3DRender::QCamera::rollRotation(float)const</a></p>
     */
    public final io.qt.gui.@NonNull QQuaternion rollRotation(float angle){
        return rollRotation_native_float_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    private native io.qt.gui.QQuaternion rollRotation_native_float_constfct(long __this__nativeId, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#rotate">Qt3DRender::QCamera::rotate(QQuaternion)</a></p>
     */
    public final void rotate(io.qt.gui.@NonNull QQuaternion q){
        rotate_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(q));
    }
    
    private native void rotate_native_cref_QQuaternion(long __this__nativeId, long q);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#rotateAboutViewCenter">Qt3DRender::QCamera::rotateAboutViewCenter(QQuaternion)</a></p>
     */
    public final void rotateAboutViewCenter(io.qt.gui.@NonNull QQuaternion q){
        rotateAboutViewCenter_native_cref_QQuaternion(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(q));
    }
    
    private native void rotateAboutViewCenter_native_cref_QQuaternion(long __this__nativeId, long q);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#rotation">Qt3DRender::QCamera::rotation(float,QVector3D)const</a></p>
     */
    public final io.qt.gui.@NonNull QQuaternion rotation(float angle, io.qt.gui.@NonNull QVector3D axis){
        return rotation_native_float_cref_QVector3D_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), angle, QtJambi_LibraryUtilities.internal.checkedNativeId(axis));
    }
    
    private native io.qt.gui.QQuaternion rotation_native_float_cref_QVector3D_constfct(long __this__nativeId, float angle, long axis);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#setAspectRatio">Qt3DRender::QCamera::setAspectRatio(float)</a></p>
     */
    @QtPropertyWriter(name="aspectRatio")
    public final void setAspectRatio(float aspectRatio){
        setAspectRatio_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), aspectRatio);
    }
    
    private native void setAspectRatio_native_float(long __this__nativeId, float aspectRatio);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#setBottom">Qt3DRender::QCamera::setBottom(float)</a></p>
     */
    @QtPropertyWriter(name="bottom")
    public final void setBottom(float bottom){
        setBottom_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), bottom);
    }
    
    private native void setBottom_native_float(long __this__nativeId, float bottom);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#setExposure">Qt3DRender::QCamera::setExposure(float)</a></p>
     */
    @QtPropertyWriter(name="exposure")
    public final void setExposure(float exposure){
        setExposure_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), exposure);
    }
    
    private native void setExposure_native_float(long __this__nativeId, float exposure);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#setFarPlane">Qt3DRender::QCamera::setFarPlane(float)</a></p>
     */
    @QtPropertyWriter(name="farPlane")
    public final void setFarPlane(float farPlane){
        setFarPlane_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), farPlane);
    }
    
    private native void setFarPlane_native_float(long __this__nativeId, float farPlane);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#setFieldOfView">Qt3DRender::QCamera::setFieldOfView(float)</a></p>
     */
    @QtPropertyWriter(name="fieldOfView")
    public final void setFieldOfView(float fieldOfView){
        setFieldOfView_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), fieldOfView);
    }
    
    private native void setFieldOfView_native_float(long __this__nativeId, float fieldOfView);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#setLeft">Qt3DRender::QCamera::setLeft(float)</a></p>
     */
    @QtPropertyWriter(name="left")
    public final void setLeft(float left){
        setLeft_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), left);
    }
    
    private native void setLeft_native_float(long __this__nativeId, float left);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#setNearPlane">Qt3DRender::QCamera::setNearPlane(float)</a></p>
     */
    @QtPropertyWriter(name="nearPlane")
    public final void setNearPlane(float nearPlane){
        setNearPlane_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), nearPlane);
    }
    
    private native void setNearPlane_native_float(long __this__nativeId, float nearPlane);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#setPosition">Qt3DRender::QCamera::setPosition(QVector3D)</a></p>
     */
    @QtPropertyWriter(name="position")
    public final void setPosition(io.qt.gui.@NonNull QVector3D position){
        setPosition_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(position));
    }
    
    private native void setPosition_native_cref_QVector3D(long __this__nativeId, long position);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#setProjectionMatrix">Qt3DRender::QCamera::setProjectionMatrix(QMatrix4x4)</a></p>
     */
    @QtPropertyWriter(name="projectionMatrix")
    public final void setProjectionMatrix(io.qt.gui.@NonNull QMatrix4x4 projectionMatrix){
        setProjectionMatrix_native_cref_QMatrix4x4(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(projectionMatrix));
    }
    
    private native void setProjectionMatrix_native_cref_QMatrix4x4(long __this__nativeId, long projectionMatrix);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#setProjectionType">Qt3DRender::QCamera::setProjectionType(Qt3DRender::QCameraLens::ProjectionType)</a></p>
     */
    @QtPropertyWriter(name="projectionType")
    public final void setProjectionType(io.qt.qt3d.render.QCameraLens.@NonNull ProjectionType type){
        setProjectionType_native_Qt3DRender_QCameraLens_ProjectionType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    private native void setProjectionType_native_Qt3DRender_QCameraLens_ProjectionType(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#setRight">Qt3DRender::QCamera::setRight(float)</a></p>
     */
    @QtPropertyWriter(name="right")
    public final void setRight(float right){
        setRight_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), right);
    }
    
    private native void setRight_native_float(long __this__nativeId, float right);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#setTop">Qt3DRender::QCamera::setTop(float)</a></p>
     */
    @QtPropertyWriter(name="top")
    public final void setTop(float top){
        setTop_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), top);
    }
    
    private native void setTop_native_float(long __this__nativeId, float top);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#setUpVector">Qt3DRender::QCamera::setUpVector(QVector3D)</a></p>
     */
    @QtPropertyWriter(name="upVector")
    public final void setUpVector(io.qt.gui.@NonNull QVector3D upVector){
        setUpVector_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(upVector));
    }
    
    private native void setUpVector_native_cref_QVector3D(long __this__nativeId, long upVector);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#setViewCenter">Qt3DRender::QCamera::setViewCenter(QVector3D)</a></p>
     */
    @QtPropertyWriter(name="viewCenter")
    public final void setViewCenter(io.qt.gui.@NonNull QVector3D viewCenter){
        setViewCenter_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(viewCenter));
    }
    
    private native void setViewCenter_native_cref_QVector3D(long __this__nativeId, long viewCenter);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#tilt">Qt3DRender::QCamera::tilt(float)</a></p>
     */
    public final void tilt(float angle){
        tilt_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    private native void tilt_native_float(long __this__nativeId, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#tiltAboutViewCenter">Qt3DRender::QCamera::tiltAboutViewCenter(float)</a></p>
     */
    public final void tiltAboutViewCenter(float angle){
        tiltAboutViewCenter_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    private native void tiltAboutViewCenter_native_float(long __this__nativeId, float angle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#tiltRotation">Qt3DRender::QCamera::tiltRotation(float)const</a></p>
     */
    public final io.qt.gui.@NonNull QQuaternion tiltRotation(float angle){
        return tiltRotation_native_float_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), angle);
    }
    
    private native io.qt.gui.QQuaternion tiltRotation_native_float_constfct(long __this__nativeId, float angle);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #top()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getTop() {
        return top();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#top-prop">Qt3DRender::QCamera::top()const</a></p>
     */
    @QtPropertyReader(name="top")
    @QtUninvokable
    public final float top(){
        return top_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float top_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #transform()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QTransform getTransform() {
        return transform();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#transform">Qt3DRender::QCamera::transform()const</a></p>
     */
    @QtPropertyReader(name="transform")
    @QtPropertyConstant
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QTransform transform(){
        return transform_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QTransform transform_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #translate(io.qt.gui.QVector3D, io.qt.qt3d.render.QCamera.CameraTranslationOption)}
     *  with <code>option = io.qt.qt3d.render.QCamera.CameraTranslationOption.TranslateViewCenter</code>.</p>
     */
    public final void translate(io.qt.gui.@NonNull QVector3D vLocal) {
        translate(vLocal, io.qt.qt3d.render.QCamera.CameraTranslationOption.TranslateViewCenter);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#translate">Qt3DRender::QCamera::translate(QVector3D,Qt3DRender::QCamera::CameraTranslationOption)</a></p>
     */
    public final void translate(io.qt.gui.@NonNull QVector3D vLocal, io.qt.qt3d.render.QCamera.@NonNull CameraTranslationOption option){
        translate_native_cref_QVector3D_Qt3DRender_QCamera_CameraTranslationOption(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(vLocal), option.value());
    }
    
    private native void translate_native_cref_QVector3D_Qt3DRender_QCamera_CameraTranslationOption(long __this__nativeId, long vLocal, int option);
    
    /**
     * <p>Overloaded function for {@link #translateWorld(io.qt.gui.QVector3D, io.qt.qt3d.render.QCamera.CameraTranslationOption)}
     *  with <code>option = io.qt.qt3d.render.QCamera.CameraTranslationOption.TranslateViewCenter</code>.</p>
     */
    public final void translateWorld(io.qt.gui.@NonNull QVector3D vWorld) {
        translateWorld(vWorld, io.qt.qt3d.render.QCamera.CameraTranslationOption.TranslateViewCenter);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#translateWorld">Qt3DRender::QCamera::translateWorld(QVector3D,Qt3DRender::QCamera::CameraTranslationOption)</a></p>
     */
    public final void translateWorld(io.qt.gui.@NonNull QVector3D vWorld, io.qt.qt3d.render.QCamera.@NonNull CameraTranslationOption option){
        translateWorld_native_cref_QVector3D_Qt3DRender_QCamera_CameraTranslationOption(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(vWorld), option.value());
    }
    
    private native void translateWorld_native_cref_QVector3D_Qt3DRender_QCamera_CameraTranslationOption(long __this__nativeId, long vWorld, int option);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #upVector()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getUpVector() {
        return upVector();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#upVector-prop">Qt3DRender::QCamera::upVector()const</a></p>
     */
    @QtPropertyReader(name="upVector")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D upVector(){
        return upVector_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D upVector_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#viewAll">Qt3DRender::QCamera::viewAll()</a></p>
     */
    public final void viewAll(){
        viewAll_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void viewAll_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #viewCenter()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getViewCenter() {
        return viewCenter();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#viewCenter-prop">Qt3DRender::QCamera::viewCenter()const</a></p>
     */
    @QtPropertyReader(name="viewCenter")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D viewCenter(){
        return viewCenter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D viewCenter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#viewEntity">Qt3DRender::QCamera::viewEntity(Qt3DCore::QEntity*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final void viewEntity(io.qt.qt3d.core.@Nullable QEntity entity){
        viewEntity_native_Qt3DCore_QEntity_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(entity));
    }
    
    private native void viewEntity_native_Qt3DCore_QEntity_ptr(long __this__nativeId, long entity);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #viewMatrix()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QMatrix4x4 getViewMatrix() {
        return viewMatrix();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera-obsolete.html#viewMatrix-prop">Qt3DRender::QCamera::viewMatrix()const</a></p>
     */
    @QtPropertyReader(name="viewMatrix")
    @QtUninvokable
    public final io.qt.gui.@NonNull QMatrix4x4 viewMatrix(){
        return viewMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QMatrix4x4 viewMatrix_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#viewSphere">Qt3DRender::QCamera::viewSphere(QVector3D,float)</a></p>
     */
    public final void viewSphere(io.qt.gui.@NonNull QVector3D center, float radius){
        viewSphere_native_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(center), radius);
    }
    
    private native void viewSphere_native_cref_QVector3D_float(long __this__nativeId, long center, float radius);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #viewVector()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getViewVector() {
        return viewVector();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qcamera.html#viewVector-prop">Qt3DRender::QCamera::viewVector()const</a></p>
     */
    @QtPropertyReader(name="viewVector")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D viewVector(){
        return viewVector_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D viewVector_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QCamera(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QCamera(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QCamera instance, QDeclarativeConstructor constructor);
    
}
