package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>FrameGraph node to transfer a rectangle of pixel values from one region of a render target to another</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html">Qt3DRender::QBlitFramebuffer</a></p>
 */
public class QBlitFramebuffer extends io.qt.qt3d.render.QFrameGraphNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QBlitFramebuffer.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#InterpolationMethod-enum">Qt3DRender::QBlitFramebuffer::InterpolationMethod</a></p>
     */
    public enum InterpolationMethod implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#InterpolationMethod-enum">Qt3DRender::QBlitFramebuffer::Nearest</a></p>
         */
        Nearest(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#InterpolationMethod-enum">Qt3DRender::QBlitFramebuffer::Linear</a></p>
         */
        Linear(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private InterpolationMethod(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull InterpolationMethod resolve(int value) {
            switch (value) {
            case 0: return Nearest;
            case 1: return Linear;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#destinationAttachmentPoint-prop">Qt3DRender::QBlitFramebuffer::destinationAttachmentPointChanged()</a></p>
     */
    @QtPropertyNotify(name="destinationAttachmentPoint")
    public final @NonNull Signal0 destinationAttachmentPointChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#destination-prop">Qt3DRender::QBlitFramebuffer::destinationChanged()</a></p>
     */
    @QtPropertyNotify(name="destination")
    public final @NonNull Signal0 destinationChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#destinationRect-prop">Qt3DRender::QBlitFramebuffer::destinationRectChanged()</a></p>
     */
    @QtPropertyNotify(name="destinationRect")
    public final @NonNull Signal0 destinationRectChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#interpolationMethod-prop">Qt3DRender::QBlitFramebuffer::interpolationMethodChanged()</a></p>
     */
    @QtPropertyNotify(name="interpolationMethod")
    public final @NonNull Signal0 interpolationMethodChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#sourceAttachmentPoint-prop">Qt3DRender::QBlitFramebuffer::sourceAttachmentPointChanged()</a></p>
     */
    @QtPropertyNotify(name="sourceAttachmentPoint")
    public final @NonNull Signal0 sourceAttachmentPointChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#source-prop">Qt3DRender::QBlitFramebuffer::sourceChanged()</a></p>
     */
    @QtPropertyNotify(name="source")
    public final @NonNull Signal0 sourceChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#sourceRect-prop">Qt3DRender::QBlitFramebuffer::sourceRectChanged()</a></p>
     */
    @QtPropertyNotify(name="sourceRect")
    public final @NonNull Signal0 sourceRectChanged = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QBlitFramebuffer(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QBlitFramebuffer() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#QBlitFramebuffer">Qt3DRender::QBlitFramebuffer::QBlitFramebuffer(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QBlitFramebuffer(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QBlitFramebuffer instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #destination()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QRenderTarget getDestination() {
        return destination();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#destination">Qt3DRender::QBlitFramebuffer::destination()const</a></p>
     */
    @QtPropertyReader(name="destination")
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QRenderTarget destination(){
        return destination_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QRenderTarget destination_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #destinationAttachmentPoint()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderTargetOutput.@NonNull AttachmentPoint getDestinationAttachmentPoint() {
        return destinationAttachmentPoint();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#destinationAttachmentPoint">Qt3DRender::QBlitFramebuffer::destinationAttachmentPoint()const</a></p>
     */
    @QtPropertyReader(name="destinationAttachmentPoint")
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderTargetOutput.@NonNull AttachmentPoint destinationAttachmentPoint(){
        return io.qt.qt3d.render.QRenderTargetOutput.AttachmentPoint.resolve(destinationAttachmentPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int destinationAttachmentPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #destinationRect()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRectF getDestinationRect() {
        return destinationRect();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#destinationRect">Qt3DRender::QBlitFramebuffer::destinationRect()const</a></p>
     */
    @QtPropertyReader(name="destinationRect")
    @QtUninvokable
    public final io.qt.core.@NonNull QRectF destinationRect(){
        return destinationRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRectF destinationRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #interpolationMethod()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QBlitFramebuffer.@NonNull InterpolationMethod getInterpolationMethod() {
        return interpolationMethod();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#interpolationMethod">Qt3DRender::QBlitFramebuffer::interpolationMethod()const</a></p>
     */
    @QtPropertyReader(name="interpolationMethod")
    @QtUninvokable
    public final io.qt.qt3d.render.QBlitFramebuffer.@NonNull InterpolationMethod interpolationMethod(){
        return io.qt.qt3d.render.QBlitFramebuffer.InterpolationMethod.resolve(interpolationMethod_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int interpolationMethod_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#setDestination">Qt3DRender::QBlitFramebuffer::setDestination(Qt3DRender::QRenderTarget*)</a></p>
     */
    @QtPropertyWriter(name="destination")
    @QtUninvokable
    public final void setDestination(io.qt.qt3d.render.@Nullable QRenderTarget destination){
        setDestination_native_Qt3DRender_QRenderTarget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(destination));
    }
    
    @QtUninvokable
    private native void setDestination_native_Qt3DRender_QRenderTarget_ptr(long __this__nativeId, long destination);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#setDestinationAttachmentPoint">Qt3DRender::QBlitFramebuffer::setDestinationAttachmentPoint(Qt3DRender::QRenderTargetOutput::AttachmentPoint)</a></p>
     */
    @QtPropertyWriter(name="destinationAttachmentPoint")
    @QtUninvokable
    public final void setDestinationAttachmentPoint(io.qt.qt3d.render.QRenderTargetOutput.@NonNull AttachmentPoint destinationAttachmentPoint){
        setDestinationAttachmentPoint_native_Qt3DRender_QRenderTargetOutput_AttachmentPoint(QtJambi_LibraryUtilities.internal.nativeId(this), destinationAttachmentPoint.value());
    }
    
    @QtUninvokable
    private native void setDestinationAttachmentPoint_native_Qt3DRender_QRenderTargetOutput_AttachmentPoint(long __this__nativeId, int destinationAttachmentPoint);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#setDestinationRect">Qt3DRender::QBlitFramebuffer::setDestinationRect(QRectF)</a></p>
     */
    @QtPropertyWriter(name="destinationRect")
    @QtUninvokable
    public final void setDestinationRect(io.qt.core.@NonNull QRectF destinationRect){
        setDestinationRect_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(destinationRect));
    }
    
    @QtUninvokable
    private native void setDestinationRect_native_cref_QRectF(long __this__nativeId, long destinationRect);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#setInterpolationMethod">Qt3DRender::QBlitFramebuffer::setInterpolationMethod(Qt3DRender::QBlitFramebuffer::InterpolationMethod)</a></p>
     */
    @QtPropertyWriter(name="interpolationMethod")
    @QtUninvokable
    public final void setInterpolationMethod(io.qt.qt3d.render.QBlitFramebuffer.@NonNull InterpolationMethod interpolationMethod){
        setInterpolationMethod_native_Qt3DRender_QBlitFramebuffer_InterpolationMethod(QtJambi_LibraryUtilities.internal.nativeId(this), interpolationMethod.value());
    }
    
    @QtUninvokable
    private native void setInterpolationMethod_native_Qt3DRender_QBlitFramebuffer_InterpolationMethod(long __this__nativeId, int interpolationMethod);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#setSource">Qt3DRender::QBlitFramebuffer::setSource(Qt3DRender::QRenderTarget*)</a></p>
     */
    @QtPropertyWriter(name="source")
    @QtUninvokable
    public final void setSource(io.qt.qt3d.render.@Nullable QRenderTarget source){
        setSource_native_Qt3DRender_QRenderTarget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @QtUninvokable
    private native void setSource_native_Qt3DRender_QRenderTarget_ptr(long __this__nativeId, long source);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#setSourceAttachmentPoint">Qt3DRender::QBlitFramebuffer::setSourceAttachmentPoint(Qt3DRender::QRenderTargetOutput::AttachmentPoint)</a></p>
     */
    @QtPropertyWriter(name="sourceAttachmentPoint")
    @QtUninvokable
    public final void setSourceAttachmentPoint(io.qt.qt3d.render.QRenderTargetOutput.@NonNull AttachmentPoint sourceAttachmentPoint){
        setSourceAttachmentPoint_native_Qt3DRender_QRenderTargetOutput_AttachmentPoint(QtJambi_LibraryUtilities.internal.nativeId(this), sourceAttachmentPoint.value());
    }
    
    @QtUninvokable
    private native void setSourceAttachmentPoint_native_Qt3DRender_QRenderTargetOutput_AttachmentPoint(long __this__nativeId, int sourceAttachmentPoint);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#setSourceRect">Qt3DRender::QBlitFramebuffer::setSourceRect(QRectF)</a></p>
     */
    @QtPropertyWriter(name="sourceRect")
    @QtUninvokable
    public final void setSourceRect(io.qt.core.@NonNull QRectF sourceRect){
        setSourceRect_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceRect));
    }
    
    @QtUninvokable
    private native void setSourceRect_native_cref_QRectF(long __this__nativeId, long sourceRect);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #source()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QRenderTarget getSource() {
        return source();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#source">Qt3DRender::QBlitFramebuffer::source()const</a></p>
     */
    @QtPropertyReader(name="source")
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QRenderTarget source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QRenderTarget source_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sourceAttachmentPoint()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderTargetOutput.@NonNull AttachmentPoint getSourceAttachmentPoint() {
        return sourceAttachmentPoint();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#sourceAttachmentPoint">Qt3DRender::QBlitFramebuffer::sourceAttachmentPoint()const</a></p>
     */
    @QtPropertyReader(name="sourceAttachmentPoint")
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderTargetOutput.@NonNull AttachmentPoint sourceAttachmentPoint(){
        return io.qt.qt3d.render.QRenderTargetOutput.AttachmentPoint.resolve(sourceAttachmentPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int sourceAttachmentPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sourceRect()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRectF getSourceRect() {
        return sourceRect();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblitframebuffer.html#sourceRect">Qt3DRender::QBlitFramebuffer::sourceRect()const</a></p>
     */
    @QtPropertyReader(name="sourceRect")
    @QtUninvokable
    public final io.qt.core.@NonNull QRectF sourceRect(){
        return sourceRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRectF sourceRect_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QBlitFramebuffer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QBlitFramebuffer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QBlitFramebuffer instance, QDeclarativeConstructor constructor);
    
}
