package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>A base class to be used to provide textures</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html">Qt3DRender::QAbstractTexture</a></p>
 */
public class QAbstractTexture extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractTexture.class);
    
    /**
     * <p>Java wrapper for Qt enum Qt3DRender::QAbstractTexture::ComparisonFunction</p>
     */
    public enum ComparisonFunction implements QtEnumerator {
        /**
         * <p>Representing Qt3DRender::QAbstractTexture::CompareLessEqual</p>
         */
        CompareLessEqual(515),
        /**
         * <p>Representing Qt3DRender::QAbstractTexture::CompareGreaterEqual</p>
         */
        CompareGreaterEqual(518),
        /**
         * <p>Representing Qt3DRender::QAbstractTexture::CompareLess</p>
         */
        CompareLess(513),
        /**
         * <p>Representing Qt3DRender::QAbstractTexture::CompareGreater</p>
         */
        CompareGreater(516),
        /**
         * <p>Representing Qt3DRender::QAbstractTexture::CompareEqual</p>
         */
        CompareEqual(514),
        /**
         * <p>Representing Qt3DRender::QAbstractTexture::CommpareNotEqual</p>
         */
        CommpareNotEqual(517),
        /**
         * <p>Representing Qt3DRender::QAbstractTexture::CompareAlways</p>
         */
        CompareAlways(519),
        /**
         * <p>Representing Qt3DRender::QAbstractTexture::CompareNever</p>
         */
        CompareNever(512);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ComparisonFunction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ComparisonFunction resolve(int value) {
            switch (value) {
            case 515: return CompareLessEqual;
            case 518: return CompareGreaterEqual;
            case 513: return CompareLess;
            case 516: return CompareGreater;
            case 514: return CompareEqual;
            case 517: return CommpareNotEqual;
            case 519: return CompareAlways;
            case 512: return CompareNever;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum Qt3DRender::QAbstractTexture::ComparisonMode</p>
     */
    public enum ComparisonMode implements QtEnumerator {
        /**
         * <p>Representing Qt3DRender::QAbstractTexture::CompareRefToTexture</p>
         */
        CompareRefToTexture(34894),
        /**
         * <p>Representing Qt3DRender::QAbstractTexture::CompareNone</p>
         */
        CompareNone(0);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ComparisonMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ComparisonMode resolve(int value) {
            switch (value) {
            case 34894: return CompareRefToTexture;
            case 0: return CompareNone;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::QAbstractTexture::CubeMapFace</a></p>
     */
    public enum CubeMapFace implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::QAbstractTexture::CubeMapPositiveX</a></p>
         */
        CubeMapPositiveX(34069),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::QAbstractTexture::CubeMapNegativeX</a></p>
         */
        CubeMapNegativeX(34070),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::QAbstractTexture::CubeMapPositiveY</a></p>
         */
        CubeMapPositiveY(34071),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::QAbstractTexture::CubeMapNegativeY</a></p>
         */
        CubeMapNegativeY(34072),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::QAbstractTexture::CubeMapPositiveZ</a></p>
         */
        CubeMapPositiveZ(34073),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::QAbstractTexture::CubeMapNegativeZ</a></p>
         */
        CubeMapNegativeZ(34074),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::QAbstractTexture::AllFaces</a></p>
         */
        AllFaces(34075);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private CubeMapFace(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull CubeMapFace resolve(int value) {
            switch (value) {
            case 34069: return CubeMapPositiveX;
            case 34070: return CubeMapNegativeX;
            case 34071: return CubeMapPositiveY;
            case 34072: return CubeMapNegativeY;
            case 34073: return CubeMapPositiveZ;
            case 34074: return CubeMapNegativeZ;
            case 34075: return AllFaces;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::QAbstractTexture::Filter</a></p>
     */
    public enum Filter implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::QAbstractTexture::Nearest</a></p>
         */
        Nearest(9728),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::QAbstractTexture::Linear</a></p>
         */
        Linear(9729),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::QAbstractTexture::NearestMipMapNearest</a></p>
         */
        NearestMipMapNearest(9984),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::QAbstractTexture::NearestMipMapLinear</a></p>
         */
        NearestMipMapLinear(9986),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::QAbstractTexture::LinearMipMapNearest</a></p>
         */
        LinearMipMapNearest(9985),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::QAbstractTexture::LinearMipMapLinear</a></p>
         */
        LinearMipMapLinear(9987);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Filter(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Filter resolve(int value) {
            switch (value) {
            case 9728: return Nearest;
            case 9729: return Linear;
            case 9984: return NearestMipMapNearest;
            case 9986: return NearestMipMapLinear;
            case 9985: return LinearMipMapNearest;
            case 9987: return LinearMipMapLinear;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum Qt3DRender::QAbstractTexture::HandleType</p>
     */
    public enum HandleType implements QtEnumerator {
        /**
         * <p>Representing Qt3DRender::QAbstractTexture::NoHandle</p>
         */
        NoHandle(0),
        /**
         * <p>Representing Qt3DRender::QAbstractTexture::OpenGLTextureId</p>
         */
        OpenGLTextureId(1),
        /**
         * <p>Representing Qt3DRender::QAbstractTexture::RHITextureId</p>
         */
        RHITextureId(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private HandleType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull HandleType resolve(int value) {
            switch (value) {
            case 0: return NoHandle;
            case 1: return OpenGLTextureId;
            case 2: return RHITextureId;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Status-enum">Qt3DRender::QAbstractTexture::Status</a></p>
     */
    public enum Status implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Status-enum">Qt3DRender::QAbstractTexture::None</a></p>
         */
        None(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Status-enum">Qt3DRender::QAbstractTexture::Loading</a></p>
         */
        Loading(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Status-enum">Qt3DRender::QAbstractTexture::Ready</a></p>
         */
        Ready(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Status-enum">Qt3DRender::QAbstractTexture::Error</a></p>
         */
        Error(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Status resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return Loading;
            case 2: return Ready;
            case 3: return Error;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::Target</a></p>
     */
    public enum Target implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::TargetAutomatic</a></p>
         */
        TargetAutomatic(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::Target1D</a></p>
         */
        Target1D(3552),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::Target1DArray</a></p>
         */
        Target1DArray(35864),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::Target2D</a></p>
         */
        Target2D(3553),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::Target2DArray</a></p>
         */
        Target2DArray(35866),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::Target3D</a></p>
         */
        Target3D(32879),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::TargetCubeMap</a></p>
         */
        TargetCubeMap(34067),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::TargetCubeMapArray</a></p>
         */
        TargetCubeMapArray(36873),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::Target2DMultisample</a></p>
         */
        Target2DMultisample(37120),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::Target2DMultisampleArray</a></p>
         */
        Target2DMultisampleArray(37122),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::TargetRectangle</a></p>
         */
        TargetRectangle(34037),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::TargetBuffer</a></p>
         */
        TargetBuffer(35882);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Target(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Target resolve(int value) {
            switch (value) {
            case 0: return TargetAutomatic;
            case 3552: return Target1D;
            case 35864: return Target1DArray;
            case 3553: return Target2D;
            case 35866: return Target2DArray;
            case 32879: return Target3D;
            case 34067: return TargetCubeMap;
            case 36873: return TargetCubeMapArray;
            case 37120: return Target2DMultisample;
            case 37122: return Target2DMultisampleArray;
            case 34037: return TargetRectangle;
            case 35882: return TargetBuffer;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::TextureFormat</a></p>
     */
    public enum TextureFormat implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::NoFormat</a></p>
         */
        NoFormat(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::Automatic</a></p>
         */
        Automatic(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R8_UNorm</a></p>
         */
        R8_UNorm(33321),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG8_UNorm</a></p>
         */
        RG8_UNorm(33323),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB8_UNorm</a></p>
         */
        RGB8_UNorm(32849),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA8_UNorm</a></p>
         */
        RGBA8_UNorm(32856),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R16_UNorm</a></p>
         */
        R16_UNorm(33322),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG16_UNorm</a></p>
         */
        RG16_UNorm(33324),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB16_UNorm</a></p>
         */
        RGB16_UNorm(32852),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA16_UNorm</a></p>
         */
        RGBA16_UNorm(32859),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R8_SNorm</a></p>
         */
        R8_SNorm(36756),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG8_SNorm</a></p>
         */
        RG8_SNorm(36757),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB8_SNorm</a></p>
         */
        RGB8_SNorm(36758),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA8_SNorm</a></p>
         */
        RGBA8_SNorm(36759),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R16_SNorm</a></p>
         */
        R16_SNorm(36760),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG16_SNorm</a></p>
         */
        RG16_SNorm(36761),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB16_SNorm</a></p>
         */
        RGB16_SNorm(36762),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA16_SNorm</a></p>
         */
        RGBA16_SNorm(36763),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R8U</a></p>
         */
        R8U(33330),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG8U</a></p>
         */
        RG8U(33336),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB8U</a></p>
         */
        RGB8U(36221),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA8U</a></p>
         */
        RGBA8U(36220),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R16U</a></p>
         */
        R16U(33332),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG16U</a></p>
         */
        RG16U(33338),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB16U</a></p>
         */
        RGB16U(36215),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA16U</a></p>
         */
        RGBA16U(36214),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R32U</a></p>
         */
        R32U(33334),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG32U</a></p>
         */
        RG32U(33340),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB32U</a></p>
         */
        RGB32U(36209),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA32U</a></p>
         */
        RGBA32U(36208),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R8I</a></p>
         */
        R8I(33329),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG8I</a></p>
         */
        RG8I(33335),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB8I</a></p>
         */
        RGB8I(36239),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA8I</a></p>
         */
        RGBA8I(36238),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R16I</a></p>
         */
        R16I(33331),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG16I</a></p>
         */
        RG16I(33337),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB16I</a></p>
         */
        RGB16I(36233),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA16I</a></p>
         */
        RGBA16I(36232),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R32I</a></p>
         */
        R32I(33333),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG32I</a></p>
         */
        RG32I(33339),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB32I</a></p>
         */
        RGB32I(36227),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA32I</a></p>
         */
        RGBA32I(36226),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R16F</a></p>
         */
        R16F(33325),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG16F</a></p>
         */
        RG16F(33327),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB16F</a></p>
         */
        RGB16F(34843),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA16F</a></p>
         */
        RGBA16F(34842),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R32F</a></p>
         */
        R32F(33326),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG32F</a></p>
         */
        RG32F(33328),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB32F</a></p>
         */
        RGB32F(34837),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA32F</a></p>
         */
        RGBA32F(34836),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB9E5</a></p>
         */
        RGB9E5(35901),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG11B10F</a></p>
         */
        RG11B10F(35898),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG3B2</a></p>
         */
        RG3B2(10768),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R5G6B5</a></p>
         */
        R5G6B5(36194),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB5A1</a></p>
         */
        RGB5A1(32855),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA4</a></p>
         */
        RGBA4(32854),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB10A2</a></p>
         */
        RGB10A2(32857),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB10A2U</a></p>
         */
        RGB10A2U(36975),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::D16</a></p>
         */
        D16(33189),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::D24</a></p>
         */
        D24(33190),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::D24S8</a></p>
         */
        D24S8(35056),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::D32</a></p>
         */
        D32(33191),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::D32F</a></p>
         */
        D32F(36012),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::D32FS8X24</a></p>
         */
        D32FS8X24(36013),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB_DXT1</a></p>
         */
        RGB_DXT1(33776),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA_DXT1</a></p>
         */
        RGBA_DXT1(33777),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA_DXT3</a></p>
         */
        RGBA_DXT3(33778),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA_DXT5</a></p>
         */
        RGBA_DXT5(33779),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R_ATI1N_UNorm</a></p>
         */
        R_ATI1N_UNorm(36283),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R_ATI1N_SNorm</a></p>
         */
        R_ATI1N_SNorm(36284),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG_ATI2N_UNorm</a></p>
         */
        RG_ATI2N_UNorm(36285),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG_ATI2N_SNorm</a></p>
         */
        RG_ATI2N_SNorm(36286),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB_BP_UNSIGNED_FLOAT</a></p>
         */
        RGB_BP_UNSIGNED_FLOAT(36495),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB_BP_SIGNED_FLOAT</a></p>
         */
        RGB_BP_SIGNED_FLOAT(36494),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB_BP_UNorm</a></p>
         */
        RGB_BP_UNorm(36492),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R11_EAC_UNorm</a></p>
         */
        R11_EAC_UNorm(37488),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::R11_EAC_SNorm</a></p>
         */
        R11_EAC_SNorm(37489),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG11_EAC_UNorm</a></p>
         */
        RG11_EAC_UNorm(37490),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RG11_EAC_SNorm</a></p>
         */
        RG11_EAC_SNorm(37491),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB8_ETC2</a></p>
         */
        RGB8_ETC2(37492),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::SRGB8_ETC2</a></p>
         */
        SRGB8_ETC2(37493),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB8_PunchThrough_Alpha1_ETC2</a></p>
         */
        RGB8_PunchThrough_Alpha1_ETC2(37494),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::SRGB8_PunchThrough_Alpha1_ETC2</a></p>
         */
        SRGB8_PunchThrough_Alpha1_ETC2(37495),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBA8_ETC2_EAC</a></p>
         */
        RGBA8_ETC2_EAC(37496),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::SRGB8_Alpha8_ETC2_EAC</a></p>
         */
        SRGB8_Alpha8_ETC2_EAC(37497),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGB8_ETC1</a></p>
         */
        RGB8_ETC1(36196),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::SRGB8</a></p>
         */
        SRGB8(35905),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::SRGB8_Alpha8</a></p>
         */
        SRGB8_Alpha8(35907),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::SRGB_DXT1</a></p>
         */
        SRGB_DXT1(35916),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::SRGB_Alpha_DXT1</a></p>
         */
        SRGB_Alpha_DXT1(35917),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::SRGB_Alpha_DXT3</a></p>
         */
        SRGB_Alpha_DXT3(35918),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::SRGB_Alpha_DXT5</a></p>
         */
        SRGB_Alpha_DXT5(35919),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::SRGB_BP_UNorm</a></p>
         */
        SRGB_BP_UNorm(36493),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::DepthFormat</a></p>
         */
        DepthFormat(6402),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::AlphaFormat</a></p>
         */
        AlphaFormat(6406),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBFormat</a></p>
         */
        RGBFormat(6407),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::RGBAFormat</a></p>
         */
        RGBAFormat(6408),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::LuminanceFormat</a></p>
         */
        LuminanceFormat(6409),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::LuminanceAlphaFormat</a></p>
         */
        LuminanceAlphaFormat(6410);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TextureFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TextureFormat resolve(int value) {
            switch (value) {
            case 0: return NoFormat;
            case 1: return Automatic;
            case 33321: return R8_UNorm;
            case 33323: return RG8_UNorm;
            case 32849: return RGB8_UNorm;
            case 32856: return RGBA8_UNorm;
            case 33322: return R16_UNorm;
            case 33324: return RG16_UNorm;
            case 32852: return RGB16_UNorm;
            case 32859: return RGBA16_UNorm;
            case 36756: return R8_SNorm;
            case 36757: return RG8_SNorm;
            case 36758: return RGB8_SNorm;
            case 36759: return RGBA8_SNorm;
            case 36760: return R16_SNorm;
            case 36761: return RG16_SNorm;
            case 36762: return RGB16_SNorm;
            case 36763: return RGBA16_SNorm;
            case 33330: return R8U;
            case 33336: return RG8U;
            case 36221: return RGB8U;
            case 36220: return RGBA8U;
            case 33332: return R16U;
            case 33338: return RG16U;
            case 36215: return RGB16U;
            case 36214: return RGBA16U;
            case 33334: return R32U;
            case 33340: return RG32U;
            case 36209: return RGB32U;
            case 36208: return RGBA32U;
            case 33329: return R8I;
            case 33335: return RG8I;
            case 36239: return RGB8I;
            case 36238: return RGBA8I;
            case 33331: return R16I;
            case 33337: return RG16I;
            case 36233: return RGB16I;
            case 36232: return RGBA16I;
            case 33333: return R32I;
            case 33339: return RG32I;
            case 36227: return RGB32I;
            case 36226: return RGBA32I;
            case 33325: return R16F;
            case 33327: return RG16F;
            case 34843: return RGB16F;
            case 34842: return RGBA16F;
            case 33326: return R32F;
            case 33328: return RG32F;
            case 34837: return RGB32F;
            case 34836: return RGBA32F;
            case 35901: return RGB9E5;
            case 35898: return RG11B10F;
            case 10768: return RG3B2;
            case 36194: return R5G6B5;
            case 32855: return RGB5A1;
            case 32854: return RGBA4;
            case 32857: return RGB10A2;
            case 36975: return RGB10A2U;
            case 33189: return D16;
            case 33190: return D24;
            case 35056: return D24S8;
            case 33191: return D32;
            case 36012: return D32F;
            case 36013: return D32FS8X24;
            case 33776: return RGB_DXT1;
            case 33777: return RGBA_DXT1;
            case 33778: return RGBA_DXT3;
            case 33779: return RGBA_DXT5;
            case 36283: return R_ATI1N_UNorm;
            case 36284: return R_ATI1N_SNorm;
            case 36285: return RG_ATI2N_UNorm;
            case 36286: return RG_ATI2N_SNorm;
            case 36495: return RGB_BP_UNSIGNED_FLOAT;
            case 36494: return RGB_BP_SIGNED_FLOAT;
            case 36492: return RGB_BP_UNorm;
            case 37488: return R11_EAC_UNorm;
            case 37489: return R11_EAC_SNorm;
            case 37490: return RG11_EAC_UNorm;
            case 37491: return RG11_EAC_SNorm;
            case 37492: return RGB8_ETC2;
            case 37493: return SRGB8_ETC2;
            case 37494: return RGB8_PunchThrough_Alpha1_ETC2;
            case 37495: return SRGB8_PunchThrough_Alpha1_ETC2;
            case 37496: return RGBA8_ETC2_EAC;
            case 37497: return SRGB8_Alpha8_ETC2_EAC;
            case 36196: return RGB8_ETC1;
            case 35905: return SRGB8;
            case 35907: return SRGB8_Alpha8;
            case 35916: return SRGB_DXT1;
            case 35917: return SRGB_Alpha_DXT1;
            case 35918: return SRGB_Alpha_DXT3;
            case 35919: return SRGB_Alpha_DXT5;
            case 36493: return SRGB_BP_UNorm;
            case 6402: return DepthFormat;
            case 6406: return AlphaFormat;
            case 6407: return RGBFormat;
            case 6408: return RGBAFormat;
            case 6409: return LuminanceFormat;
            case 6410: return LuminanceAlphaFormat;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#comparisonFunction-prop">Qt3DRender::QAbstractTexture::comparisonFunctionChanged(Qt3DRender::QAbstractTexture::ComparisonFunction)</a></p>
     */
    @QtPropertyNotify(name="comparisonFunction")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonFunction> comparisonFunctionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#comparisonMode-prop">Qt3DRender::QAbstractTexture::comparisonModeChanged(Qt3DRender::QAbstractTexture::ComparisonMode)</a></p>
     */
    @QtPropertyNotify(name="comparisonMode")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonMode> comparisonModeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#depth-prop">Qt3DRender::QAbstractTexture::depthChanged(int)</a></p>
     */
    @QtPropertyNotify(name="depth")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> depthChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#format-prop">Qt3DRender::QAbstractTexture::formatChanged(Qt3DRender::QAbstractTexture::TextureFormat)</a></p>
     */
    @QtPropertyNotify(name="format")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull TextureFormat> formatChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#generateMipMaps-prop">Qt3DRender::QAbstractTexture::generateMipMapsChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="generateMipMaps")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> generateMipMapsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#handle-prop">Qt3DRender::QAbstractTexture::handleChanged(QVariant)</a></p>
     */
    @QtPropertyNotify(name="handle")
    public final @NonNull Signal1<java.lang.Object> handleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#handleType-prop">Qt3DRender::QAbstractTexture::handleTypeChanged(Qt3DRender::QAbstractTexture::HandleType)</a></p>
     */
    @QtPropertyNotify(name="handleType")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull HandleType> handleTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#height-prop">Qt3DRender::QAbstractTexture::heightChanged(int)</a></p>
     */
    @QtPropertyNotify(name="height")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> heightChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#layers-prop">Qt3DRender::QAbstractTexture::layersChanged(int)</a></p>
     */
    @QtPropertyNotify(name="layers")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> layersChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#magnificationFilter-prop">Qt3DRender::QAbstractTexture::magnificationFilterChanged(Qt3DRender::QAbstractTexture::Filter)</a></p>
     */
    @QtPropertyNotify(name="magnificationFilter")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull Filter> magnificationFilterChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#maximumAnisotropy-prop">Qt3DRender::QAbstractTexture::maximumAnisotropyChanged(float)</a></p>
     */
    @QtPropertyNotify(name="maximumAnisotropy")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> maximumAnisotropyChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#minificationFilter-prop">Qt3DRender::QAbstractTexture::minificationFilterChanged(Qt3DRender::QAbstractTexture::Filter)</a></p>
     */
    @QtPropertyNotify(name="minificationFilter")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull Filter> minificationFilterChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#mipLevels-prop">Qt3DRender::QAbstractTexture::mipLevelsChanged(int)</a></p>
     */
    @QtPropertyNotify(name="mipLevels")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> mipLevelsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#samples-prop">Qt3DRender::QAbstractTexture::samplesChanged(int)</a></p>
     */
    @QtPropertyNotify(name="samples")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> samplesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#status-prop">Qt3DRender::QAbstractTexture::statusChanged(Qt3DRender::QAbstractTexture::Status)</a></p>
     */
    @QtPropertyNotify(name="status")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull Status> statusChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#width-prop">Qt3DRender::QAbstractTexture::widthChanged(int)</a></p>
     */
    @QtPropertyNotify(name="width")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> widthChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractTexture(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    protected QAbstractTexture() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#QAbstractTexture">Qt3DRender::QAbstractTexture::QAbstractTexture(Qt3DCore::QNode*)</a></p>
     */
    protected QAbstractTexture(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractTexture instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractTexture(io.qt.qt3d.render.QAbstractTexture.Target, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    protected QAbstractTexture(io.qt.qt3d.render.QAbstractTexture.@NonNull Target target) {
        this(target, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#QAbstractTexture-1">Qt3DRender::QAbstractTexture::QAbstractTexture(Qt3DRender::QAbstractTexture::Target,Qt3DCore::QNode*)</a></p>
     */
    protected QAbstractTexture(io.qt.qt3d.render.QAbstractTexture.@NonNull Target target, io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, target, parent);
    }
    
    private native static void initialize_native(QAbstractTexture instance, io.qt.qt3d.render.QAbstractTexture.Target target, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#addTextureImage">Qt3DRender::QAbstractTexture::addTextureImage(Qt3DRender::QAbstractTextureImage*)</a></p>
     */
    @QtUninvokable
    public final void addTextureImage(io.qt.qt3d.render.@Nullable QAbstractTextureImage textureImage){
        addTextureImage_native_Qt3DRender_QAbstractTextureImage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(textureImage));
    }
    
    @QtUninvokable
    private native void addTextureImage_native_Qt3DRender_QAbstractTextureImage_ptr(long __this__nativeId, long textureImage);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #comparisonFunction()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonFunction getComparisonFunction() {
        return comparisonFunction();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#comparisonFunction">Qt3DRender::QAbstractTexture::comparisonFunction()const</a></p>
     */
    @QtPropertyReader(name="comparisonFunction")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonFunction comparisonFunction(){
        return io.qt.qt3d.render.QAbstractTexture.ComparisonFunction.resolve(comparisonFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int comparisonFunction_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #comparisonMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonMode getComparisonMode() {
        return comparisonMode();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#comparisonMode">Qt3DRender::QAbstractTexture::comparisonMode()const</a></p>
     */
    @QtPropertyReader(name="comparisonMode")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonMode comparisonMode(){
        return io.qt.qt3d.render.QAbstractTexture.ComparisonMode.resolve(comparisonMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int comparisonMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #depth()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getDepth() {
        return depth();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#depth">Qt3DRender::QAbstractTexture::depth()const</a></p>
     */
    @QtPropertyReader(name="depth")
    @QtUninvokable
    public final int depth(){
        return depth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int depth_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #format()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull TextureFormat getFormat() {
        return format();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#format">Qt3DRender::QAbstractTexture::format()const</a></p>
     */
    @QtPropertyReader(name="format")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull TextureFormat format(){
        return io.qt.qt3d.render.QAbstractTexture.TextureFormat.resolve(format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int format_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #generateMipMaps()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getGenerateMipMaps() {
        return generateMipMaps();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#generateMipMaps-prop">Qt3DRender::QAbstractTexture::generateMipMaps()const</a></p>
     */
    @QtPropertyReader(name="generateMipMaps")
    @QtUninvokable
    public final boolean generateMipMaps(){
        return generateMipMaps_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean generateMipMaps_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #handle()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.Object getHandle() {
        return handle();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#handle">Qt3DRender::QAbstractTexture::handle()const</a></p>
     */
    @QtPropertyReader(name="handle")
    @QtUninvokable
    public final java.lang.Object handle(){
        return handle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Object handle_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #handleType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull HandleType getHandleType() {
        return handleType();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#handleType">Qt3DRender::QAbstractTexture::handleType()const</a></p>
     */
    @QtPropertyReader(name="handleType")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull HandleType handleType(){
        return io.qt.qt3d.render.QAbstractTexture.HandleType.resolve(handleType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int handleType_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #height()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getHeight() {
        return height();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#height">Qt3DRender::QAbstractTexture::height()const</a></p>
     */
    @QtPropertyReader(name="height")
    @QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #layers()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getLayers() {
        return layers();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#layers">Qt3DRender::QAbstractTexture::layers()const</a></p>
     */
    @QtPropertyReader(name="layers")
    @QtUninvokable
    public final int layers(){
        return layers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int layers_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #magnificationFilter()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Filter getMagnificationFilter() {
        return magnificationFilter();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#magnificationFilter-prop">Qt3DRender::QAbstractTexture::magnificationFilter()const</a></p>
     */
    @QtPropertyReader(name="magnificationFilter")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Filter magnificationFilter(){
        return io.qt.qt3d.render.QAbstractTexture.Filter.resolve(magnificationFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int magnificationFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maximumAnisotropy()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMaximumAnisotropy() {
        return maximumAnisotropy();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#maximumAnisotropy">Qt3DRender::QAbstractTexture::maximumAnisotropy()const</a></p>
     */
    @QtPropertyReader(name="maximumAnisotropy")
    @QtUninvokable
    public final float maximumAnisotropy(){
        return maximumAnisotropy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maximumAnisotropy_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minificationFilter()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Filter getMinificationFilter() {
        return minificationFilter();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#minificationFilter-prop">Qt3DRender::QAbstractTexture::minificationFilter()const</a></p>
     */
    @QtPropertyReader(name="minificationFilter")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Filter minificationFilter(){
        return io.qt.qt3d.render.QAbstractTexture.Filter.resolve(minificationFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int minificationFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #mipLevels()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMipLevels() {
        return mipLevels();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#mipLevels-prop">Qt3DRender::QAbstractTexture::mipLevels()const</a></p>
     */
    @QtPropertyReader(name="mipLevels")
    @QtUninvokable
    public final int mipLevels(){
        return mipLevels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int mipLevels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#removeTextureImage">Qt3DRender::QAbstractTexture::removeTextureImage(Qt3DRender::QAbstractTextureImage*)</a></p>
     */
    @QtUninvokable
    public final void removeTextureImage(io.qt.qt3d.render.@Nullable QAbstractTextureImage textureImage){
        removeTextureImage_native_Qt3DRender_QAbstractTextureImage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(textureImage));
    }
    
    @QtUninvokable
    private native void removeTextureImage_native_Qt3DRender_QAbstractTextureImage_ptr(long __this__nativeId, long textureImage);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #samples()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getSamples() {
        return samples();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#samples">Qt3DRender::QAbstractTexture::samples()const</a></p>
     */
    @QtPropertyReader(name="samples")
    @QtUninvokable
    public final int samples(){
        return samples_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int samples_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setComparisonFunction">Qt3DRender::QAbstractTexture::setComparisonFunction(Qt3DRender::QAbstractTexture::ComparisonFunction)</a></p>
     */
    @QtPropertyWriter(name="comparisonFunction")
    public final void setComparisonFunction(io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonFunction function){
        setComparisonFunction_native_Qt3DRender_QAbstractTexture_ComparisonFunction(QtJambi_LibraryUtilities.internal.nativeId(this), function.value());
    }
    
    private native void setComparisonFunction_native_Qt3DRender_QAbstractTexture_ComparisonFunction(long __this__nativeId, int function);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setComparisonMode">Qt3DRender::QAbstractTexture::setComparisonMode(Qt3DRender::QAbstractTexture::ComparisonMode)</a></p>
     */
    @QtPropertyWriter(name="comparisonMode")
    public final void setComparisonMode(io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonMode mode){
        setComparisonMode_native_Qt3DRender_QAbstractTexture_ComparisonMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setComparisonMode_native_Qt3DRender_QAbstractTexture_ComparisonMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setDepth">Qt3DRender::QAbstractTexture::setDepth(int)</a></p>
     */
    @QtPropertyWriter(name="depth")
    public final void setDepth(int depth){
        setDepth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    private native void setDepth_native_int(long __this__nativeId, int depth);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setFormat">Qt3DRender::QAbstractTexture::setFormat(Qt3DRender::QAbstractTexture::TextureFormat)</a></p>
     */
    @QtPropertyWriter(name="format")
    public final void setFormat(io.qt.qt3d.render.QAbstractTexture.@NonNull TextureFormat format){
        setFormat_native_Qt3DRender_QAbstractTexture_TextureFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    private native void setFormat_native_Qt3DRender_QAbstractTexture_TextureFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setGenerateMipMaps">Qt3DRender::QAbstractTexture::setGenerateMipMaps(bool)</a></p>
     */
    @QtPropertyWriter(name="generateMipMaps")
    public final void setGenerateMipMaps(boolean gen){
        setGenerateMipMaps_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), gen);
    }
    
    private native void setGenerateMipMaps_native_bool(long __this__nativeId, boolean gen);
    
    @QtUninvokable
    protected final void setHandle(java.lang.Object handle){
        setHandle_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), handle);
    }
    
    @QtUninvokable
    private native void setHandle_native_cref_QVariant(long __this__nativeId, java.lang.Object handle);
    
    @QtUninvokable
    protected final void setHandleType(io.qt.qt3d.render.QAbstractTexture.@NonNull HandleType type){
        setHandleType_native_Qt3DRender_QAbstractTexture_HandleType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native void setHandleType_native_Qt3DRender_QAbstractTexture_HandleType(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setHeight">Qt3DRender::QAbstractTexture::setHeight(int)</a></p>
     */
    @QtPropertyWriter(name="height")
    public final void setHeight(int height){
        setHeight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), height);
    }
    
    private native void setHeight_native_int(long __this__nativeId, int height);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setLayers">Qt3DRender::QAbstractTexture::setLayers(int)</a></p>
     */
    @QtPropertyWriter(name="layers")
    public final void setLayers(int layers){
        setLayers_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layers);
    }
    
    private native void setLayers_native_int(long __this__nativeId, int layers);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setMagnificationFilter">Qt3DRender::QAbstractTexture::setMagnificationFilter(Qt3DRender::QAbstractTexture::Filter)</a></p>
     */
    @QtPropertyWriter(name="magnificationFilter")
    public final void setMagnificationFilter(io.qt.qt3d.render.QAbstractTexture.@NonNull Filter f){
        setMagnificationFilter_native_Qt3DRender_QAbstractTexture_Filter(QtJambi_LibraryUtilities.internal.nativeId(this), f.value());
    }
    
    private native void setMagnificationFilter_native_Qt3DRender_QAbstractTexture_Filter(long __this__nativeId, int f);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setMaximumAnisotropy">Qt3DRender::QAbstractTexture::setMaximumAnisotropy(float)</a></p>
     */
    @QtPropertyWriter(name="maximumAnisotropy")
    public final void setMaximumAnisotropy(float anisotropy){
        setMaximumAnisotropy_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), anisotropy);
    }
    
    private native void setMaximumAnisotropy_native_float(long __this__nativeId, float anisotropy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setMinificationFilter">Qt3DRender::QAbstractTexture::setMinificationFilter(Qt3DRender::QAbstractTexture::Filter)</a></p>
     */
    @QtPropertyWriter(name="minificationFilter")
    public final void setMinificationFilter(io.qt.qt3d.render.QAbstractTexture.@NonNull Filter f){
        setMinificationFilter_native_Qt3DRender_QAbstractTexture_Filter(QtJambi_LibraryUtilities.internal.nativeId(this), f.value());
    }
    
    private native void setMinificationFilter_native_Qt3DRender_QAbstractTexture_Filter(long __this__nativeId, int f);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#mipLevels-prop">Qt3DRender::QAbstractTexture::setMipLevels(int)</a></p>
     */
    @QtPropertyWriter(name="mipLevels")
    public final void setMipLevels(int mipLevels){
        setMipLevels_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevels);
    }
    
    private native void setMipLevels_native_int(long __this__nativeId, int mipLevels);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setSamples">Qt3DRender::QAbstractTexture::setSamples(int)</a></p>
     */
    @QtPropertyWriter(name="samples")
    public final void setSamples(int samples){
        setSamples_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), samples);
    }
    
    private native void setSamples_native_int(long __this__nativeId, int samples);
    
    /**
     * <p>Overloaded function for {@link #setSize(int, int, int)}
     *  with <code>depth = 1</code>.</p>
     */
    @QtUninvokable
    public final void setSize(int width, int height) {
        setSize(width, height, (int)1);
    }
    
    /**
     * <p>Overloaded function for {@link #setSize(int, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>height = 1</code></li>
     * <li><code>depth = 1</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void setSize(int width) {
        setSize(width, (int)1, (int)1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setSize">Qt3DRender::QAbstractTexture::setSize(int,int,int)</a></p>
     */
    @QtUninvokable
    public final void setSize(int width, int height, int depth){
        setSize_native_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, depth);
    }
    
    @QtUninvokable
    private native void setSize_native_int_int_int(long __this__nativeId, int width, int height, int depth);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setStatus">Qt3DRender::QAbstractTexture::setStatus(Qt3DRender::QAbstractTexture::Status)</a></p>
     */
    @QtUninvokable
    protected final void setStatus(io.qt.qt3d.render.QAbstractTexture.@NonNull Status status){
        setStatus_native_Qt3DRender_QAbstractTexture_Status(QtJambi_LibraryUtilities.internal.nativeId(this), status.value());
    }
    
    @QtUninvokable
    private native void setStatus_native_Qt3DRender_QAbstractTexture_Status(long __this__nativeId, int status);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setWidth">Qt3DRender::QAbstractTexture::setWidth(int)</a></p>
     */
    @QtPropertyWriter(name="width")
    public final void setWidth(int width){
        setWidth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    private native void setWidth_native_int(long __this__nativeId, int width);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setWrapMode">Qt3DRender::QAbstractTexture::setWrapMode(Qt3DRender::QTextureWrapMode)</a></p>
     */
    @QtUninvokable
    public final void setWrapMode(io.qt.qt3d.render.@StrictNonNull QTextureWrapMode wrapMode){
        java.util.Objects.requireNonNull(wrapMode, "Argument 'wrapMode': null not expected.");
        setWrapMode_native_cref_Qt3DRender_QTextureWrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(wrapMode));
    }
    
    @QtUninvokable
    private native void setWrapMode_native_cref_Qt3DRender_QTextureWrapMode(long __this__nativeId, long wrapMode);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #status()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Status getStatus() {
        return status();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#status">Qt3DRender::QAbstractTexture::status()const</a></p>
     */
    @QtPropertyReader(name="status")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Status status(){
        return io.qt.qt3d.render.QAbstractTexture.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #target()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Target getTarget() {
        return target();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#target">Qt3DRender::QAbstractTexture::target()const</a></p>
     */
    @QtPropertyReader(name="target")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Target target(){
        return io.qt.qt3d.render.QAbstractTexture.Target.resolve(target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int target_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#textureImages">Qt3DRender::QAbstractTexture::textureImages()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@Nullable QAbstractTextureImage> textureImages(){
        return textureImages_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QAbstractTextureImage> textureImages_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#updateData">Qt3DRender::QAbstractTexture::updateData(Qt3DRender::QTextureDataUpdate)</a></p>
     */
    public final void updateData(io.qt.qt3d.render.@NonNull QTextureDataUpdate update){
        updateData_native_cref_Qt3DRender_QTextureDataUpdate(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(update));
    }
    
    private native void updateData_native_cref_Qt3DRender_QTextureDataUpdate(long __this__nativeId, long update);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #width()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getWidth() {
        return width();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#width">Qt3DRender::QAbstractTexture::width()const</a></p>
     */
    @QtPropertyReader(name="width")
    @QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #wrapMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QTextureWrapMode getWrapMode() {
        return wrapMode();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#wrapMode-prop">Qt3DRender::QAbstractTexture::wrapMode()</a></p>
     */
    @QtPropertyReader(name="wrapMode")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QTextureWrapMode wrapMode(){
        return wrapMode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QTextureWrapMode wrapMode_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAbstractTexture(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAbstractTexture(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractTexture instance, QDeclarativeConstructor constructor);
    
}
