package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Contains classes that enable 2D and 3D rendering</p>
 * <p>Java wrapper for Qt's namespace <a href="https://doc.qt.io/qt/qt3drender.html">Qt3DRender</a></p>
 */
public final class Qt3DRender
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private Qt3DRender() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace Qt3DRender."); }
    
    /**
     * <p>Java wrapper for Qt enum Qt3DRender::API</p>
     */
    public enum API implements QtEnumerator {
        /**
         * <p>Representing Qt3DRender::API::OpenGL</p>
         */
        OpenGL(0),
        /**
         * <p>Representing Qt3DRender::API::Vulkan</p>
         */
        Vulkan(1),
        /**
         * <p>Representing Qt3DRender::API::DirectX</p>
         */
        DirectX(2),
        /**
         * <p>Representing Qt3DRender::API::Metal</p>
         */
        Metal(3),
        /**
         * <p>Representing Qt3DRender::API::RHI</p>
         */
        RHI(4),
        /**
         * <p>Representing Qt3DRender::API::Null</p>
         */
        Null(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private API(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull API resolve(int value) {
            switch (value) {
            case 0: return OpenGL;
            case 1: return Vulkan;
            case 2: return DirectX;
            case 3: return Metal;
            case 4: return RHI;
            case 5: return Null;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    
}
