package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Sets the actions to be taken when stencil and depth tests fail</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html">Qt3DRender::QStencilOperationArguments</a></p>
 */
public final class QStencilOperationArguments extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QStencilOperationArguments.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#FaceMode-enum">Qt3DRender::QStencilOperationArguments::FaceMode</a></p>
     */
    public enum FaceMode implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#FaceMode-enum">Qt3DRender::QStencilOperationArguments::Front</a></p>
         */
        Front(1028),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#FaceMode-enum">Qt3DRender::QStencilOperationArguments::Back</a></p>
         */
        Back(1029),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#FaceMode-enum">Qt3DRender::QStencilOperationArguments::FrontAndBack</a></p>
         */
        FrontAndBack(1032);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FaceMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FaceMode resolve(int value) {
            switch (value) {
            case 1028: return Front;
            case 1029: return Back;
            case 1032: return FrontAndBack;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#Operation-enum">Qt3DRender::QStencilOperationArguments::Operation</a></p>
     */
    public enum Operation implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#Operation-enum">Qt3DRender::QStencilOperationArguments::Zero</a></p>
         */
        Zero(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#Operation-enum">Qt3DRender::QStencilOperationArguments::Keep</a></p>
         */
        Keep(7680),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#Operation-enum">Qt3DRender::QStencilOperationArguments::Replace</a></p>
         */
        Replace(7681),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#Operation-enum">Qt3DRender::QStencilOperationArguments::Increment</a></p>
         */
        Increment(7682),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#Operation-enum">Qt3DRender::QStencilOperationArguments::Decrement</a></p>
         */
        Decrement(7683),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#Operation-enum">Qt3DRender::QStencilOperationArguments::IncrementWrap</a></p>
         */
        IncrementWrap(34055),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#Operation-enum">Qt3DRender::QStencilOperationArguments::DecrementWrap</a></p>
         */
        DecrementWrap(34056),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#Operation-enum">Qt3DRender::QStencilOperationArguments::Invert</a></p>
         */
        Invert(5386);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Operation(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Operation resolve(int value) {
            switch (value) {
            case 0: return Zero;
            case 7680: return Keep;
            case 7681: return Replace;
            case 7682: return Increment;
            case 7683: return Decrement;
            case 34055: return IncrementWrap;
            case 34056: return DecrementWrap;
            case 5386: return Invert;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#allTestsPassOperation-prop">Qt3DRender::QStencilOperationArguments::allTestsPassOperationChanged(Qt3DRender::QStencilOperationArguments::Operation)</a></p>
     */
    @QtPropertyNotify(name="allTestsPassOperation")
    public final @NonNull Signal1<io.qt.qt3d.render.QStencilOperationArguments.@NonNull Operation> allTestsPassOperationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#depthTestFailureOperation-prop">Qt3DRender::QStencilOperationArguments::depthTestFailureOperationChanged(Qt3DRender::QStencilOperationArguments::Operation)</a></p>
     */
    @QtPropertyNotify(name="depthTestFailureOperation")
    public final @NonNull Signal1<io.qt.qt3d.render.QStencilOperationArguments.@NonNull Operation> depthTestFailureOperationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#faceMode-prop">Qt3DRender::QStencilOperationArguments::faceModeChanged(Qt3DRender::QStencilOperationArguments::FaceMode)</a></p>
     */
    @QtPropertyNotify(name="faceMode")
    public final @NonNull Signal1<io.qt.qt3d.render.QStencilOperationArguments.@NonNull FaceMode> faceModeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#stencilTestFailureOperation-prop">Qt3DRender::QStencilOperationArguments::stencilTestFailureOperationChanged(Qt3DRender::QStencilOperationArguments::Operation)</a></p>
     */
    @QtPropertyNotify(name="stencilTestFailureOperation")
    public final @NonNull Signal1<io.qt.qt3d.render.QStencilOperationArguments.@NonNull Operation> stencilTestFailureOperationChanged = new Signal1<>();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #allTestsPassOperation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QStencilOperationArguments.@NonNull Operation getAllTestsPassOperation() {
        return allTestsPassOperation();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#allTestsPassOperation-prop">Qt3DRender::QStencilOperationArguments::allTestsPassOperation()const</a></p>
     */
    @QtPropertyReader(name="allTestsPassOperation")
    @QtUninvokable
    public final io.qt.qt3d.render.QStencilOperationArguments.@NonNull Operation allTestsPassOperation(){
        return io.qt.qt3d.render.QStencilOperationArguments.Operation.resolve(allTestsPassOperation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int allTestsPassOperation_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #depthTestFailureOperation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QStencilOperationArguments.@NonNull Operation getDepthTestFailureOperation() {
        return depthTestFailureOperation();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#depthTestFailureOperation-prop">Qt3DRender::QStencilOperationArguments::depthTestFailureOperation()const</a></p>
     */
    @QtPropertyReader(name="depthTestFailureOperation")
    @QtUninvokable
    public final io.qt.qt3d.render.QStencilOperationArguments.@NonNull Operation depthTestFailureOperation(){
        return io.qt.qt3d.render.QStencilOperationArguments.Operation.resolve(depthTestFailureOperation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int depthTestFailureOperation_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #faceMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QStencilOperationArguments.@NonNull FaceMode getFaceMode() {
        return faceMode();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#faceMode-prop">Qt3DRender::QStencilOperationArguments::faceMode()const</a></p>
     */
    @QtPropertyReader(name="faceMode")
    @QtUninvokable
    public final io.qt.qt3d.render.QStencilOperationArguments.@NonNull FaceMode faceMode(){
        return io.qt.qt3d.render.QStencilOperationArguments.FaceMode.resolve(faceMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int faceMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#allTestsPassOperation-prop">Qt3DRender::QStencilOperationArguments::setAllTestsPassOperation(Qt3DRender::QStencilOperationArguments::Operation)</a></p>
     */
    @QtPropertyWriter(name="allTestsPassOperation")
    public final void setAllTestsPassOperation(io.qt.qt3d.render.QStencilOperationArguments.@NonNull Operation operation){
        setAllTestsPassOperation_native_Qt3DRender_QStencilOperationArguments_Operation(QtJambi_LibraryUtilities.internal.nativeId(this), operation.value());
    }
    
    private native void setAllTestsPassOperation_native_Qt3DRender_QStencilOperationArguments_Operation(long __this__nativeId, int operation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#depthTestFailureOperation-prop">Qt3DRender::QStencilOperationArguments::setDepthTestFailureOperation(Qt3DRender::QStencilOperationArguments::Operation)</a></p>
     */
    @QtPropertyWriter(name="depthTestFailureOperation")
    public final void setDepthTestFailureOperation(io.qt.qt3d.render.QStencilOperationArguments.@NonNull Operation operation){
        setDepthTestFailureOperation_native_Qt3DRender_QStencilOperationArguments_Operation(QtJambi_LibraryUtilities.internal.nativeId(this), operation.value());
    }
    
    private native void setDepthTestFailureOperation_native_Qt3DRender_QStencilOperationArguments_Operation(long __this__nativeId, int operation);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#stencilTestFailureOperation-prop">Qt3DRender::QStencilOperationArguments::setStencilTestFailureOperation(Qt3DRender::QStencilOperationArguments::Operation)</a></p>
     */
    @QtPropertyWriter(name="stencilTestFailureOperation")
    public final void setStencilTestFailureOperation(io.qt.qt3d.render.QStencilOperationArguments.@NonNull Operation operation){
        setStencilTestFailureOperation_native_Qt3DRender_QStencilOperationArguments_Operation(QtJambi_LibraryUtilities.internal.nativeId(this), operation.value());
    }
    
    private native void setStencilTestFailureOperation_native_Qt3DRender_QStencilOperationArguments_Operation(long __this__nativeId, int operation);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #stencilTestFailureOperation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QStencilOperationArguments.@NonNull Operation getStencilTestFailureOperation() {
        return stencilTestFailureOperation();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qstenciloperationarguments.html#stencilTestFailureOperation-prop">Qt3DRender::QStencilOperationArguments::stencilTestFailureOperation()const</a></p>
     */
    @QtPropertyReader(name="stencilTestFailureOperation")
    @QtUninvokable
    public final io.qt.qt3d.render.QStencilOperationArguments.@NonNull Operation stencilTestFailureOperation(){
        return io.qt.qt3d.render.QStencilOperationArguments.Operation.resolve(stencilTestFailureOperation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int stencilTestFailureOperation_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QStencilOperationArguments(QPrivateConstructor p) { super(p); } 
    
}
