package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Provides storage for the sort types to be used</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html">Qt3DRender::QSortPolicy</a></p>
 */
public class QSortPolicy extends io.qt.qt3d.render.QFrameGraphNode
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSortPolicy.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html#SortType-enum">Qt3DRender::QSortPolicy::SortType</a></p>
     */
    public enum SortType implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html#SortType-enum">Qt3DRender::QSortPolicy::StateChangeCost</a></p>
         */
        StateChangeCost(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html#SortType-enum">Qt3DRender::QSortPolicy::BackToFront</a></p>
         */
        BackToFront(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html#SortType-enum">Qt3DRender::QSortPolicy::Material</a></p>
         */
        Material(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html#SortType-enum">Qt3DRender::QSortPolicy::FrontToBack</a></p>
         */
        FrontToBack(8),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html#SortType-enum">Qt3DRender::QSortPolicy::Texture</a></p>
         */
        Texture(16),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html#SortType-enum">Qt3DRender::QSortPolicy::Uniform</a></p>
         */
        Uniform(32);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SortType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull SortType resolve(int value) {
            switch (value) {
            case 1: return StateChangeCost;
            case 2: return BackToFront;
            case 4: return Material;
            case 8: return FrontToBack;
            case 16: return Texture;
            case 32: return Uniform;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html#sortTypes-prop">Qt3DRender::QSortPolicy::sortTypesChanged(QList&lt;Qt3DRender::QSortPolicy::SortType&gt;)</a></p>
     */
    @QtPropertyNotify(name="sortTypes")
    public final @NonNull Signal1<java.util.@NonNull List<io.qt.qt3d.render.QSortPolicy.@NonNull SortType>> sortTypesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html#sortTypes-prop">Qt3DRender::QSortPolicy::sortTypesChanged(QList&lt;int&gt;)</a></p>
     */
    @QtPropertyNotify(name="sortTypes")
    public final @NonNull Signal1<java.util.@NonNull List<java.lang.@QtPrimitiveType@NonNull Integer>> sortTypesIntChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QSortPolicy(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QSortPolicy() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html#QSortPolicy">Qt3DRender::QSortPolicy::QSortPolicy(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QSortPolicy(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSortPolicy instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html#sortTypes-prop">Qt3DRender::QSortPolicy::setSortTypes(QList&lt;Qt3DRender::QSortPolicy::SortType&gt;)</a></p>
     */
    @QtPropertyWriter(name="sortTypes")
    public final void setSortTypes(java.util.@NonNull Collection<? extends io.qt.qt3d.render.QSortPolicy.@NonNull SortType> sortTypes){
        setSortTypes_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), sortTypes);
    }
    
    private native void setSortTypes_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.qt3d.render.QSortPolicy.SortType> sortTypes);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html#sortTypes-prop">Qt3DRender::QSortPolicy::setSortTypes(QList&lt;int&gt;)</a></p>
     */
    @QtPropertyWriter(name="sortTypes")
    public final void setSortTypesInt(java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Integer> sortTypesInt){
        setSortTypesInt_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), sortTypesInt);
    }
    
    private native void setSortTypesInt_native_cref_QList(long __this__nativeId, java.util.Collection<java.lang.@QtPrimitiveType Integer> sortTypesInt);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html#sortTypes">Qt3DRender::QSortPolicy::sortTypes()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.QSortPolicy.@NonNull SortType> sortTypes(){
        return sortTypes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QSortPolicy.SortType> sortTypes_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sortTypesInt()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> getSortTypes() {
        return sortTypesInt();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsortpolicy.html#sortTypes-prop">Qt3DRender::QSortPolicy::sortTypesInt()const</a></p>
     */
    @QtPropertyReader(name="sortTypes")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> sortTypesInt(){
        return sortTypesInt_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Integer> sortTypesInt_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QSortPolicy(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSortPolicy(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSortPolicy instance, QDeclarativeConstructor constructor);
    
}
