package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Generates a Shader Program content from loaded graphs</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html">Qt3DRender::QShaderProgramBuilder</a></p>
 */
public class QShaderProgramBuilder extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QShaderProgramBuilder.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#computeShaderCode-prop">Qt3DRender::QShaderProgramBuilder::computeShaderCodeChanged(QByteArray)</a></p>
     */
    @QtPropertyNotify(name="computeShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> computeShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#computeShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::computeShaderGraphChanged(QUrl)</a></p>
     */
    @QtPropertyNotify(name="computeShaderGraph")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> computeShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#enabledLayers-prop">Qt3DRender::QShaderProgramBuilder::enabledLayersChanged(QStringList)</a></p>
     */
    @QtPropertyNotify(name="enabledLayers")
    public final @NonNull Signal1<java.util.@NonNull List<java.lang.@NonNull String>> enabledLayersChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#fragmentShaderCode-prop">Qt3DRender::QShaderProgramBuilder::fragmentShaderCodeChanged(QByteArray)</a></p>
     */
    @QtPropertyNotify(name="fragmentShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> fragmentShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#fragmentShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::fragmentShaderGraphChanged(QUrl)</a></p>
     */
    @QtPropertyNotify(name="fragmentShaderGraph")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> fragmentShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#geometryShaderCode-prop">Qt3DRender::QShaderProgramBuilder::geometryShaderCodeChanged(QByteArray)</a></p>
     */
    @QtPropertyNotify(name="geometryShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> geometryShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#geometryShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::geometryShaderGraphChanged(QUrl)</a></p>
     */
    @QtPropertyNotify(name="geometryShaderGraph")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> geometryShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#shaderProgram-prop">Qt3DRender::QShaderProgramBuilder::shaderProgramChanged(Qt3DRender::QShaderProgram*)</a></p>
     */
    @QtPropertyNotify(name="shaderProgram")
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QShaderProgram> shaderProgramChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderCode-prop">Qt3DRender::QShaderProgramBuilder::tessellationControlShaderCodeChanged(QByteArray)</a></p>
     */
    @QtPropertyNotify(name="tessellationControlShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> tessellationControlShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::tessellationControlShaderGraphChanged(QUrl)</a></p>
     */
    @QtPropertyNotify(name="tessellationControlShaderGraph")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> tessellationControlShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderCode-prop">Qt3DRender::QShaderProgramBuilder::tessellationEvaluationShaderCodeChanged(QByteArray)</a></p>
     */
    @QtPropertyNotify(name="tessellationEvaluationShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> tessellationEvaluationShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::tessellationEvaluationShaderGraphChanged(QUrl)</a></p>
     */
    @QtPropertyNotify(name="tessellationEvaluationShaderGraph")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> tessellationEvaluationShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#vertexShaderCode-prop">Qt3DRender::QShaderProgramBuilder::vertexShaderCodeChanged(QByteArray)</a></p>
     */
    @QtPropertyNotify(name="vertexShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> vertexShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#vertexShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::vertexShaderGraphChanged(QUrl)</a></p>
     */
    @QtPropertyNotify(name="vertexShaderGraph")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> vertexShaderGraphChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QShaderProgramBuilder(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QShaderProgramBuilder() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QShaderProgramBuilder(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QShaderProgramBuilder instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #computeShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getComputeShaderCode() {
        return computeShaderCode();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#computeShaderCode-prop">Qt3DRender::QShaderProgramBuilder::computeShaderCode()const</a></p>
     */
    @QtPropertyReader(name="computeShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray computeShaderCode(){
        return computeShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray computeShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #computeShaderGraph()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getComputeShaderGraph() {
        return computeShaderGraph();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#computeShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::computeShaderGraph()const</a></p>
     */
    @QtPropertyReader(name="computeShaderGraph")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl computeShaderGraph(){
        return computeShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl computeShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #enabledLayers()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getEnabledLayers() {
        return enabledLayers();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#enabledLayers-prop">Qt3DRender::QShaderProgramBuilder::enabledLayers()const</a></p>
     */
    @QtPropertyReader(name="enabledLayers")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList enabledLayers(){
        return enabledLayers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList enabledLayers_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #fragmentShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getFragmentShaderCode() {
        return fragmentShaderCode();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#fragmentShaderCode-prop">Qt3DRender::QShaderProgramBuilder::fragmentShaderCode()const</a></p>
     */
    @QtPropertyReader(name="fragmentShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray fragmentShaderCode(){
        return fragmentShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray fragmentShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #fragmentShaderGraph()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getFragmentShaderGraph() {
        return fragmentShaderGraph();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#fragmentShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::fragmentShaderGraph()const</a></p>
     */
    @QtPropertyReader(name="fragmentShaderGraph")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl fragmentShaderGraph(){
        return fragmentShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl fragmentShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #geometryShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getGeometryShaderCode() {
        return geometryShaderCode();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#geometryShaderCode-prop">Qt3DRender::QShaderProgramBuilder::geometryShaderCode()const</a></p>
     */
    @QtPropertyReader(name="geometryShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray geometryShaderCode(){
        return geometryShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray geometryShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #geometryShaderGraph()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getGeometryShaderGraph() {
        return geometryShaderGraph();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#geometryShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::geometryShaderGraph()const</a></p>
     */
    @QtPropertyReader(name="geometryShaderGraph")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl geometryShaderGraph(){
        return geometryShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl geometryShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#computeShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::setComputeShaderGraph(QUrl)</a></p>
     */
    @QtPropertyWriter(name="computeShaderGraph")
    public final void setComputeShaderGraph(io.qt.core.@NonNull QUrl computeShaderGraph){
        setComputeShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(computeShaderGraph));
    }
    
    private native void setComputeShaderGraph_native_cref_QUrl(long __this__nativeId, long computeShaderGraph);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#enabledLayers-prop">Qt3DRender::QShaderProgramBuilder::setEnabledLayers(QStringList)</a></p>
     */
    @QtPropertyWriter(name="enabledLayers")
    public final void setEnabledLayers(java.util.@NonNull Collection<java.lang.@NonNull String> layers){
        setEnabledLayers_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), layers);
    }
    
    private native void setEnabledLayers_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> layers);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#fragmentShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::setFragmentShaderGraph(QUrl)</a></p>
     */
    @QtPropertyWriter(name="fragmentShaderGraph")
    public final void setFragmentShaderGraph(io.qt.core.@NonNull QUrl fragmentShaderGraph){
        setFragmentShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(fragmentShaderGraph));
    }
    
    private native void setFragmentShaderGraph_native_cref_QUrl(long __this__nativeId, long fragmentShaderGraph);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#geometryShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::setGeometryShaderGraph(QUrl)</a></p>
     */
    @QtPropertyWriter(name="geometryShaderGraph")
    public final void setGeometryShaderGraph(io.qt.core.@NonNull QUrl geometryShaderGraph){
        setGeometryShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(geometryShaderGraph));
    }
    
    private native void setGeometryShaderGraph_native_cref_QUrl(long __this__nativeId, long geometryShaderGraph);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#shaderProgram-prop">Qt3DRender::QShaderProgramBuilder::setShaderProgram(Qt3DRender::QShaderProgram*)</a></p>
     */
    @QtPropertyWriter(name="shaderProgram")
    public final void setShaderProgram(io.qt.qt3d.render.@Nullable QShaderProgram program){
        setShaderProgram_native_Qt3DRender_QShaderProgram_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(program));
    }
    
    private native void setShaderProgram_native_Qt3DRender_QShaderProgram_ptr(long __this__nativeId, long program);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::setTessellationControlShaderGraph(QUrl)</a></p>
     */
    @QtPropertyWriter(name="tessellationControlShaderGraph")
    public final void setTessellationControlShaderGraph(io.qt.core.@NonNull QUrl tessellationControlShaderGraph){
        setTessellationControlShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(tessellationControlShaderGraph));
    }
    
    private native void setTessellationControlShaderGraph_native_cref_QUrl(long __this__nativeId, long tessellationControlShaderGraph);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::setTessellationEvaluationShaderGraph(QUrl)</a></p>
     */
    @QtPropertyWriter(name="tessellationEvaluationShaderGraph")
    public final void setTessellationEvaluationShaderGraph(io.qt.core.@NonNull QUrl tessellationEvaluationShaderGraph){
        setTessellationEvaluationShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(tessellationEvaluationShaderGraph));
    }
    
    private native void setTessellationEvaluationShaderGraph_native_cref_QUrl(long __this__nativeId, long tessellationEvaluationShaderGraph);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#vertexShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::setVertexShaderGraph(QUrl)</a></p>
     */
    @QtPropertyWriter(name="vertexShaderGraph")
    public final void setVertexShaderGraph(io.qt.core.@NonNull QUrl vertexShaderGraph){
        setVertexShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(vertexShaderGraph));
    }
    
    private native void setVertexShaderGraph_native_cref_QUrl(long __this__nativeId, long vertexShaderGraph);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #shaderProgram()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QShaderProgram getShaderProgram() {
        return shaderProgram();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#shaderProgram-prop">Qt3DRender::QShaderProgramBuilder::shaderProgram()const</a></p>
     */
    @QtPropertyReader(name="shaderProgram")
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QShaderProgram shaderProgram(){
        return shaderProgram_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QShaderProgram shaderProgram_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #tessellationControlShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getTessellationControlShaderCode() {
        return tessellationControlShaderCode();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderCode-prop">Qt3DRender::QShaderProgramBuilder::tessellationControlShaderCode()const</a></p>
     */
    @QtPropertyReader(name="tessellationControlShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray tessellationControlShaderCode(){
        return tessellationControlShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray tessellationControlShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #tessellationControlShaderGraph()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getTessellationControlShaderGraph() {
        return tessellationControlShaderGraph();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::tessellationControlShaderGraph()const</a></p>
     */
    @QtPropertyReader(name="tessellationControlShaderGraph")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl tessellationControlShaderGraph(){
        return tessellationControlShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl tessellationControlShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #tessellationEvaluationShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getTessellationEvaluationShaderCode() {
        return tessellationEvaluationShaderCode();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderCode-prop">Qt3DRender::QShaderProgramBuilder::tessellationEvaluationShaderCode()const</a></p>
     */
    @QtPropertyReader(name="tessellationEvaluationShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray tessellationEvaluationShaderCode(){
        return tessellationEvaluationShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray tessellationEvaluationShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #tessellationEvaluationShaderGraph()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getTessellationEvaluationShaderGraph() {
        return tessellationEvaluationShaderGraph();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::tessellationEvaluationShaderGraph()const</a></p>
     */
    @QtPropertyReader(name="tessellationEvaluationShaderGraph")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl tessellationEvaluationShaderGraph(){
        return tessellationEvaluationShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl tessellationEvaluationShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vertexShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getVertexShaderCode() {
        return vertexShaderCode();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#vertexShaderCode-prop">Qt3DRender::QShaderProgramBuilder::vertexShaderCode()const</a></p>
     */
    @QtPropertyReader(name="vertexShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray vertexShaderCode(){
        return vertexShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray vertexShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vertexShaderGraph()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getVertexShaderGraph() {
        return vertexShaderGraph();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#vertexShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::vertexShaderGraph()const</a></p>
     */
    @QtPropertyReader(name="vertexShaderGraph")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl vertexShaderGraph(){
        return vertexShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl vertexShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QShaderProgramBuilder(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QShaderProgramBuilder(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QShaderProgramBuilder instance, QDeclarativeConstructor constructor);
    
}
