package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Provides Image access to shader programs</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html">Qt3DRender::QShaderImage</a></p>
 */
public class QShaderImage extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QShaderImage.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#Access-enum">Qt3DRender::QShaderImage::Access</a></p>
     */
    public enum Access implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#Access-enum">Qt3DRender::QShaderImage::ReadOnly</a></p>
         */
        ReadOnly(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#Access-enum">Qt3DRender::QShaderImage::WriteOnly</a></p>
         */
        WriteOnly(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#Access-enum">Qt3DRender::QShaderImage::ReadWrite</a></p>
         */
        ReadWrite(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Access(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Access resolve(int value) {
            switch (value) {
            case 0: return ReadOnly;
            case 1: return WriteOnly;
            case 2: return ReadWrite;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::ImageFormat</a></p>
     */
    public enum ImageFormat implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::NoFormat</a></p>
         */
        NoFormat(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::Automatic</a></p>
         */
        Automatic(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::R8_UNorm</a></p>
         */
        R8_UNorm(33321),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RG8_UNorm</a></p>
         */
        RG8_UNorm(33323),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RGBA8_UNorm</a></p>
         */
        RGBA8_UNorm(32856),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::R16_UNorm</a></p>
         */
        R16_UNorm(33322),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RG16_UNorm</a></p>
         */
        RG16_UNorm(33324),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RGBA16_UNorm</a></p>
         */
        RGBA16_UNorm(32859),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::R8_SNorm</a></p>
         */
        R8_SNorm(36756),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RG8_SNorm</a></p>
         */
        RG8_SNorm(36757),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RGBA8_SNorm</a></p>
         */
        RGBA8_SNorm(36759),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::R16_SNorm</a></p>
         */
        R16_SNorm(36760),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RG16_SNorm</a></p>
         */
        RG16_SNorm(36761),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RGBA16_SNorm</a></p>
         */
        RGBA16_SNorm(36763),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::R8U</a></p>
         */
        R8U(33330),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RG8U</a></p>
         */
        RG8U(33336),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RGBA8U</a></p>
         */
        RGBA8U(36220),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::R16U</a></p>
         */
        R16U(33332),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RG16U</a></p>
         */
        RG16U(33338),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RGBA16U</a></p>
         */
        RGBA16U(36214),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::R32U</a></p>
         */
        R32U(33334),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RG32U</a></p>
         */
        RG32U(33340),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RGBA32U</a></p>
         */
        RGBA32U(36208),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::R8I</a></p>
         */
        R8I(33329),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RG8I</a></p>
         */
        RG8I(33335),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RGBA8I</a></p>
         */
        RGBA8I(36238),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::R16I</a></p>
         */
        R16I(33331),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RG16I</a></p>
         */
        RG16I(33337),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RGBA16I</a></p>
         */
        RGBA16I(36232),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::R32I</a></p>
         */
        R32I(33333),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RG32I</a></p>
         */
        RG32I(33339),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RGBA32I</a></p>
         */
        RGBA32I(36226),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::R16F</a></p>
         */
        R16F(33325),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RG16F</a></p>
         */
        RG16F(33327),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RGBA16F</a></p>
         */
        RGBA16F(34842),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::R32F</a></p>
         */
        R32F(33326),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RG32F</a></p>
         */
        RG32F(33328),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RGBA32F</a></p>
         */
        RGBA32F(34836),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RG11B10F</a></p>
         */
        RG11B10F(35898),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RGB10A2</a></p>
         */
        RGB10A2(32857),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::RGB10A2U</a></p>
         */
        RGB10A2U(36975);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ImageFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ImageFormat resolve(int value) {
            switch (value) {
            case 0: return NoFormat;
            case 1: return Automatic;
            case 33321: return R8_UNorm;
            case 33323: return RG8_UNorm;
            case 32856: return RGBA8_UNorm;
            case 33322: return R16_UNorm;
            case 33324: return RG16_UNorm;
            case 32859: return RGBA16_UNorm;
            case 36756: return R8_SNorm;
            case 36757: return RG8_SNorm;
            case 36759: return RGBA8_SNorm;
            case 36760: return R16_SNorm;
            case 36761: return RG16_SNorm;
            case 36763: return RGBA16_SNorm;
            case 33330: return R8U;
            case 33336: return RG8U;
            case 36220: return RGBA8U;
            case 33332: return R16U;
            case 33338: return RG16U;
            case 36214: return RGBA16U;
            case 33334: return R32U;
            case 33340: return RG32U;
            case 36208: return RGBA32U;
            case 33329: return R8I;
            case 33335: return RG8I;
            case 36238: return RGBA8I;
            case 33331: return R16I;
            case 33337: return RG16I;
            case 36232: return RGBA16I;
            case 33333: return R32I;
            case 33339: return RG32I;
            case 36226: return RGBA32I;
            case 33325: return R16F;
            case 33327: return RG16F;
            case 34842: return RGBA16F;
            case 33326: return R32F;
            case 33328: return RG32F;
            case 34836: return RGBA32F;
            case 35898: return RG11B10F;
            case 32857: return RGB10A2;
            case 36975: return RGB10A2U;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#access-prop">Qt3DRender::QShaderImage::accessChanged(Qt3DRender::QShaderImage::Access)</a></p>
     */
    @QtPropertyNotify(name="access")
    public final @NonNull Signal1<io.qt.qt3d.render.QShaderImage.@NonNull Access> accessChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#format-prop">Qt3DRender::QShaderImage::formatChanged(Qt3DRender::QShaderImage::ImageFormat)</a></p>
     */
    @QtPropertyNotify(name="format")
    public final @NonNull Signal1<io.qt.qt3d.render.QShaderImage.@NonNull ImageFormat> formatChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#layer-prop">Qt3DRender::QShaderImage::layerChanged(int)</a></p>
     */
    @QtPropertyNotify(name="layer")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> layerChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#layered-prop">Qt3DRender::QShaderImage::layeredChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="layered")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> layeredChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#mipLevel-prop">Qt3DRender::QShaderImage::mipLevelChanged(int)</a></p>
     */
    @QtPropertyNotify(name="mipLevel")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> mipLevelChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#texture-prop">Qt3DRender::QShaderImage::textureChanged(Qt3DRender::QAbstractTexture*)</a></p>
     */
    @QtPropertyNotify(name="texture")
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QAbstractTexture> textureChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QShaderImage(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QShaderImage() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QShaderImage(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QShaderImage instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #access()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QShaderImage.@NonNull Access getAccess() {
        return access();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#access-prop">Qt3DRender::QShaderImage::access()const</a></p>
     */
    @QtPropertyReader(name="access")
    @QtUninvokable
    public final io.qt.qt3d.render.QShaderImage.@NonNull Access access(){
        return io.qt.qt3d.render.QShaderImage.Access.resolve(access_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int access_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #format()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QShaderImage.@NonNull ImageFormat getFormat() {
        return format();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#format-prop">Qt3DRender::QShaderImage::format()const</a></p>
     */
    @QtPropertyReader(name="format")
    @QtUninvokable
    public final io.qt.qt3d.render.QShaderImage.@NonNull ImageFormat format(){
        return io.qt.qt3d.render.QShaderImage.ImageFormat.resolve(format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int format_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #layer()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getLayer() {
        return layer();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#layer-prop">Qt3DRender::QShaderImage::layer()const</a></p>
     */
    @QtPropertyReader(name="layer")
    @QtUninvokable
    public final int layer(){
        return layer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int layer_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #layered()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getLayered() {
        return layered();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#layered-prop">Qt3DRender::QShaderImage::layered()const</a></p>
     */
    @QtPropertyReader(name="layered")
    @QtUninvokable
    public final boolean layered(){
        return layered_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean layered_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #mipLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMipLevel() {
        return mipLevel();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#mipLevel-prop">Qt3DRender::QShaderImage::mipLevel()const</a></p>
     */
    @QtPropertyReader(name="mipLevel")
    @QtUninvokable
    public final int mipLevel(){
        return mipLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int mipLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#access-prop">Qt3DRender::QShaderImage::setAccess(Qt3DRender::QShaderImage::Access)</a></p>
     */
    @QtPropertyWriter(name="access")
    public final void setAccess(io.qt.qt3d.render.QShaderImage.@NonNull Access access){
        setAccess_native_Qt3DRender_QShaderImage_Access(QtJambi_LibraryUtilities.internal.nativeId(this), access.value());
    }
    
    private native void setAccess_native_Qt3DRender_QShaderImage_Access(long __this__nativeId, int access);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#format-prop">Qt3DRender::QShaderImage::setFormat(Qt3DRender::QShaderImage::ImageFormat)</a></p>
     */
    @QtPropertyWriter(name="format")
    public final void setFormat(io.qt.qt3d.render.QShaderImage.@NonNull ImageFormat format){
        setFormat_native_Qt3DRender_QShaderImage_ImageFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    private native void setFormat_native_Qt3DRender_QShaderImage_ImageFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#layer-prop">Qt3DRender::QShaderImage::setLayer(int)</a></p>
     */
    @QtPropertyWriter(name="layer")
    public final void setLayer(int layer){
        setLayer_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layer);
    }
    
    private native void setLayer_native_int(long __this__nativeId, int layer);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#layered-prop">Qt3DRender::QShaderImage::setLayered(bool)</a></p>
     */
    @QtPropertyWriter(name="layered")
    public final void setLayered(boolean layered){
        setLayered_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), layered);
    }
    
    private native void setLayered_native_bool(long __this__nativeId, boolean layered);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#mipLevel-prop">Qt3DRender::QShaderImage::setMipLevel(int)</a></p>
     */
    @QtPropertyWriter(name="mipLevel")
    public final void setMipLevel(int mipLevel){
        setMipLevel_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevel);
    }
    
    private native void setMipLevel_native_int(long __this__nativeId, int mipLevel);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#texture-prop">Qt3DRender::QShaderImage::setTexture(Qt3DRender::QAbstractTexture*)</a></p>
     */
    @QtPropertyWriter(name="texture")
    public final void setTexture(io.qt.qt3d.render.@Nullable QAbstractTexture texture){
        setTexture_native_Qt3DRender_QAbstractTexture_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(texture));
    }
    
    private native void setTexture_native_Qt3DRender_QAbstractTexture_ptr(long __this__nativeId, long texture);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #texture()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QAbstractTexture getTexture() {
        return texture();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#texture-prop">Qt3DRender::QShaderImage::texture()const</a></p>
     */
    @QtPropertyReader(name="texture")
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QAbstractTexture texture(){
        return texture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QAbstractTexture texture_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QShaderImage(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QShaderImage(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QShaderImage instance, QDeclarativeConstructor constructor);
    
}
