package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Holds settings related to available rendering engines</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html">Qt3DRender::QRenderCapabilities</a></p>
 */
public class QRenderCapabilities extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderCapabilities.class);
    
    /**
     * <p>Java wrapper for Qt enum Qt3DRender::QRenderCapabilities::API</p>
     */
    public enum API implements QtEnumerator {
        /**
         * <p>Representing Qt3DRender::QRenderCapabilities::OpenGL</p>
         */
        OpenGL(1),
        /**
         * <p>Representing Qt3DRender::QRenderCapabilities::OpenGLES</p>
         */
        OpenGLES(2),
        /**
         * <p>Representing Qt3DRender::QRenderCapabilities::Vulkan</p>
         */
        Vulkan(3),
        /**
         * <p>Representing Qt3DRender::QRenderCapabilities::DirectX</p>
         */
        DirectX(4),
        /**
         * <p>Representing Qt3DRender::QRenderCapabilities::RHI</p>
         */
        RHI(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private API(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull API resolve(int value) {
            switch (value) {
            case 1: return OpenGL;
            case 2: return OpenGLES;
            case 3: return Vulkan;
            case 4: return DirectX;
            case 5: return RHI;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum Qt3DRender::QRenderCapabilities::Profile</p>
     */
    public enum Profile implements QtEnumerator {
        /**
         * <p>Representing Qt3DRender::QRenderCapabilities::NoProfile</p>
         */
        NoProfile(0),
        /**
         * <p>Representing Qt3DRender::QRenderCapabilities::CoreProfile</p>
         */
        CoreProfile(1),
        /**
         * <p>Representing Qt3DRender::QRenderCapabilities::CompatibilityProfile</p>
         */
        CompatibilityProfile(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Profile(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Profile resolve(int value) {
            switch (value) {
            case 0: return NoProfile;
            case 1: return CoreProfile;
            case 2: return CompatibilityProfile;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QRenderCapabilities(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QRenderCapabilities() {
        this((io.qt.core.QObject)null);
    }
    
    public QRenderCapabilities(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRenderCapabilities instance, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #api()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderCapabilities.@NonNull API getApi() {
        return api();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#api-prop">Qt3DRender::QRenderCapabilities::api()const</a></p>
     */
    @QtPropertyReader(name="api")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderCapabilities.@NonNull API api(){
        return io.qt.qt3d.render.QRenderCapabilities.API.resolve(api_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int api_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #driverVersion()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getDriverVersion() {
        return driverVersion();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#driverVersion-prop">Qt3DRender::QRenderCapabilities::driverVersion()const</a></p>
     */
    @QtPropertyReader(name="driverVersion")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String driverVersion(){
        return driverVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String driverVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #extensions()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getExtensions() {
        return extensions();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#extensions-prop">Qt3DRender::QRenderCapabilities::extensions()const</a></p>
     */
    @QtPropertyReader(name="extensions")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList extensions(){
        return extensions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList extensions_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #glslVersion()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getGlslVersion() {
        return glslVersion();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#glslVersion-prop">Qt3DRender::QRenderCapabilities::glslVersion()const</a></p>
     */
    @QtPropertyReader(name="glslVersion")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String glslVersion(){
        return glslVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String glslVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isValid()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getValid() {
        return isValid();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#valid-prop">Qt3DRender::QRenderCapabilities::isValid()const</a></p>
     */
    @QtPropertyReader(name="valid")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #majorVersion()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMajorVersion() {
        return majorVersion();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#majorVersion-prop">Qt3DRender::QRenderCapabilities::majorVersion()const</a></p>
     */
    @QtPropertyReader(name="majorVersion")
    @QtPropertyConstant
    @QtUninvokable
    public final int majorVersion(){
        return majorVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int majorVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxComputeInvocations()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxComputeInvocations() {
        return maxComputeInvocations();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxComputeInvocations-prop">Qt3DRender::QRenderCapabilities::maxComputeInvocations()const</a></p>
     */
    @QtPropertyReader(name="maxComputeInvocations")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxComputeInvocations(){
        return maxComputeInvocations_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxComputeInvocations_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxComputeSharedMemorySize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxComputeSharedMemorySize() {
        return maxComputeSharedMemorySize();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxComputeSharedMemorySize-prop">Qt3DRender::QRenderCapabilities::maxComputeSharedMemorySize()const</a></p>
     */
    @QtPropertyReader(name="maxComputeSharedMemorySize")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxComputeSharedMemorySize(){
        return maxComputeSharedMemorySize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxComputeSharedMemorySize_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxImageUnits()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxImageUnits() {
        return maxImageUnits();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxImageUnits-prop">Qt3DRender::QRenderCapabilities::maxImageUnits()const</a></p>
     */
    @QtPropertyReader(name="maxImageUnits")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxImageUnits(){
        return maxImageUnits_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxImageUnits_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxSSBOBindings()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxSSBOBindings() {
        return maxSSBOBindings();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxSSBOBindings-prop">Qt3DRender::QRenderCapabilities::maxSSBOBindings()const</a></p>
     */
    @QtPropertyReader(name="maxSSBOBindings")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxSSBOBindings(){
        return maxSSBOBindings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxSSBOBindings_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxSSBOSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxSSBOSize() {
        return maxSSBOSize();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxSSBOSize-prop">Qt3DRender::QRenderCapabilities::maxSSBOSize()const</a></p>
     */
    @QtPropertyReader(name="maxSSBOSize")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxSSBOSize(){
        return maxSSBOSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxSSBOSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxSamples()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxSamples() {
        return maxSamples();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxSamples-prop">Qt3DRender::QRenderCapabilities::maxSamples()const</a></p>
     */
    @QtPropertyReader(name="maxSamples")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxSamples(){
        return maxSamples_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxSamples_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxTextureLayers()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxTextureLayers() {
        return maxTextureLayers();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxTextureLayers-prop">Qt3DRender::QRenderCapabilities::maxTextureLayers()const</a></p>
     */
    @QtPropertyReader(name="maxTextureLayers")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxTextureLayers(){
        return maxTextureLayers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxTextureLayers_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxTextureSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxTextureSize() {
        return maxTextureSize();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxTextureSize-prop">Qt3DRender::QRenderCapabilities::maxTextureSize()const</a></p>
     */
    @QtPropertyReader(name="maxTextureSize")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxTextureSize(){
        return maxTextureSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxTextureSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxTextureUnits()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxTextureUnits() {
        return maxTextureUnits();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxTextureUnits-prop">Qt3DRender::QRenderCapabilities::maxTextureUnits()const</a></p>
     */
    @QtPropertyReader(name="maxTextureUnits")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxTextureUnits(){
        return maxTextureUnits_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxTextureUnits_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxUBOBindings()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxUBOBindings() {
        return maxUBOBindings();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxUBOBindings-prop">Qt3DRender::QRenderCapabilities::maxUBOBindings()const</a></p>
     */
    @QtPropertyReader(name="maxUBOBindings")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxUBOBindings(){
        return maxUBOBindings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxUBOBindings_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxUBOSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxUBOSize() {
        return maxUBOSize();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxUBOSize-prop">Qt3DRender::QRenderCapabilities::maxUBOSize()const</a></p>
     */
    @QtPropertyReader(name="maxUBOSize")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxUBOSize(){
        return maxUBOSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxUBOSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxWorkGroupCountX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxWorkGroupCountX() {
        return maxWorkGroupCountX();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxWorkGroupCountX-prop">Qt3DRender::QRenderCapabilities::maxWorkGroupCountX()const</a></p>
     */
    @QtPropertyReader(name="maxWorkGroupCountX")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxWorkGroupCountX(){
        return maxWorkGroupCountX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxWorkGroupCountX_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxWorkGroupCountY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxWorkGroupCountY() {
        return maxWorkGroupCountY();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxWorkGroupCountY-prop">Qt3DRender::QRenderCapabilities::maxWorkGroupCountY()const</a></p>
     */
    @QtPropertyReader(name="maxWorkGroupCountY")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxWorkGroupCountY(){
        return maxWorkGroupCountY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxWorkGroupCountY_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxWorkGroupCountZ()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxWorkGroupCountZ() {
        return maxWorkGroupCountZ();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxWorkGroupCountZ-prop">Qt3DRender::QRenderCapabilities::maxWorkGroupCountZ()const</a></p>
     */
    @QtPropertyReader(name="maxWorkGroupCountZ")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxWorkGroupCountZ(){
        return maxWorkGroupCountZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxWorkGroupCountZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxWorkGroupSizeX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxWorkGroupSizeX() {
        return maxWorkGroupSizeX();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxWorkGroupSizeX-prop">Qt3DRender::QRenderCapabilities::maxWorkGroupSizeX()const</a></p>
     */
    @QtPropertyReader(name="maxWorkGroupSizeX")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxWorkGroupSizeX(){
        return maxWorkGroupSizeX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxWorkGroupSizeX_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxWorkGroupSizeY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxWorkGroupSizeY() {
        return maxWorkGroupSizeY();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxWorkGroupSizeY-prop">Qt3DRender::QRenderCapabilities::maxWorkGroupSizeY()const</a></p>
     */
    @QtPropertyReader(name="maxWorkGroupSizeY")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxWorkGroupSizeY(){
        return maxWorkGroupSizeY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxWorkGroupSizeY_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxWorkGroupSizeZ()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxWorkGroupSizeZ() {
        return maxWorkGroupSizeZ();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxWorkGroupSizeZ-prop">Qt3DRender::QRenderCapabilities::maxWorkGroupSizeZ()const</a></p>
     */
    @QtPropertyReader(name="maxWorkGroupSizeZ")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxWorkGroupSizeZ(){
        return maxWorkGroupSizeZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxWorkGroupSizeZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minorVersion()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMinorVersion() {
        return minorVersion();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#minorVersion-prop">Qt3DRender::QRenderCapabilities::minorVersion()const</a></p>
     */
    @QtPropertyReader(name="minorVersion")
    @QtPropertyConstant
    @QtUninvokable
    public final int minorVersion(){
        return minorVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int minorVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #profile()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderCapabilities.@NonNull Profile getProfile() {
        return profile();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#profile-prop">Qt3DRender::QRenderCapabilities::profile()const</a></p>
     */
    @QtPropertyReader(name="profile")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderCapabilities.@NonNull Profile profile(){
        return io.qt.qt3d.render.QRenderCapabilities.Profile.resolve(profile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int profile_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #renderer()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRenderer() {
        return renderer();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#renderer-prop">Qt3DRender::QRenderCapabilities::renderer()const</a></p>
     */
    @QtPropertyReader(name="renderer")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String renderer(){
        return renderer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String renderer_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #supportsCompute()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSupportsCompute() {
        return supportsCompute();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#supportsCompute-prop">Qt3DRender::QRenderCapabilities::supportsCompute()const</a></p>
     */
    @QtPropertyReader(name="supportsCompute")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean supportsCompute(){
        return supportsCompute_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean supportsCompute_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #supportsImageStore()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSupportsImageStore() {
        return supportsImageStore();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#supportsImageStore-prop">Qt3DRender::QRenderCapabilities::supportsImageStore()const</a></p>
     */
    @QtPropertyReader(name="supportsImageStore")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean supportsImageStore(){
        return supportsImageStore_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean supportsImageStore_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #supportsSSBO()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSupportsSSBO() {
        return supportsSSBO();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#supportsSSBO-prop">Qt3DRender::QRenderCapabilities::supportsSSBO()const</a></p>
     */
    @QtPropertyReader(name="supportsSSBO")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean supportsSSBO(){
        return supportsSSBO_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean supportsSSBO_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #supportsUBO()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSupportsUBO() {
        return supportsUBO();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#supportsUBO-prop">Qt3DRender::QRenderCapabilities::supportsUBO()const</a></p>
     */
    @QtPropertyReader(name="supportsUBO")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean supportsUBO(){
        return supportsUBO_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean supportsUBO_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vendor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getVendor() {
        return vendor();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#vendor-prop">Qt3DRender::QRenderCapabilities::vendor()const</a></p>
     */
    @QtPropertyReader(name="vendor")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String vendor(){
        return vendor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String vendor_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QRenderCapabilities(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRenderCapabilities(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRenderCapabilities instance, QDeclarativeConstructor constructor);
    
}
