package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Details of a hit when casting a ray through a model</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html">Qt3DRender::QRayCasterHit</a></p>
 */
public class QRayCasterHit extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRayCasterHit.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#HitType-enum">Qt3DRender::QRayCasterHit::HitType</a></p>
     */
    public enum HitType implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#HitType-enum">Qt3DRender::QRayCasterHit::TriangleHit</a></p>
         */
        TriangleHit(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#HitType-enum">Qt3DRender::QRayCasterHit::LineHit</a></p>
         */
        LineHit(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#HitType-enum">Qt3DRender::QRayCasterHit::PointHit</a></p>
         */
        PointHit(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#HitType-enum">Qt3DRender::QRayCasterHit::EntityHit</a></p>
         */
        EntityHit(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private HitType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull HitType resolve(int value) {
            switch (value) {
            case 0: return TriangleHit;
            case 1: return LineHit;
            case 2: return PointHit;
            case 3: return EntityHit;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    public QRayCasterHit(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QRayCasterHit instance);
    
    @SuppressWarnings({"exports"})
    public QRayCasterHit(io.qt.qt3d.render.QRayCasterHit.@NonNull HitType type, io.qt.qt3d.core.@NonNull QNodeId id, float distance, io.qt.gui.@NonNull QVector3D localIntersect, io.qt.gui.@NonNull QVector3D worldIntersect, int primitiveIndex, int v1, int v2, int v3){
        super((QPrivateConstructor)null);
        initialize_native(this, type, id, distance, localIntersect, worldIntersect, primitiveIndex, v1, v2, v3);
    }
    
    private native static void initialize_native(QRayCasterHit instance, io.qt.qt3d.render.QRayCasterHit.HitType type, io.qt.qt3d.core.QNodeId id, float distance, io.qt.gui.QVector3D localIntersect, io.qt.gui.QVector3D worldIntersect, int primitiveIndex, int v1, int v2, int v3);
    
    public QRayCasterHit(io.qt.qt3d.render.@NonNull QRayCasterHit other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QRayCasterHit instance, io.qt.qt3d.render.QRayCasterHit other);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #distance()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDistance() {
        return distance();
    }
    
    /**
     * <p>Returns the distance between the origin of the ray and the intersection point</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#distance">Qt3DRender::QRayCasterHit::distance()const</a></p>
     */
    @QtPropertyReader(name="distance")
    @QtPropertyConstant
    @QtUninvokable
    public final float distance(){
        return distance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float distance_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #entity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QEntity getEntity() {
        return entity();
    }
    
    /**
     * <p>Returns a pointer to the entity that was hit</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#entity">Qt3DRender::QRayCasterHit::entity()const</a></p>
     */
    @QtPropertyReader(name="entity")
    @QtPropertyConstant
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QEntity entity(){
        return entity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QEntity entity_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #entityId()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.core.@NonNull QNodeId getEntityId() {
        return entityId();
    }
    
    /**
     * <p>Returns the id of the entity that was hit</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#entityId">Qt3DRender::QRayCasterHit::entityId()const</a></p>
     */
    @QtPropertyReader(name="entityId")
    @QtPropertyConstant
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.core.@NonNull QNodeId entityId(){
        return entityId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QNodeId entityId_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #localIntersection()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getLocalIntersection() {
        return localIntersection();
    }
    
    /**
     * <p>Returns the coordinates of the intersection point in the entity's coordinate system</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#localIntersection">Qt3DRender::QRayCasterHit::localIntersection()const</a></p>
     */
    @QtPropertyReader(name="localIntersection")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D localIntersection(){
        return localIntersection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D localIntersection_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final void assign(io.qt.qt3d.render.@NonNull QRayCasterHit other){
        assign_native_cref_Qt3DRender_QRayCasterHit(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_Qt3DRender_QRayCasterHit(long __this__nativeId, long other);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #primitiveIndex()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getPrimitiveIndex() {
        return primitiveIndex();
    }
    
    /**
     * <p>Returns the index of the picked primitive</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#primitiveIndex">Qt3DRender::QRayCasterHit::primitiveIndex()const</a></p>
     */
    @QtPropertyReader(name="primitiveIndex")
    @QtPropertyConstant
    @QtUninvokable
    public final int primitiveIndex(){
        return primitiveIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int primitiveIndex_native_constfct(long __this__nativeId);
    
    public final java.lang.@NonNull String toString(){
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native java.lang.String toString_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #type()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QRayCasterHit.@NonNull HitType getType() {
        return type();
    }
    
    /**
     * <p>Returns the type of the hit</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#type">Qt3DRender::QRayCasterHit::type()const</a></p>
     */
    @QtPropertyReader(name="type")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.render.QRayCasterHit.@NonNull HitType type(){
        return io.qt.qt3d.render.QRayCasterHit.HitType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vertex1Index()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVertex1Index() {
        return vertex1Index();
    }
    
    /**
     * <p>Returns the index of the first vertex of the picked primitive</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#vertex1Index">Qt3DRender::QRayCasterHit::vertex1Index()const</a></p>
     */
    @QtPropertyReader(name="vertex1Index")
    @QtPropertyConstant
    @QtUninvokable
    public final int vertex1Index(){
        return vertex1Index_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int vertex1Index_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vertex2Index()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVertex2Index() {
        return vertex2Index();
    }
    
    /**
     * <p>Returns the index of the second vertex of the picked primitive</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#vertex2Index">Qt3DRender::QRayCasterHit::vertex2Index()const</a></p>
     */
    @QtPropertyReader(name="vertex2Index")
    @QtPropertyConstant
    @QtUninvokable
    public final int vertex2Index(){
        return vertex2Index_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int vertex2Index_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vertex3Index()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVertex3Index() {
        return vertex3Index();
    }
    
    /**
     * <p>Returns the index of the third vertex of the picked primitive</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#vertex3Index">Qt3DRender::QRayCasterHit::vertex3Index()const</a></p>
     */
    @QtPropertyReader(name="vertex3Index")
    @QtPropertyConstant
    @QtUninvokable
    public final int vertex3Index(){
        return vertex3Index_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int vertex3Index_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #worldIntersection()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getWorldIntersection() {
        return worldIntersection();
    }
    
    /**
     * <p>Returns the coordinates of the intersection point in the model's coordinate system</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qraycasterhit.html#worldIntersection">Qt3DRender::QRayCasterHit::worldIntersection()const</a></p>
     */
    @QtPropertyReader(name="worldIntersection")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D worldIntersection(){
        return worldIntersection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D worldIntersection_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QRayCasterHit(QPrivateConstructor p) { super(p); } 
    
    
    @QtUninvokable
    @Override
    public QRayCasterHit clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QRayCasterHit clone_native(long __this_nativeId);
}
