package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Holds information when a segment of a point cloud is picked</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qpickpointevent.html">Qt3DRender::QPickPointEvent</a></p>
 */
public class QPickPointEvent extends io.qt.qt3d.render.QPickEvent
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPickPointEvent.class);
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickpointevent.html#QPickPointEvent">Qt3DRender::QPickPointEvent::QPickPointEvent()</a></p>
     */
    public QPickPointEvent(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QPickPointEvent instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickpointevent.html#QPickPointEvent">Qt3DRender::QPickPointEvent::QPickPointEvent(QPointF,QVector3D,QVector3D,float,uint,Buttons,int,int)</a></p>
     */
    public QPickPointEvent(io.qt.core.@NonNull QPointF position, io.qt.gui.@NonNull QVector3D worldIntersection, io.qt.gui.@NonNull QVector3D localIntersection, float distance, int pointIndex, io.qt.qt3d.render.QPickEvent.@NonNull Buttons button, int buttons, int modifiers){
        super((QPrivateConstructor)null);
        initialize_native(this, position, worldIntersection, localIntersection, distance, pointIndex, button, buttons, modifiers);
    }
    
    private native static void initialize_native(QPickPointEvent instance, io.qt.core.QPointF position, io.qt.gui.QVector3D worldIntersection, io.qt.gui.QVector3D localIntersection, float distance, int pointIndex, io.qt.qt3d.render.QPickEvent.Buttons button, int buttons, int modifiers);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #pointIndex()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getPointIndex() {
        return pointIndex();
    }
    
    /**
     * <p>QPickPointEvent::pointIndex Returns the index of the picked point</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickpointevent.html#pointIndex">Qt3DRender::QPickPointEvent::pointIndex()const</a></p>
     */
    @QtPropertyReader(name="pointIndex")
    @QtPropertyConstant
    @QtUninvokable
    public final int pointIndex(){
        return pointIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int pointIndex_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QPickPointEvent(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QPickPointEvent(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPickPointEvent instance, QDeclarativeConstructor constructor);
    
}
