package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Provides storage for a name and value pair. This maps to a shader uniform</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qparameter.html">Qt3DRender::QParameter</a></p>
 */
public class QParameter extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QParameter.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qparameter.html#name-prop">Qt3DRender::QParameter::nameChanged(QString)</a></p>
     */
    @QtPropertyNotify(name="name")
    public final @NonNull Signal1<java.lang.@NonNull String> nameChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qparameter.html#value-prop">Qt3DRender::QParameter::valueChanged(QVariant)</a></p>
     */
    @QtPropertyNotify(name="value")
    public final @NonNull Signal1<java.lang.Object> valueChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QParameter(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QParameter() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qparameter.html#QParameter">Qt3DRender::QParameter::QParameter(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QParameter(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QParameter instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded constructor for {@link #QParameter(java.lang.String, io.qt.qt3d.render.QAbstractTexture, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QParameter(java.lang.@NonNull String name, io.qt.qt3d.render.@Nullable QAbstractTexture texture) {
        this(name, texture, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qparameter.html#QParameter-2">Qt3DRender::QParameter::QParameter(QString,Qt3DRender::QAbstractTexture*,Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QParameter(java.lang.@NonNull String name, io.qt.qt3d.render.@Nullable QAbstractTexture texture, io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, name, texture, parent);
    }
    
    private native static void initialize_native(QParameter instance, java.lang.String name, io.qt.qt3d.render.QAbstractTexture texture, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded constructor for {@link #QParameter(java.lang.String, java.lang.Object, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QParameter(java.lang.@NonNull String name, java.lang.Object value) {
        this(name, value, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qparameter.html#QParameter-1">Qt3DRender::QParameter::QParameter(QString,QVariant,Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QParameter(java.lang.@NonNull String name, java.lang.Object value, io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, name, value, parent);
    }
    
    private native static void initialize_native(QParameter instance, java.lang.String name, java.lang.Object value, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #name()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getName() {
        return name();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qparameter.html#name-prop">Qt3DRender::QParameter::name()const</a></p>
     */
    @QtPropertyReader(name="name")
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qparameter.html#name-prop">Qt3DRender::QParameter::setName(QString)</a></p>
     */
    @QtPropertyWriter(name="name")
    public final void setName(java.lang.@NonNull String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qparameter.html#value-prop">Qt3DRender::QParameter::setValue(QVariant)</a></p>
     */
    @QtPropertyWriter(name="value")
    public final void setValue(java.lang.Object dv){
        setValue_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), dv);
    }
    
    private native void setValue_native_cref_QVariant(long __this__nativeId, java.lang.Object dv);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #value()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.Object getValue() {
        return value();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qparameter.html#value-prop">Qt3DRender::QParameter::value()const</a></p>
     */
    @QtPropertyReader(name="value")
    @QtUninvokable
    public final java.lang.Object value(){
        return value_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Object value_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QParameter(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QParameter(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QParameter instance, QDeclarativeConstructor constructor);
    
}
