package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Instantiates a component that can be used to interact with a QEntity by a process known as picking</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html">Qt3DRender::QObjectPicker</a></p>
 */
public class QObjectPicker extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QObjectPicker.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#clicked">Qt3DRender::QObjectPicker::clicked(Qt3DRender::QPickEvent*)</a></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QPickEvent> clicked = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#containsMouse-prop">Qt3DRender::QObjectPicker::containsMouseChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="containsMouse")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> containsMouseChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#dragEnabled-prop">Qt3DRender::QObjectPicker::dragEnabledChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="dragEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> dragEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#entered">Qt3DRender::QObjectPicker::entered()</a></p>
     */
    public final @NonNull Signal0 entered = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#exited">Qt3DRender::QObjectPicker::exited()</a></p>
     */
    public final @NonNull Signal0 exited = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#hoverEnabled-prop">Qt3DRender::QObjectPicker::hoverEnabledChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="hoverEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> hoverEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#moved">Qt3DRender::QObjectPicker::moved(Qt3DRender::QPickEvent*)</a></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QPickEvent> moved = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#pressed">Qt3DRender::QObjectPicker::pressed(Qt3DRender::QPickEvent*)</a></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QPickEvent> pressed = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#pressed-prop">Qt3DRender::QObjectPicker::pressedChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="pressed")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> pressedChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#priority-prop">Qt3DRender::QObjectPicker::priorityChanged(int)</a></p>
     */
    @QtPropertyNotify(name="priority")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> priorityChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#released">Qt3DRender::QObjectPicker::released(Qt3DRender::QPickEvent*)</a></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QPickEvent> released = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QObjectPicker(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QObjectPicker() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QObjectPicker(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QObjectPicker instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #containsMouse()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getContainsMouse() {
        return containsMouse();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#containsMouse">Qt3DRender::QObjectPicker::containsMouse()const</a></p>
     */
    @QtPropertyReader(name="containsMouse")
    @QtUninvokable
    public final boolean containsMouse(){
        return containsMouse_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean containsMouse_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isDragEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getDragEnabled() {
        return isDragEnabled();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#isDragEnabled">Qt3DRender::QObjectPicker::isDragEnabled()const</a></p>
     */
    @QtPropertyReader(name="dragEnabled")
    @QtUninvokable
    public final boolean isDragEnabled(){
        return isDragEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isDragEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isHoverEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getHoverEnabled() {
        return isHoverEnabled();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#isHoverEnabled">Qt3DRender::QObjectPicker::isHoverEnabled()const</a></p>
     */
    @QtPropertyReader(name="hoverEnabled")
    @QtUninvokable
    public final boolean isHoverEnabled(){
        return isHoverEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isHoverEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isPressed()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getPressed() {
        return isPressed();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#pressed-prop">Qt3DRender::QObjectPicker::isPressed()const</a></p>
     */
    @QtPropertyReader(name="pressed")
    @QtUninvokable
    public final boolean isPressed(){
        return isPressed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isPressed_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #priority()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getPriority() {
        return priority();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#priority-prop">Qt3DRender::QObjectPicker::priority()const</a></p>
     */
    @QtPropertyReader(name="priority")
    @QtUninvokable
    public final int priority(){
        return priority_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int priority_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#setDragEnabled">Qt3DRender::QObjectPicker::setDragEnabled(bool)</a></p>
     */
    @QtPropertyWriter(name="dragEnabled")
    public final void setDragEnabled(boolean dragEnabled){
        setDragEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), dragEnabled);
    }
    
    private native void setDragEnabled_native_bool(long __this__nativeId, boolean dragEnabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#setHoverEnabled">Qt3DRender::QObjectPicker::setHoverEnabled(bool)</a></p>
     */
    @QtPropertyWriter(name="hoverEnabled")
    public final void setHoverEnabled(boolean hoverEnabled){
        setHoverEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), hoverEnabled);
    }
    
    private native void setHoverEnabled_native_bool(long __this__nativeId, boolean hoverEnabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qobjectpicker.html#setPriority">Qt3DRender::QObjectPicker::setPriority(int)</a></p>
     */
    @QtPropertyWriter(name="priority")
    public final void setPriority(int priority){
        setPriority_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), priority);
    }
    
    private native void setPriority_native_int(long __this__nativeId, int priority);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QObjectPicker(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QObjectPicker(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QObjectPicker instance, QDeclarativeConstructor constructor);
    
}
