package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Class to emplace a memory barrier</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html">Qt3DRender::QMemoryBarrier</a></p>
 */
public class QMemoryBarrier extends io.qt.qt3d.render.QFrameGraphNode
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMemoryBarrier.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::Operation</a></p>
     * 
     * @see Operations
     */
    public enum Operation implements QtFlagEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::None</a></p>
         */
        None(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::VertexAttributeArray</a></p>
         */
        VertexAttributeArray(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::ElementArray</a></p>
         */
        ElementArray(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::Uniform</a></p>
         */
        Uniform(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::TextureFetch</a></p>
         */
        TextureFetch(8),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::ShaderImageAccess</a></p>
         */
        ShaderImageAccess(16),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::Command</a></p>
         */
        Command(32),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::PixelBuffer</a></p>
         */
        PixelBuffer(64),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::TextureUpdate</a></p>
         */
        TextureUpdate(128),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::BufferUpdate</a></p>
         */
        BufferUpdate(256),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::FrameBuffer</a></p>
         */
        FrameBuffer(512),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::TransformFeedback</a></p>
         */
        TransformFeedback(1024),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::AtomicCounter</a></p>
         */
        AtomicCounter(2048),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::ShaderStorage</a></p>
         */
        ShaderStorage(4096),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::QueryBuffer</a></p>
         */
        QueryBuffer(8192),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::All</a></p>
         */
        All(-1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Operation(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull Operations asFlags() {
            return new Operations(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull Operations combined(@NonNull Operation e) {
            return new Operations(this, e);
        }

        /**
         * Creates a new {@link Operations} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull Operations flags(@Nullable Operation @NonNull... values) {
            return new Operations(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Operation resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return VertexAttributeArray;
            case 2: return ElementArray;
            case 4: return Uniform;
            case 8: return TextureFetch;
            case 16: return ShaderImageAccess;
            case 32: return Command;
            case 64: return PixelBuffer;
            case 128: return TextureUpdate;
            case 256: return BufferUpdate;
            case 512: return FrameBuffer;
            case 1024: return TransformFeedback;
            case 2048: return AtomicCounter;
            case 4096: return ShaderStorage;
            case 8192: return QueryBuffer;
            case -1: return All;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Operation}
     */
    public static final class Operations extends QFlags<Operation> implements Comparable<Operations> {
        private static final long serialVersionUID = 0xf54c38a476f13420L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new Operations where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Operations(@Nullable Operation @NonNull... args){
            super(args);
        }

        /**
         * Creates a new Operations with given <code>value</code>.
         * @param value
         */
        public Operations(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Operations
         */
        @Override
        public final @NonNull Operations combined(@StrictNonNull Operation e){
            return new Operations(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull Operations setFlag(@Nullable Operation e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull Operations setFlag(@Nullable Operation e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Operations.
         * @return array of enum entries
         */
        @Override
        public final @NonNull Operation @NonNull[] flags(){
            return super.flags(Operation.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull Operations clone(){
            return new Operations(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull Operations other){
            return Integer.compare(value(), other.value());
        }
    }
    

    public final @NonNull Signal1<io.qt.qt3d.render.QMemoryBarrier.@NonNull Operations> waitOperationsChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QMemoryBarrier(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QMemoryBarrier() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QMemoryBarrier(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMemoryBarrier instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded function for {@link #setWaitOperations(io.qt.qt3d.render.QMemoryBarrier.Operations)}.</p>
     */
    public final void setWaitOperations(io.qt.qt3d.render.QMemoryBarrier.@NonNull Operation @NonNull... operations){
        setWaitOperations(new io.qt.qt3d.render.QMemoryBarrier.Operations(operations));
    }
    
    public final void setWaitOperations(io.qt.qt3d.render.QMemoryBarrier.@NonNull Operations operations){
        setWaitOperations_native_Qt3DRender_QMemoryBarrier_Operations(QtJambi_LibraryUtilities.internal.nativeId(this), operations.value());
    }
    
    private native void setWaitOperations_native_Qt3DRender_QMemoryBarrier_Operations(long __this__nativeId, int operations);
    
    @QtUninvokable
    public final io.qt.qt3d.render.QMemoryBarrier.@NonNull Operations waitOperations(){
        return new io.qt.qt3d.render.QMemoryBarrier.Operations(waitOperations_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int waitOperations_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QMemoryBarrier(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QMemoryBarrier(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QMemoryBarrier instance, QDeclarativeConstructor constructor);
    
}
