package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Enables remapping depth values written into the depth buffer</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qdepthrange.html">Qt3DRender::QDepthRange</a></p>
 */
public class QDepthRange extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDepthRange.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthrange.html#farValue-prop">Qt3DRender::QDepthRange::farValueChanged(double)</a></p>
     */
    @QtPropertyNotify(name="farValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> farValueChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthrange.html#nearValue-prop">Qt3DRender::QDepthRange::nearValueChanged(double)</a></p>
     */
    @QtPropertyNotify(name="nearValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Double> nearValueChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QDepthRange(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QDepthRange() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QDepthRange(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QDepthRange instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #farValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getFarValue() {
        return farValue();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthrange.html#farValue-prop">Qt3DRender::QDepthRange::farValue()const</a></p>
     */
    @QtPropertyReader(name="farValue")
    @QtUninvokable
    public final double farValue(){
        return farValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double farValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #nearValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getNearValue() {
        return nearValue();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthrange.html#nearValue-prop">Qt3DRender::QDepthRange::nearValue()const</a></p>
     */
    @QtPropertyReader(name="nearValue")
    @QtUninvokable
    public final double nearValue(){
        return nearValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double nearValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthrange.html#farValue-prop">Qt3DRender::QDepthRange::setFarValue(double)</a></p>
     */
    @QtPropertyWriter(name="farValue")
    public final void setFarValue(double value){
        setFarValue_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setFarValue_native_double(long __this__nativeId, double value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthrange.html#nearValue-prop">Qt3DRender::QDepthRange::setNearValue(double)</a></p>
     */
    @QtPropertyWriter(name="nearValue")
    public final void setNearValue(double value){
        setNearValue_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setNearValue_native_double(long __this__nativeId, double value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDepthRange(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QDepthRange(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QDepthRange instance, QDeclarativeConstructor constructor);
    
}
