package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Specifies the equation used for both the RGB blend equation and the Alpha blend equation</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qblendequation.html">Qt3DRender::QBlendEquation</a></p>
 */
public class QBlendEquation extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QBlendEquation.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qblendequation.html#BlendFunction-enum">Qt3DRender::QBlendEquation::BlendFunction</a></p>
     */
    public enum BlendFunction implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qblendequation.html#BlendFunction-enum">Qt3DRender::QBlendEquation::Add</a></p>
         */
        Add(32774),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qblendequation.html#BlendFunction-enum">Qt3DRender::QBlendEquation::Subtract</a></p>
         */
        Subtract(32778),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qblendequation.html#BlendFunction-enum">Qt3DRender::QBlendEquation::ReverseSubtract</a></p>
         */
        ReverseSubtract(32779),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qblendequation.html#BlendFunction-enum">Qt3DRender::QBlendEquation::Min</a></p>
         */
        Min(32775),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qblendequation.html#BlendFunction-enum">Qt3DRender::QBlendEquation::Max</a></p>
         */
        Max(32776);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private BlendFunction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull BlendFunction resolve(int value) {
            switch (value) {
            case 32774: return Add;
            case 32778: return Subtract;
            case 32779: return ReverseSubtract;
            case 32775: return Min;
            case 32776: return Max;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblendequation.html#blendFunction-prop">Qt3DRender::QBlendEquation::blendFunctionChanged(Qt3DRender::QBlendEquation::BlendFunction)</a></p>
     */
    @QtPropertyNotify(name="blendFunction")
    public final @NonNull Signal1<io.qt.qt3d.render.QBlendEquation.@NonNull BlendFunction> blendFunctionChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QBlendEquation(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QBlendEquation() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblendequation.html#QBlendEquation">Qt3DRender::QBlendEquation::QBlendEquation(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QBlendEquation(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QBlendEquation instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #blendFunction()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QBlendEquation.@NonNull BlendFunction getBlendFunction() {
        return blendFunction();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblendequation.html#blendFunction-prop">Qt3DRender::QBlendEquation::blendFunction()const</a></p>
     */
    @QtPropertyReader(name="blendFunction")
    @QtUninvokable
    public final io.qt.qt3d.render.QBlendEquation.@NonNull BlendFunction blendFunction(){
        return io.qt.qt3d.render.QBlendEquation.BlendFunction.resolve(blendFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int blendFunction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qblendequation.html#blendFunction-prop">Qt3DRender::QBlendEquation::setBlendFunction(Qt3DRender::QBlendEquation::BlendFunction)</a></p>
     */
    @QtPropertyWriter(name="blendFunction")
    public final void setBlendFunction(io.qt.qt3d.render.QBlendEquation.@NonNull BlendFunction blendFunction){
        setBlendFunction_native_Qt3DRender_QBlendEquation_BlendFunction(QtJambi_LibraryUtilities.internal.nativeId(this), blendFunction.value());
    }
    
    private native void setBlendFunction_native_Qt3DRender_QBlendEquation_BlendFunction(long __this__nativeId, int blendFunction);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QBlendEquation(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QBlendEquation(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QBlendEquation instance, QDeclarativeConstructor constructor);
    
}
