package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Encapsulate a QAbstractLight object in a Qt 3D scene</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qabstractlight.html">Qt3DRender::QAbstractLight</a></p>
 */
public class QAbstractLight extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractLight.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qabstractlight.html#Type-enum">Qt3DRender::QAbstractLight::Type</a></p>
     */
    public enum Type implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstractlight.html#Type-enum">Qt3DRender::QAbstractLight::PointLight</a></p>
         */
        PointLight(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstractlight.html#Type-enum">Qt3DRender::QAbstractLight::DirectionalLight</a></p>
         */
        DirectionalLight(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qt3drender-qabstractlight.html#Type-enum">Qt3DRender::QAbstractLight::SpotLight</a></p>
         */
        SpotLight(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Type(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Type resolve(int value) {
            switch (value) {
            case 0: return PointLight;
            case 1: return DirectionalLight;
            case 2: return SpotLight;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstractlight.html#color-prop">Qt3DRender::QAbstractLight::colorChanged(QColor)</a></p>
     */
    @QtPropertyNotify(name="color")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> colorChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstractlight.html#intensity-prop">Qt3DRender::QAbstractLight::intensityChanged(float)</a></p>
     */
    @QtPropertyNotify(name="intensity")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> intensityChanged = new Signal1<>();
    
    /**
     * <p>Kotlin property getter. In Java use {@link #color()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getColor() {
        return color();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstractlight.html#color-prop">Qt3DRender::QAbstractLight::color()const</a></p>
     */
    @QtPropertyReader(name="color")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor color(){
        return color_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor color_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #intensity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getIntensity() {
        return intensity();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstractlight.html#intensity-prop">Qt3DRender::QAbstractLight::intensity()const</a></p>
     */
    @QtPropertyReader(name="intensity")
    @QtUninvokable
    public final float intensity(){
        return intensity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float intensity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstractlight.html#color-prop">Qt3DRender::QAbstractLight::setColor(QColor)</a></p>
     */
    @QtPropertyWriter(name="color")
    public final void setColor(io.qt.gui.@NonNull QColor color){
        setColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    private native void setColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstractlight.html#intensity-prop">Qt3DRender::QAbstractLight::setIntensity(float)</a></p>
     */
    @QtPropertyWriter(name="intensity")
    public final void setIntensity(float intensity){
        setIntensity_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), intensity);
    }
    
    private native void setIntensity_native_float(long __this__nativeId, float intensity);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #type()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractLight.@NonNull Type getType() {
        return type();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstractlight.html#type">Qt3DRender::QAbstractLight::type()const</a></p>
     */
    @QtPropertyReader(name="type")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractLight.@NonNull Type type(){
        return io.qt.qt3d.render.QAbstractLight.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAbstractLight(QPrivateConstructor p) { super(p); } 
    
}
